<?php
/**
 * Theme Default Footer
 * @package travelor
 * @since 1.0.0
 */
$copyright_one_text = !empty(cs_get_option('copyright_one_text')) ? cs_get_option('copyright_one_text') : esc_html__('Copyright ©Travelor All Rights Reserved.', 'travelor');
$copyright_one_text = str_replace('{copy}', '&copy;', $copyright_one_text);
$copyright_one_text = str_replace('{year}', date('Y'), $copyright_one_text);
$footer_one_logo = cs_get_option('footer_one_logo');


$text_center = 'text-lg-left';
if(!empty($footer_one_logo['url'])) {
    $text_center = 'text-lg-center'; 
}
?>


<div class="footer-area bg-cover"> 
    <div class="container">
        <div class="copyright-wrap pt-2 pb-2">
            <div class="row">
                <?php if(!empty($footer_one_logo['url'])) : ?>
                    <div class="col-lg-3 align-self-center">
                        <a href="index.html" class="cursor-big">
                            <img src="<?php echo esc_url($footer_one_logo['url'], 'logistic'); ?>" alt="img">
                        </a>
                    </div>
                <?php endif; ?>
                <div class="col-lg-6 align-self-center">
                    <div class="copyright-content">
                        <div class="copyright-text <?php echo esc_attr($text_center, 'logistic'); ?> pt-3 pb-3 fw-semibold">
                            <?php
                                echo wp_kses($copyright_one_text, travelor()->kses_allowed_html(array('a')));
                            ?>
                        </div>
                    </div>
                </div>
                <?php if (has_nav_menu('footer-menu')) { ?>
                    <div class="col-lg-3 mt-lg-0 mt-2 text-lg-end align-self-center">
                        <?php wp_nav_menu(array(
                            'theme_location' => 'footer-menu',
                        )); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>