<?php
/**
 * Theme Social Share Widget
 * @package Travelor
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('travelor_social_share_widget', array(
        'title' => esc_html__('Travelor: Social Share', 'travelor-core'),
        'classname' => 'travelor-social-share-about',
        'description' => esc_html__('Display Social Share widget', 'travelor-core'),
        'fields' => array(
            array(
                'id' => 'heading',
                'type' => 'text',
                'title' => esc_html__('Enter Your Header Title', 'travelor-core'),
                'default' => esc_html__('Never Miss News', 'travelor-core')
            ),
            array(
                'id' => 'travelor-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'travelor-core'),
                'fields' => array(
                    array(
                        'id' => 'travelor-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'travelor-core'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id' => 'travelor-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Ulr', 'travelor-core'),
                        'default' => '#'
                    ),
                ),
            ),
        )
    ));


    if (!function_exists('travelor_social_share_widget')) {
        function travelor_social_share_widget($args, $instance)
        {

            echo $args['before_widget'];
            

            $heading_title = $instance['heading'] ?? '';
            $socialIcon = is_array($instance['travelor-social-icon-repeater']) && !empty($instance['travelor-social-icon-repeater']) ? $instance['travelor-social-icon-repeater'] : [];


            ?>
            <div class="social-share-widget">
                <h4 class="widget-headline"><?php echo esc_html($heading_title); ?></h4>
                <ul class="social-icon style-03">
                    <?php
                    foreach ($socialIcon as $icon) {
                        printf('<li><a href="%2$s"><i class="%1$s"></i></a></li>', esc_html($icon['travelor-social-icon']), esc_url($icon['travelor-social-text']));
                    };
                    ?>
                </ul>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>