<?php
/**
 * Theme File Download Widget
 * @package Travelor
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('travelor_file_download_widget', array(
        'title' => esc_html__('Travelor: File Download', 'travelor-core'),
        'classname' => 'travelor-widget-file-download',
        'description' => esc_html__('Display File Download widget', 'travelor-core'),
        'fields' => array(
            array(
                'id' => 'title',
                'type' => 'text',
                'title' => esc_html__('Title', 'Travelor-core'),
                'default' => esc_html__('Download', 'travelor-core')
            ),

            array(
                'id' => 'travelor-file-download-repeater',
                'type' => 'repeater',
                'title' => esc_html__('File Download', 'travelor-core'),
                'fields' => array(
                    array(
                        'id' => 'travelor-file-download',
                        'type' => 'media',
                        'title' => esc_html__('File', 'travelor-core'),
                    ),
                    array(
                        'id' => 'travelor-file-download-text',
                        'type' => 'text',
                        'title' => esc_html__('File Text', 'travelor-core'),
                        'default' => esc_html__('Company Profile', 'travelor-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('travelor_file_download_widget')) {
        function travelor_file_download_widget($args, $instance)
        {

            echo $args['before_widget'];

            $title = $instance['title'] ?? '';
            $file_download = is_array($instance['travelor-file-download-repeater']) && !empty($instance['travelor-file-download-repeater']) ? $instance['travelor-file-download-repeater'] : [];


            ?>
            <div class="widget_download">
                <h5 class="widget-headline style-01"><?php echo esc_html($title); ?></h5>               
                <ul>
                    <?php
                        foreach ($file_download as $file) {
                            echo '<li class="mb-0 mt-0">
                                <a download href="'.$file['travelor-file-download']['url'].'">
                                    ' . $file['travelor-file-download-text'] . '
                                    <i class="fa fa-angle-double-right"></i>
                                </a>
                            </li>';
                        };
                    ?>
                </ul>
            </div>
            <?php

            echo $args['after_widget'];

        }
    }

}

?>