<?php
/**
 * Theme About Us Widget
 * @package Travelor
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('travelor_about_widget', array(
        'title' => esc_html__('Travelor: About Us', 'travelor-core'),
        'classname' => 'travelor-widget-about',
        'description' => esc_html__('Display about us widget', 'travelor-core'),
        'fields' => array(
            array(
                'id' => 'logo-area',
                'type' => 'media',
                'title' => esc_html__('Upload Your Photo', 'travelor-core'),
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'Travelor-core'),
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.', 'travelor-core')
            ),
            array(
                'id' => 'shortcode',
                'type' => 'textarea',
                'title' => esc_html__('Shortcode', 'Travelor-core'),
            ),

            array(
                'id' => 'travelor-footer-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'travelor-core'),
                'fields' => array(

                    array(
                        'id' => 'travelor-footer-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'travelor-core'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'travelor-footer-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Url', 'travelor-core'),
                        'default' => esc_html__('#', 'travelor-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('travelor_about_widget')) {
        function travelor_about_widget($args, $instance)
        {

            echo $args['before_widget'];

            $logo = $instance['logo-area'];
            $img_id = $logo['id'] ?? '';
            $img_print = $img_id ? wp_get_attachment_image_src($img_id,'full')[0] : '';
            $alt_text = get_post_meta($img_id, '_wp_attachment_image_alt', true);
            $paragraph = $instance['description'] ?? '';
            $shortcode = $instance['shortcode'] ?? '';
            $socialIcon = is_array($instance['travelor-footer-social-icon-repeater']) && !empty($instance['travelor-footer-social-icon-repeater']) ? $instance['travelor-footer-social-icon-repeater'] : [];


            ?>
            <div class="footer-widget widget">
                <div class="about_us_widget style-01">
                    <div class="footer-item__logo">  
                        <a href="<?php echo get_home_url(); ?>">
                            <?php
                                if (!empty($img_print)) {
                                    printf('<img src="%1$s" alt="%2$s"/>', esc_url($img_print), esc_attr($alt_text));
                                }
                            ?>  
                        </a>
                    </div>
                    <p class="my-32">
                        <?php echo $paragraph; ?>
                    </p>
                    <?php if (!empty($socialIcon)) { ?>
                        <ul class="social-list flex-align gap-24">
                            <?php
                            foreach ($socialIcon as $icon) {
                                echo '<li class="social-list__item mt-0 mb-0">
                                <div class="icon">
                                    <a class="text-main-600 text-2xl hover-text-main-two-600" href="'.$icon['travelor-footer-social-text'].'">
                                        <i class="' . $icon['travelor-footer-social-icon'] . '"></i>
                                    </a>
                                </div>
                            </li>';
                            };
                            ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>