<?php
/*
Plugin Name: Travelor Core
Plugin URI: https://themeforest.net/user/wowtheme7/portfolio
Description: Plugin to contain short codes and custom post types of the Travelor theme.
Author: Wowtheme7
Author URI: https://wowtheme7.com/
Version: 1.0.0
Text Domain: travelor-core
Developer: Md Alamgir (mdalamgirhossen576@gmail.com)
*/


/**
 * If this file is called directly, abort.
 * @package travelor
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Plugin directory path
 * @package travelor
 * @since 1.0.0
 */
define( 'TRAVELOR_CORE_ROOT_PATH', plugin_dir_path( __FILE__ ) );
define( 'TRAVELOR_CORE_ROOT_URL', plugin_dir_url( __FILE__ ) );
define( 'TRAVELOR_CORE_SELF_PATH', 'travelor-core/travelor-core.php' );
define( 'TRAVELOR_CORE_VERSION', '2.0.1' );
define( 'TRAVELOR_CORE_INC', TRAVELOR_CORE_ROOT_PATH .'/inc');
define( 'TRAVELOR_CORE_LIB', TRAVELOR_CORE_ROOT_PATH .'/lib');
define( 'TRAVELOR_CORE_ELEMENTOR', TRAVELOR_CORE_ROOT_PATH .'/elementor');
define( 'TRAVELOR_CORE_DEMO_IMPORT', TRAVELOR_CORE_ROOT_PATH .'/demo-import');
define( 'TRAVELOR_CORE_ADMIN', TRAVELOR_CORE_ROOT_PATH .'/admin');
define( 'TRAVELOR_CORE_ADMIN_ASSETS', TRAVELOR_CORE_ROOT_URL .'admin/assets');
define( 'TRAVELOR_CORE_WP_WIDGETS', TRAVELOR_CORE_ROOT_PATH .'/wp-widgets');
define( 'TRAVELOR_CORE_ASSETS', TRAVELOR_CORE_ROOT_URL .'assets/');
define( 'TRAVELOR_CORE_CSS', TRAVELOR_CORE_ASSETS .'css');
define( 'TRAVELOR_CORE_JS', TRAVELOR_CORE_ASSETS .'js');
define( 'TRAVELOR_CORE_IMG', TRAVELOR_CORE_ASSETS .'img');


/**
 * Load additional helpers functions
 * @package travelor
 * @since 1.0.0
 */
if (!function_exists('travelor_core')){
	require_once TRAVELOR_CORE_INC .'/theme-core-helper-functions.php';
	if (!function_exists('travelor_core')){
		function travelor_core(){
			return class_exists('Travelor_Core_Helper_Functions') ? new Travelor_Core_Helper_Functions() : false;
		}
	}
}
//ob flash
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );


/**
 * Load Codestar Framework Functions
 * @package travelor
 * @since 1.0.0
 */
if ( !travelor_core()->is_travelor_active()) {
	if ( file_exists( TRAVELOR_CORE_ROOT_PATH . '/inc/csf-functions.php' ) ) {
		require_once TRAVELOR_CORE_ROOT_PATH . '/inc/csf-functions.php';
	}
}


/**
 * Core Plugin Init
 * @package travelor
 * @since 1.0.0
 */
if ( file_exists( TRAVELOR_CORE_ROOT_PATH . '/inc/theme-core-init.php' ) ) {
	require_once TRAVELOR_CORE_ROOT_PATH . '/inc/theme-core-init.php';
}

// functions.php
function travelor_elementor_editor_page() {
    // AOS CSS
    wp_enqueue_style(
        'aos-css',
        'https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css',
        [],
        '2.3.4'
    );
    // AOS JS
    wp_enqueue_script(
        'aos-js',
        'https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js',
        ['jquery'],
        '2.3.4',
        true
    );
    // Init script
    wp_add_inline_script(
        'aos-js',
        'jQuery(document).ready(function($){ AOS.init({ once: false }); });'
    );
}
add_action('wp_enqueue_scripts', 'travelor_elementor_editor_page');
add_action('elementor/editor/after_enqueue_scripts', 'travelor_elementor_editor_page');


/**
 * Theme builder
 */
if ( file_exists( TRAVELOR_CORE_ROOT_PATH . '/theme-builder/hugebinary-header-footer.php' ) ) {
    require_once TRAVELOR_CORE_ROOT_PATH . '/theme-builder/hugebinary-header-footer.php';
}