<?php
namespace travelorhead_\Includes;
defined( 'ABSPATH' ) || exit;

class Common{
   
    public $posttype = 'hugebinary-builder';

    public function all_posts( $arg = ['post_type' => 'page', 'post_status' => 'publish'], $index = [])
    {
        if( !isset($arg['posts_per_page']) ){
            $arg['posts_per_page'] = -1;
        }
        

        $page = get_posts( $arg );
        $pages = [];
        foreach($page as $v){
            if( !isset($v->ID) ){
                continue;
            }
            $pages[$v->ID] = $v->post_title;
        }
        if( !empty($index)){
            if( is_array($index) ){
                return array_map(function( $in, $pg){
                    return ($pg[$in]) ?? '';
                }, $index, $pages);
            }
            return isset($pages[$index]) ?? '';
        }

        return $pages;
    }

    public function template_type_array( $index = ''){
        $type = apply_filters('travelor_head_template_type', [
            'header' => __('Header', 'saasland-core'),
            'footer' => __('Footer', 'saasland-core'),
            'mega_menu' => __('Mega Menu', 'saasland-core'),
            'page-banner' => __('Page Banner', 'saasland-core'),
            'f0f' => __('404', 'saasland-core'),
        ]);
        if( !empty($index) ){
            return ($type[$index]) ?? '';
        }
        return $type;
    }
    
    public function working_posttype(){
        $post_types = get_post_types();
        $removeCate = [
            'elementor_library',
            'attachment',
            'revision',
            'nav_menu_item',
            'custom_css',
            'customize_changeset',
            'wp_block',
            'hugebinary-builder',
            'edd_log',
            'oembed_cache',
        ];

        foreach($removeCate as $d){
            if( in_array( $d, $post_types) ){
                unset($post_types[array_search($d, $post_types)]);
            }
        }
        return apply_filters('travelor_head_template_select_posttype', array_values($post_types) );
    }
    

    public function enabled_header( $type = '' ){
        return true;
    }

    public function enabled_footer( $type = '' ){
        return true;
    }

}