<?php

/**
 * Elementor Addons Init
 * @package travelor
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit(); // exit if access directly
}


if ( ! class_exists( 'Travelor_Elementor_Widget_Init' ) ) {

	class Travelor_Elementor_Widget_Init {
	   /**
		* $instance
		* @since 1.0.0
		*/
		private static $instance;

	   /**
		* construct()
		* @since 1.0.0
		*/
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array( $this, '_widget_categories' ) );
			//elementor widget registered
			add_action( 'elementor/widgets/widgets_registered', array( $this, '_widget_registered' ) );
			// elementor editor css
			add_action( 'elementor/editor/after_enqueue_scripts', array( $this, 'load_assets_for_elementor' ) );
			//add icon to elementor new icons fileds
			add_filter( 'elementor/icons_manager/native', array( $this, 'add_custom_icon_to_elementor_icons' ) );
		}

		/**
	     * getInstance()
	     * @since 1.0.0
	     */
		public static function getInstance() {
			if ( null == self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * _widget_categories()
		 * @since 1.0.0
		 */
		public function _widget_categories( $elements_manager ) {
			$elements_manager->add_category(
				'travelor_widgets',
				[
					'title' => esc_html__( 'Travelor Widgets', 'travelor-core' ),
					'icon'  => 'fas fa-plug',
				]
			);
		}

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 */
		public function _widget_registered() {
			if ( ! class_exists( 'Elementor\Widget_Base' ) ) {
				return;
			}
			$elementor_widgets = array(

				'about-one',
				'about-two',
				'accordion-one',
				'accordion-two',
				'advance-image',
				'advance-category-section',
				'banner-one',
				'banner-two',
				'banner-three',
				'button',
				'blog-slider-one',
				'blog-grid-list-one',
				'blog-grid-list-two',
				'brand-section',
				'breadcrumb',
				'category-section',
				'category-slider',
				'circle-button',
				'cta-section',
				'counter-one',
				'counter-two',
				'destination-slider',
				'destination-grid',
				'destination-one',
				'destination-category',
				'destination-search',
				'destination-recent-post',
				'feature-slider-section',
				'feature-two-section',
				'gallery-section',
				'gallery-two-section',
				'gallery-box-three',
				'heading-title',
				'icon-list',
				'instagram-image',
				'image-slider-section',
				'navbar',
				'plane-shape-line',
				'project-section',
				'progress-bar',
				'search',
				'service-slider-one',
				'team-grid',
				'testimonial-grid-one',
				'testimonial-slider-one',
				'testimonial-slider-two',
				'travelor-title-section',
				'travelor-title-two-section',
				'tour-grid',
				'tour-slider',
				'tour-slider-two',
				'tour-details-image-slider',
				'tour-details-rules',
				'tour-recent-post',
				
				
			);

			$elementor_widgets = apply_filters( 'travelor_elementor_widget', $elementor_widgets );
			ksort( $elementor_widgets );
			if ( is_array( $elementor_widgets ) && ! empty( $elementor_widgets ) ) {
				foreach ( $elementor_widgets as $widget ) {
					if ( file_exists( TRAVELOR_CORE_ELEMENTOR . '/addons/elementor-' . $widget . '-widget.php' ) ) {
						require_once TRAVELOR_CORE_ELEMENTOR . '/addons/elementor-' . $widget . '-widget.php';
					}
				}
			}
			
		}

		public function add_custom_icon_to_elementor_icons( $icons ) {
			$icons['flaticon'] = [
				'name'          => 'flaticon',
				'label'         => esc_html__( 'Flaticon', 'travelor-core' ),
				'url'           => TRAVELOR_CORE_CSS . '/flaticon.css',
				// icon css file
				'enqueue'       => [ TRAVELOR_CORE_CSS . '/flaticon.css' ],
				// icon css file
				'prefix'        => 'flaticon-',
				//prefix ( like fas-fa  )
				'displayPrefix' => '',
				//prefix to display icon
				'labelIcon'     => 'flaticon-karate-1',
				//tab icon of elementor icons library
				'ver'           => '1.0.0',
				'fetchJson'     => TRAVELOR_CORE_JS . '/flaticon.js',
				//json file with icon list example {"icons: ['icon class']}
				'native'        => true,
			];

			return $icons;
		}

		/**
		 * load custom assets for elementor
		 * @since 1.0.0
		*/
		public function load_assets_for_elementor() {
			wp_enqueue_style( 'flaticon', TRAVELOR_CORE_CSS . '/flaticon.css' );
			wp_enqueue_style( 'travelor-core-elementor-style', TRAVELOR_CORE_ADMIN_ASSETS . '/css/elementor-editor.css' );
		}
	}

	if ( class_exists( 'Travelor_Elementor_Widget_Init' ) ) {
		Travelor_Elementor_Widget_Init::getInstance();
	}
}//end if


