<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;

class Travelor_Tour_Slider_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-tour-slider-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Tour Slider', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['slider', 'Tour', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'destination_settings_section',
            [
                'label' => esc_html__('Tour Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'show_title',
            [
                'label' => __( 'Show / Hide Title', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
         $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('advance tour plan', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Shelter of Love, Compassion, and New Beginnings', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('communication and utilizes cutting edge logistic planning to get your shipment completed 
                              on time. itself founded of backgrounds, which simply.', 'travelor-core'),
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Explore More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'Wxplore More', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'show_bg_image',
            [
                'label' => __( 'Show / Hide BG Img', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'tour_img', [
                'label' => esc_html__('Tour BG image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Tour Img', 'travelor-core'),
                
            ]
        );
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'travelor-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('Enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'travelor-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => travelor()->get_terms_names('tour-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'travelor-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'travelor-core'),
                'DESC' => esc_html__('Descending', 'travelor-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'travelor-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'travelor-core'),
                'title' => esc_html__('Title', 'travelor-core'),
                'date' => esc_html__('Date', 'travelor-core'),
                'rand' => esc_html__('Random', 'travelor-core'),
                'comment_count' => esc_html__('Most Comments', 'travelor-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'travelor-core')
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h4.project-two-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('title_hover_color', [
            'label' => esc_html__('Title Hover Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h4.project-two-title .hover-text-secondary:hover" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h4.project-two-title"
        ]);

        $this->add_control('destination_color', [
            'label' => esc_html__('Destination Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .project-two-paragraph" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Destination Typography', 'travelor-core'),
            'name' => 'dest_typography',
            'description' => esc_html__('Destination typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .project-two-paragraph"
        ]);

        
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);
        $this->add_control('title2_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title2_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.tw-text-lg" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.tw-text-lg"
        ]);
                $this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Title Margin', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .tw-mb-14" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        //setup query
        $args = array(
            'post_type' => 'tour',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'tour-cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
		
			echo '
            <script>
                jQuery(document).ready(function($) {

                    var slider = new Swiper(".service-two-active", {
						slidesPerView: 3,
						spaceBetween: 30,
						loop: true,
						speed: 3000,
						autoplay: true,
						breakpoints: {
						  "1400": {
							slidesPerView: 3,
						  },
						  "1200": {
							slidesPerView: 3,
						  },
						  "992": {
							slidesPerView: 2,
						  },
						  "768": {
							slidesPerView: 2,
						  },
						  "576": {
							slidesPerView: 1,
						  },
						  "0": {
							slidesPerView: 1,
						  },
						},
					  });
                    
                });
            </script>';
        ?>

            <div class="position-relative z-1 overflow-hidden">
                <div class="container">
                    <?php if( 'yes'===$settings['show_title'] ){ ?>
                        <div class="row justify-content-center">
                            <div class="col-xl-9"> 
                                <div class="section-wrapper text-center tw-mb-10" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                    <?php if($settings['subtitle']) : ?>
                                        <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">
                                            <?php echo $settings['subtitle']; ?>
                                        </h6>
                                    <?php endif; ?>
                                    <?php if($settings['title']) : ?>
                                        <h2 class="section-title fw-normal tw-mb-7 char-animation">
                                            <?php echo $settings['title']; ?>
                                        </h2>
                                    <?php endif; ?>
                                    <?php if($settings['description']) : ?>
                                        <p class="section-paragraph tw-text-lg fw-normal">
                                            <?php echo $settings['description']; ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>  
                    <?php } ?>
                    <div class="row">
                        <div class="col-xl-12">
                                <div class="service-two-slider overflow-hidden">
                                    <div class="service-two-active swiper-container">
                                        <div class="swiper-wrapper">

                                            <?php
                                            while ($post_data->have_posts()) : $post_data->the_post();
                                                $post_id = get_the_ID();
                                                $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                                                $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
                                                $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                                                $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
                                                $tour_single_meta_data = get_post_meta(get_the_ID(), 'travelor_tour_options', true);
                                                
                                                $social_icons = isset($tour_single_meta_data['social-icons']) && !empty($tour_single_meta_data['social-icons']) ? $tour_single_meta_data['social-icons'] : '';

                                                // icon
                                                $tour_icon = isset($tour_single_meta_data['tour_icon']) && !empty($tour_single_meta_data['tour_icon']) ? $tour_single_meta_data['tour_icon'] : '';

                                                ?>

                                                <div class="service-two-wrapper bg-white tw-p-4 tw-rounded-xl tw-mb-8 swiper-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                                    <div class="service-two-thumb tw-mb-5">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <img class="tw-rounded-xl w-100" src="<?php echo esc_url($img_url) ?>" alt="thumb"></a>
                                                    </div>
                                                    <div class="service-two-content tw-px-2 tw-mb-2">
                                                        <span class="service-two-location">
                                                            <i class="ph ph-map-pin"></i>
                                                            <?php echo !empty($tour_single_meta_data['tour_location']) ? esc_html($tour_single_meta_data['tour_location']) : ''; ?>
                                                        </span>
                                                        <h4 class="tw-text-8 fw-normal text-capitalize tw-mb-2">
                                                            <a class="hover-text-secondary" href="<?php the_permalink(); ?>">
                                                                <?php echo esc_html(get_the_title($post_id)) ?>
                                                            </a>
                                                        </h4>
                                                        <p class="service-two-paragraph tw-mb-5">
                                                            <?php echo !empty($tour_single_meta_data['tour_content']) ? esc_html($tour_single_meta_data['tour_content']) : ''; ?>
                                                        </p>
                                                        <div class="service-two-wrap tw-rounded-xl tw-py-4 tw-px-6">
                                                            <div class="service-two-star d-flex tw-gap-6 tw-pb-4 tw-mb-6">
                                                                <span class="text-main-600 fw-medium d-flex tw-gap-2">
                                                                    <i class="ph ph-star"></i> 
                                                                    <?php echo !empty($tour_single_meta_data['tour_rating']) ? esc_html($tour_single_meta_data['tour_rating']) : ''; ?>
                                                                </span>
                                                                <span class="text-main-600 fw-medium">
                                                                    <?php echo !empty($tour_single_meta_data['tour_day']) ? esc_html($tour_single_meta_data['tour_day']) : ''; ?>
                                                                </span>
                                                            </div>
                                                            <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3">
                                                                <div class="service-two-price">
                                                                    <h6>
                                                                        <?php echo !empty($tour_single_meta_data['tour_price']) ? esc_html($tour_single_meta_data['tour_price']) : ''; ?>
                                                                    </h6>
                                                                    <p>
                                                                        <?php echo !empty($tour_single_meta_data['tour_perperson']) ? esc_html($tour_single_meta_data['tour_perperson']) : ''; ?>
                                                                    </p>
                                                                </div>
                                                                <div>
                                                                    <a class="font-heading tw-text-sm text-uppercase text-main-600 fw-bold hover-text-secondary" href="<?php the_permalink(); ?>">
                                                                        <?php echo $settings['button_text']; ?>
                                                                        <i class="tw-text-base ph ph-arrow-up-right"></i>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endwhile; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="service-two-plane-shape position-absolute top-50 start-0 translate-middle-y z-n1">
                        <div class="line_shape_2">
                            <svg width="1920" height="287" viewBox="0 0 1920 287" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path id="line_path_2" d="M0 286C235.807 161.804 715.277 -31.6361 948 104C1192.5 246.5 1698.62 102.064 1920 1" stroke="#CEC7BE" stroke-dasharray="4 4" />
                                <g id="paper-plane_2">
                                    <path  d="M8.52862 0.643979C8.65472 0.654731 12.5944 5.1037 15.7327 8.66873C16.0616 8.64319 16.3357 8.62234 16.3357 8.62234L16.6797 8.10704L19.1766 7.91312L19.3247 9.82093L16.9109 10.0082C17.5051 10.6843 18.0375 11.2905 18.4682 11.7814C21.1362 11.6535 26.2869 11.419 27.1597 11.4798C28.3465 11.5623 30.0418 12.128 30.0368 12.5126C30.0318 12.8972 28.4581 13.7513 27.5404 14.0673C26.8454 14.3064 21.1236 14.8358 18.3473 15.0812C17.9672 15.7098 17.5181 16.4498 17.0277 17.2557L19.8851 17.0334L20.0333 18.9412L17.5364 19.1351L17.1173 18.6791C17.1173 18.6791 16.5828 18.7209 16.1125 18.7568C13.4463 23.1189 10.1742 28.3838 9.92358 28.3613C9.49623 28.3236 8.49302 27.2688 8.49302 27.2688L9.96254 22.7816C9.52126 22.7861 9.19671 22.7262 9.18859 22.6259C9.17946 22.5123 9.58103 22.3871 10.1098 22.3303L10.8472 20.079C10.5083 20.0669 10.2756 20.0104 10.2686 19.9261C10.2611 19.828 10.5617 19.7202 10.9855 19.6563L12.4419 15.2098L6.2911 15.3333L3.00246 20.403L1.50247 20.2363L2.61746 15.6496L4.02107 15.0837C4.02107 15.0837 2.47224 15.1697 2.47782 14.7758C2.4834 14.3819 3.85476 14.0784 3.85476 14.0784L2.61875 13.8202L0.562775 9.68354L2.55228 8.81392L6.31432 13.4946L12.3097 12.4928L10.3991 8.9086C9.84767 8.93961 9.41072 8.87701 9.4014 8.76046C9.39341 8.6582 9.71898 8.54567 10.1719 8.48324L9.06011 6.39696C9.04924 6.39738 9.03867 6.39894 9.02779 6.39936C8.42442 6.44647 7.92762 6.38376 7.91735 6.25891C7.90894 6.14578 8.30449 6.02093 8.82844 5.96421L6.75475 2.07323C6.75475 2.07323 8.31696 0.625839 8.5282 0.6447L8.52862 0.643979Z" fill="#113A75"/>
                                </g>
                            </svg>
                        </div>
                    </div>
                    
                    <?php if( 'yes'===$settings['show_bg_image'] ){ ?>
                        <?php if($settings['tour_img']['url']) : ?>
                            <div class="project-bg">
                                <img class="testimonial-bg-shape position-absolute start-0 z-n1" src="<?php echo $settings['tour_img']['url']; ?>" alt="">
                            </div>
                        <?php endif; ?>
                    <?php } ?>
                </div>
            
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Tour_Slider_Widget());