<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;

class Travelor_Tour_Recent_Post_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-tour-recent-post-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Tour Recent Post', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['recent post', 'Tour', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'tour_settings_section',
            [
                'label' => esc_html__('Tour Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'rating', [
                'label' => esc_html__('Rating Star', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('5', 'travelor-core'),
            ]
        );
        
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'travelor-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('Enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'travelor-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => travelor()->get_terms_names('tour-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'travelor-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'travelor-core'),
                'DESC' => esc_html__('Descending', 'travelor-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'travelor-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'travelor-core'),
                'title' => esc_html__('Title', 'travelor-core'),
                'date' => esc_html__('Date', 'travelor-core'),
                'rand' => esc_html__('Random', 'travelor-core'),
                'comment_count' => esc_html__('Most Comments', 'travelor-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'travelor-core')
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h4.project-two-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('title_hover_color', [
            'label' => esc_html__('Title Hover Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h4.project-two-title .hover-text-secondary:hover" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h4.project-two-title"
        ]);

        $this->add_control('destination_color', [
            'label' => esc_html__('Destination Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .project-two-paragraph" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Destination Typography', 'travelor-core'),
            'name' => 'dest_typography',
            'description' => esc_html__('Destination typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .project-two-paragraph"
        ]);

        
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
       
        $this->add_control('title2_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title2_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        
       
        
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        //setup query
        $args = array(
            'post_type' => 'tour',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'tour-cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        
        ?>
                <?php  while ($post_data->have_posts()) : $post_data->the_post();
                    $post_id = get_the_ID();
                    $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                    $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
                    $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                    $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
                    $tour_single_meta_data = get_post_meta(get_the_ID(), 'travelor_tour_options', true);
                    
                   
    
                    ?>
        
                    <div class="tour-recent-post d-flex align-items-center tw-gap-8 tw-mb-7">
                        <div>
                            <a href="<?php the_permalink(); ?>" class="tw-rounded-md overflow-hidden flex-shrink-0">
                                <img src="<?php echo esc_url($img_url) ?>" alt="" class="w-100 h-100 object-fit-cover hover-scale-2 tw-duration-500">
                            </a>
                        </div>
                        <div>
                            <div>
                                
                                <?php
                                    for ($i=0; $i < $settings['rating']; $i++) {  ?>
                                        <i class="ph ph-star"></i>
                                    <?php }
                                ?>
                            </div>
                            <div>
                                <h6 class="tw-mb-2">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php echo esc_html(get_the_title($post_id)) ?>
                                    </a>
                                </h6>
                                <p class="mb-0 tw-text-sm fw-medium">
                                    <?php echo !empty($tour_single_meta_data['tour_price']) ? esc_html($tour_single_meta_data['tour_price']) : ''; ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    
                    
                <?php endwhile; ?>
                                        
            
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Tour_Recent_Post_Widget());