<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */
namespace Elementor;
class Travelor_Tour_Details_Rules_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-tour-details-rules-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Tour Details Rules', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['tour', 'rules', 'details', 'icon list', 'travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
	public function get_icon() {
		return 'eicon-editor-list-ul';
	}

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['medicol_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
			'rules_section',
			[
				'label' => __( 'Tour Details Rules', 'travelor-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
       
        $this->add_control(
            'select_style',
            [
                'label' => __( 'Select Style', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'one' => __( 'One', 'travelor-core' ),
                    'two' => __( 'Two', 'travelor-core' ),
                ],
                'default' => 'one',
            ]
        );
        
        $this->add_control(
            'number',
            [
                'label' => esc_html__('Number', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('01', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Day 1: Arrive in Zürich, Switzerland', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We’ll meet at 4 p.m. at our hotel in Luzern (Lucerne) for a “Welcome to Switzerland” meeting. Then we’ll take a meandering evening walk through Switzerland’s most charming lakeside town, and get acquainted with one another over dinner we have focused on improving our funct together. Sleep in Luzern (2 nights). No bus. Walk', 'travelor-core'),
            ]
        );
        $this->add_control(
            'show_list',
            [
                'label' => __( 'Show / Hide icon List', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        
        
        $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                'icons_type',
                [
                    'label' => esc_html__('Select Icon or Image','travelor-core'),
                    'type' => \Elementor\Controls_Manager::CHOOSE,
                    'options' =>[
                        'img' =>[
                            'title' =>esc_html__('Image','travelor-core'),
                            'icon' =>'fa fa-picture-o',
                        ],
                        'icon' =>[
                            'title' =>esc_html__('Icon','travelor-core'),
                            'icon' =>'fa fa-info',
                        ],
                        'icon_cls' =>[
                            'title' =>esc_html__('Icon Class','travelor-core'),
                            'icon' =>'fa fa-code',
                        ]
                    ],
                    'default' => 'img',
                ]
             );
             
             $repeater->add_control(
                'select_icon',
                [
                    'label' => esc_html__( 'Select Icon', 'travelor-core' ),
                    'type' => \Elementor\Controls_Manager::ICONS,
                    'condition'=>[
                        'icons_type'=> 'icon',
                    ],
                    'label_block' => true,
                ]
            );
            
            $repeater->add_control(
                'select_img',
                [
                    'label' => esc_html__('Select Image','travelor-core'),
                    'type'=> \Elementor\Controls_Manager::MEDIA,
                    'condition' => [
                      'icons_type' => 'img',
                    ]
                ]
            );
    
            $repeater->add_control(
                'select_class',
                [
                    'label' => esc_html__( 'Icon Class', 'travelor-core' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'condition'=>[
                        'icons_type'=> 'icon_cls',
                    ],
                    'label_block' => true,
                    'default' => __( 'ph-bold ph-check', 'travelor-core' ),
                ]
            );
            $repeater->add_control(
                'icon_list_title',
                [
                    'label' => esc_html__('List Title', 'travelor-core'),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('View the City Walls', 'travelor-core'),
                ]
            );

        $this->add_control('icon_list_items', [
            'label' => esc_html__('List Item', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);

		$this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
       
       $this->add_control('title_color', [
            'label' => esc_html__('title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .package-details-rules h6" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('title Typography', 'travelor-core'),
            'name' => 'box_title_typography',
            'description' => esc_html__('title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .package-details-rules h6"
        ]);
       
       
        $this->add_control('list_title_color', [
            'label' => esc_html__('list title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .package-details-rules li" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('List title Typography', 'travelor-core'),
            'name' => 'box_list_title_typography',
            'description' => esc_html__('List title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} li.tw-text-base"
        ]);
         $this->add_responsive_control(
			'margin_bottom',
			[
				'label' => __( 'Margin Bottom', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .tw-mb-20" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);
		

        $this->end_controls_section();
    }

    /*
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $icon_list_items = $settings['icon_list_items'];
        ?>

            <?php if($settings['select_style']=='one'){ ?>
        
                
                <div class="package-details-rules d-flex tw-gap-12 position-relative z-1">
                    <?php if($settings['number']) : ?>
                         <div>
                            <span class="tw-w-25 tw-h-24 lh-1 d-inline-flex align-items-center justify-content-center bg-main-600 tw-rounded-lg text-white tw-text-6 fw-bold">
                                <?php echo $settings['number']; ?>
                            </span>
                         </div>
                    <?php endif; ?>
                     <div class="tw-mb-10">
                        <?php if($settings['title']) : ?>
                            <h6 class="tw-text-505 tw-mb-4">
                                <?php echo $settings['title']; ?>
                            </h6>
                        <?php endif; ?>
                        <?php if($settings['description']) : ?>
                            <p class="tw-mb-9">
                                <?php echo $settings['description']; ?>
                            </p>
                        <?php endif; ?>
                        <?php if( 'yes'===$settings['show_list'] ){ ?>
                              <div class="destination-details-list package-details-list tw-mb-10">
                                   <ul>
                                       <?php foreach ($icon_list_items as $item): ?>
                                           <?php if($item['icon_list_title']) : ?>
                                                <li class="font-heading fw-bold text-main-600 text-capitalize tw-text-lg tw-mb-5 tw-ps-2 tw-ms-5">
                                                    <?php echo $item['icon_list_title']; ?>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                   </ul>
                              </div>
                          <?php } ?>
                     </div>
                </div>
                
            <?php }elseif($settings['select_style']=='two'){ ?>
            
                <div class="package-details-rules d-flex tw-gap-12 position-relative z-1">
                     <?php if($settings['number']) : ?>
                         <div>
                              <span class="tw-w-25 tw-h-24 lh-1 d-inline-flex align-items-center justify-content-center bg-main-600 tw-rounded-lg text-white tw-text-6 fw-bold">
                                  <?php echo $settings['number']; ?>
                               </span>
                         </div>
                     <?php endif; ?>
                     <div class="tw-mb-20">
                         <?php if($settings['title']) : ?>
                            <h6 class="tw-text-505 tw-mb-4">
                                <?php echo $settings['title']; ?>
                            </h6>
                        <?php endif; ?>
                        <?php if($settings['description']) : ?>
                            <p class="tw-mb-9">
                                <?php echo $settings['description']; ?>
                            </p>
                        <?php endif; ?>
                        <?php if( 'yes'===$settings['show_list'] ){ ?>
                            <div>
                               <ul class="d-flex flex-column">
                                    <?php foreach ($icon_list_items as $item): ?>
                                        <li class="float-start tw-text-base fw-medium tw-mb-6 d-inline-flex align-items-center tw-gap-3">
                                            <?php if($item['icons_type'] == 'icon' ) : ?>
                                                <span>
                                                    <i class="<?php echo esc_attr($item['select_icon']['value']); ?>"></i>
                                                </span> 
                                            <?php elseif($item['icons_type'] == 'img' ) : ?>
                                                <span>
                                                    <img src="<?php echo $item['select_img']['url'];?>" alt=""/>
                                                </span> 
                                            <?php else: ?>
                                                <span>
                                                    <i class="<?php echo esc_attr($item['select_class']); ?>"></i>
                                                </span> 
                                            <?php endif; ?>
                                            <?php echo $item['icon_list_title']; ?>
                                        </li> 
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php } ?>
                     </div>
                </div>

            <?php } ?>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Tour_Details_Rules_Widget());