<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Tour_Details_Image_Slider_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-tour-details-image-slider-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Tour Details Image Slider', 'travelor-core');
    }

    public function get_keywords()
    {
        return [ 'image','img', 'slider', 'title', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'image_slider_content',
            [
                'label' => esc_html__('Image Slider Section', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
    
            $repeater = new \Elementor\Repeater();

                $repeater->add_control(
                    'slider_image', [
                        'label' => esc_html__('Slider Image', 'travelor-core'),
                        'type' => Controls_Manager::MEDIA,
                        'show_label' => true,
                        'description' => esc_html__('Slider Image', 'travelor-core'),
                    ]
                );
                $this->add_control('image_slider_items', [
                'label' => esc_html__('Image Slider Item', 'medicol-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => array(
                            'url' => Utils::get_placeholder_image_src()
                        )
                    ]
                ],
            ]);


        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $image_slider_items = $settings['image_slider_items'];

        ?>
            
            <div class="package-details-area overflow-hidden">
                <div class="container-fluid gx-5">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="package-details-slide position-relative z-index-1" data-aos-duration="1000" data-aos-delay="200">
                                <div class="package-details-active swiper-container">
                                    <div class="package-details-swiper-wrapper swiper-wrapper">
                                        <?php foreach ($image_slider_items as $item): ?>
                                            <div class="position-relative z-index-1 swiper-slide">
                                                <div>
                                                    <img class="tw-rounded-lg" src="<?php echo $item['slider_image']['url']; ?>" alt=" ">
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <div class="package-details-arrow-box">
                                    <button class="slider-prev">
                                        <i class="ph ph-arrow-left"></i>
                                    </button>
                                    <button class="slider-next">
                                        <i class="ph ph-arrow-right"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Tour_Details_Image_Slider_Widget());