<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */
namespace Elementor;
class Travelor_Testimonial_Slider_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-testimonial-slider-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial Slider 02', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['testimonial', 'Slider', 'travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
	public function get_icon() {
		return 'eicon-table';
	}

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['medicol_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' => __( 'Testimonial Slider', 'travelor-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

         $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('client’s testimonial', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Client’s testimonial', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('communication and utilizes cutting edge logistic planning to get your shipment completed on time. itself founded of backgrounds, which simply.', 'travelor-core'),
            ]
        );

         $this->add_control(
            'show_button',
            [
                'label' => __( 'Show / Hide Button', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'See all destination ', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Link Here', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'bg_image', [
                'label' => esc_html__('Background Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Background Image', 'travelor-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                'top_logo', [
                    'label' => esc_html__('Top Logo', 'travelor-core'),
                    'type' => Controls_Manager::MEDIA,
                    'show_label' => false,
                    'description' => esc_html__('Top Logo', 'travelor-core'),
                ]
            );
            $repeater->add_control(
                'content', [
                    'label' => esc_html__('Content', 'travelor-core'),
                    'type' => Controls_Manager::TEXTAREA,
                    'show_label' => false,
                    'default' => esc_html__('We get absolutely raving reviews from our sales and customer support teams using close. Even our co- salesfounders are very happy. We getabsolutely raving reviews from ourEven our co- founders are veryhappy for services'),
                    'description' => esc_html__('Upload Content', 'travelor-core'),
                ]
            );
            $repeater->add_control(
                'name', [
                    'label' => esc_html__('Name', 'travelor-core'),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Rudra Ghosh', 'travelor-core'),
                    'show_label' => true,
                    'description' => esc_html__('upload name', 'travelor-core'),
                ]
            );
            $repeater->add_control(
                'designation', [
                    'label' => esc_html__('Designation', 'travelor-core'),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Founder & CEO Dulalix', 'travelor-core'),
                    'description' => esc_html__('Enter Designation', 'travelor-core'),
                ]
            );
            $repeater->add_control(
                'rating_point', [
                    'label' => esc_html__('Rating Point', 'travelor-core'),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('4.9', 'travelor-core'),
                    'description' => esc_html__('Enter Rating', 'travelor-core'),
                ]
            );
        $this->add_control('testimonial_items', [
            'label' => esc_html__('Testimonial Item', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);


        $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                'top_logo', [
                    'label' => esc_html__('Top Logo', 'travelor-core'),
                    'type' => Controls_Manager::MEDIA,
                    'show_label' => false,
                    'description' => esc_html__('Top Logo', 'travelor-core'),
                ]
            );
            $repeater->add_control(
                'content', [
                    'label' => esc_html__('Content', 'travelor-core'),
                    'type' => Controls_Manager::TEXTAREA,
                    'show_label' => false,
                    'default' => esc_html__('We get absolutely raving reviews from our sales and customer support teams using close. Even our co- salesfounders are very happy. We getabsolutely raving reviews from ourEven our co- founders are veryhappy for services'),
                    'description' => esc_html__('Upload Content', 'travelor-core'),
                ]
            );
            $repeater->add_control(
                'name', [
                    'label' => esc_html__('Name', 'travelor-core'),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Rudra Ghosh', 'travelor-core'),
                    'show_label' => true,
                    'description' => esc_html__('upload name', 'travelor-core'),
                ]
            );
            $repeater->add_control(
                'designation', [
                    'label' => esc_html__('Designation', 'travelor-core'),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Founder & CEO Dulalix', 'travelor-core'),
                    'description' => esc_html__('Enter Designation', 'travelor-core'),
                ]
            );
            $repeater->add_control(
                'rating_point', [
                    'label' => esc_html__('Rating Point', 'travelor-core'),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('4.9', 'travelor-core'),
                    'description' => esc_html__('Enter Rating', 'travelor-core'),
                ]
            );
        $this->add_control('testimonial_items2', [
            'label' => esc_html__('Testimonial Item2', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);



		$this->end_controls_section();




        /*  tab styling tabs start */
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle.text-main-two-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title.text-white" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.tw-text-lg" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.text-white"
        ]);
        $this->add_responsive_control(
			'desc_margin',
			[
				'label' => __( 'Description Margin', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} p.tw-mb-8" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);

        
        $this->add_control('name_color', [
            'label' => esc_html__('Name Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h4.tw-text-xl" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} h4.tw-text-xl',
            ]
        );
        $this->add_control('designation_color', [
            'label' => esc_html__('Designation Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.testimonail-three-bottom-paragraph" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'designation_typography',
                'selector' => '{{WRAPPER}} p.testimonail-three-bottom-paragraph',
            ]
        );

        $this->add_control('des_color', [
            'label' => esc_html__('Content Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.testimonail-three-paragraph.tw-text-lg" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc2_typography',
                'selector' => '{{WRAPPER}} p.testimonail-three-paragraph.tw-text-lg',
            ]
        );
        
        $this->end_controls_section();
    }

     
    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $testimonial_items = $settings['testimonial_items'];
        $testimonial_items2 = $settings['testimonial_items2'];

        ?>

            <div class="testimonail-three-area background-img tw-rounded-2xl tw-mx-15 py-140 position-relative z-1 overflow-hidden"  data-background-image="<?php echo $settings['bg_image']['url']; ?>">
                <div class="container">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-xl-6 col-lg-7">
                            <div class="section-wrapper" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                <?php if($settings['subtitle']) : ?>
                                    <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4 text-main-two-600">
                                        <?php echo $settings['subtitle']; ?>
                                    </h6>
                                <?php endif; ?>
                                <?php if($settings['title']) : ?>
                                     <h2 class="section-title fw-normal tw-mb-7 char-animation text-white">
                                        <?php echo $settings['title']; ?>
                                    </h2>
                                <?php endif; ?>
                                <?php if($settings['description']) : ?>
                                    <p class="tw-text-lg fw-normal text-white tw-mb-8">
                                        <?php echo $settings['description']; ?>
                                    </p>
                                <?php endif; ?>
                                <?php if( 'yes'===$settings['show_button'] ){ ?>
                                    <div class="counter-button project-two-button common-hover-yellow" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
                                        <a href="<?php echo $settings['button_url']; ?>" class="primary-btn bg-white text-main-600 tw-py-4 tw-px-8 fs-15 text-uppercase fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                                            <?php echo $settings['button_text']; ?>
                                            <i class="ph ph-arrow-up-right"></i>
                                        </a> 
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper testimonail-three-slider-one">
                    <div class="swiper-wrapper testimonail-three-wrapper">
                        <?php foreach ($testimonial_items as $item): ?>
                            <div class="testimonail-three-wrapper tw-mb-8 tw-rounded-2xl tw-p-10 swiper-slide tw-mb-8">
                                <?php if($item['top_logo']['url']) : ?>
                                    <div class="testimonail-three-logo tw-mb-6">
                                        <img src="<?php echo $item['top_logo']['url']; ?>" alt="">
                                    </div>
                                <?php endif; ?>
                                <div>
                                    <?php if($item['content']) : ?>
                                        <p class="testimonail-three-paragraph tw-text-lg fw-medium tw-mb-4 tw-pb-8">
                                            <?php echo $item['content']; ?>
                                        </p>
                                    <?php endif; ?>
                                </div>  
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>
                                        <?php if($item['name']) : ?>
                                            <h4 class="tw-text-xl tw-mb-2">
                                                <?php echo $item['name']; ?>
                                            </h4>
                                        <?php endif; ?>
                                        <?php if($item['designation']) : ?>
                                            <p class="testimonail-three-bottom-paragraph">
                                                <?php echo $item['designation']; ?>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($item['rating_point']) : ?>
                                        <div>
                                            <span class="bg-main-two-600 text-main-600 fw-semibold tw-py-1 tw-px-4 tw-rounded-4xl d-inline-flex tw-gap-2 align-items-center">
                                                <?php echo $item['rating_point']; ?>
                                                <i class="ph ph-star"></i>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="swiper testimonail-three-slider-two">
                    <div class="swiper-wrapper testimonail-three-wrapper">
                        <?php foreach ($testimonial_items2 as $item): ?>
                            <div class="testimonail-three-wrapper tw-mb-8 tw-rounded-2xl tw-p-10 swiper-slide tw-mb-8">
                                <?php if($item['top_logo']['url']) : ?>
                                    <div class="testimonail-three-logo tw-mb-6">
                                        <img src="<?php echo $item['top_logo']['url']; ?>" alt="">
                                    </div>
                                <?php endif; ?>
                                <div>
                                    <?php if($item['content']) : ?>
                                        <p class="testimonail-three-paragraph tw-text-lg fw-medium tw-mb-4 tw-pb-8">
                                            <?php echo $item['content']; ?>
                                        </p>
                                    <?php endif; ?>
                                </div>  
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>
                                        <?php if($item['name']) : ?>
                                            <h4 class="tw-text-xl tw-mb-2">
                                                <?php echo $item['name']; ?>
                                            </h4>
                                        <?php endif; ?>
                                        <?php if($item['designation']) : ?>
                                            <p class="testimonail-three-bottom-paragraph">
                                                <?php echo $item['designation']; ?>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($item['rating_point']) : ?>
                                        <div>
                                            <span class="bg-main-two-600 text-main-600 fw-semibold tw-py-1 tw-px-4 tw-rounded-4xl d-inline-flex tw-gap-2 align-items-center">
                                                <?php echo $item['rating_point']; ?>
                                                <i class="ph ph-star"></i>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Testimonial_Slider_Two_Widget());