<?php
/**
 * Elementor Widget
 * @package travelor
 * @since 1.0.0
 */

namespace Elementor;

class Travelor_Testimonial_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-testimonial-slider-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial Slider 01', 'travelor-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'testimonial_settings_section',
            [
                'label' => esc_html__('Testimonial Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'show_active',
            [
                'label' => __( 'Active Box', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'travelor-core' ),
                'label_off' => __( 'No', 'travelor-core' ),
                'return_value' => 'yes',
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('Content', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'show_label' => false,
                'default' => esc_html__('and curated experiences, everything was flawless. This is what five-star travel should feel like.” how affordable the..'),
                'description' => esc_html__('Upload Content', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'name', [
                'label' => esc_html__('Name', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('william camel', 'travelor-core'),
                'show_label' => true,
                'description' => esc_html__('Enter Name', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'designation', [
                'label' => esc_html__('Designation', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Head of Design at Zazoo', 'travelor-core'),
                'description' => esc_html__('Enter Designation', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'quote_image', [
                'label' => esc_html__('Quote Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Quote Image', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'author_image', [
                'label' => esc_html__('Author Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Author Image', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('great experience', 'travelor-core'),
                'description' => esc_html__('Enter Title', 'travelor-core'),
            ]
        );

        $repeater->add_control(
            'testi_bg_image', [
                'label' => esc_html__('BG Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('BG Image', 'travelor-core'),
            ]
        );
        
        $this->add_control('testimonial_items', [
            'label' => esc_html__('Testimonial Slider Item', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control('name_color', [
            'label' => esc_html__('Name Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonials h6" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('name Typography', 'travelor-core'),
            'name' => 'name_typography',
            'description' => esc_html__('name typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .testimonials h6.tw-text-xl"
        ]);
        $this->add_control('designation_color', [
            'label' => esc_html__('Designation Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('content_color', [
            'label' => esc_html__('Content Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-two-paragraph.text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Content Typography', 'travelor-core'),
            'name' => 'content_typography',
            'description' => esc_html__('Content typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .testimonial-two-paragraph"
        ]);


        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_testimonial_items = $settings['testimonial_items'];
		
		echo '
            <script>
                jQuery(document).ready(function($) {
					var slider = new Swiper(".testimonial-two-active", {
						slidesPerView: "auto",
						spaceBetween: 30,
						loop: true,
						speed: 3000,
						autoplay:true,
						breakpoints: {
						  "1200": {
							slidesPerView: 2,
						  },
						  "992": {
							slidesPerView: 1,
						  },
						 "768": {
							slidesPerView: 1,
						  },
						  "576": {
							slidesPerView: 1,
						  },
						  "0": {
							slidesPerView: 1,
						  },
						},
						// pagination
						pagination: {
						  el: ".testimonial-two-dot",
						  clickable: true,
						},
					 });
				});
		  </script>';

        ?>

            <div class="testimonial-two-area">
                <div class="container">
                    <div class="row">
                        <div class="testimonial-two-slider position-relative z-1 overflow-hidden">
                                <div class="testimonial-two-active swiper-container">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($all_testimonial_items as $testimonial_item): ?>
                                            <div class="<?php if('yes' === $testimonial_item['show_active']){echo esc_attr('active');}?> testimonial-two-wrapper tw-rounded-xl d-flex justify-content-between position-relative z-1 background-img overflow-hidden swiper-slide" data-background-image="<?php echo $testimonial_item['testi_bg_image']['url'] ?>">
                                                <div class="testimonial-two-left bg-main-two-600 tw-rounded-xl tw-pt-15 tw-pb-9 tw-ps-9 tw-pe-7">
                                                    <?php if($testimonial_item['content']) : ?>
                                                        <p class="testimonial-two-paragraph fw-semibold text-main-600 tw-pb-9 tw-mb-6">From luxury hotels to private transfers 
                                                            <?php echo esc_html($testimonial_item['content']); ?>
                                                        </p>
                                                    <?php endif; ?>
                                                    <div>
                                                        <?php if($testimonial_item['name']) : ?>
                                                            <h6 class="tw-text-xl text-capitalize fw-semibold tw-mb-2">
                                                                <?php echo esc_html($testimonial_item['name']); ?>
                                                            </h6>
                                                        <?php endif; ?>
                                                        <?php if($testimonial_item['designation']) : ?>
                                                            <p class="text-main-600 fw-medium">
                                                                <?php echo esc_html($testimonial_item['designation']); ?>
                                                            </p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="testimonial-two-right d-flex justify-content-between flex-column tw-pt-16 tw-pb-12 tw-pe-15">
                                                    <?php if($testimonial_item['quote_image']['url']) : ?>
                                                        <div class="icon">
                                                            <span><img src="<?php echo $testimonial_item['quote_image']['url'] ?>" alt="quote"></span>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div>
                                                        <?php if($testimonial_item['author_image']['url']) : ?>
                                                            <div class="tw-mb-4">
                                                                <img src="<?php echo $testimonial_item['author_image']['url'] ?>" alt="logo">
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if($testimonial_item['title']) : ?>
                                                            <h6 class="tw-text-xl">
                                                                <?php echo esc_html($testimonial_item['title']); ?>
                                                            </h6>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            <div class="testimonial-two-dot text-center tw-mt-10 pb-3"></div>
                        </div>
                    </div>
                </div>
            </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Testimonial_Slider_One_Widget());