<?php
/**
 * Elementor Widget
 * @package travelor
 * @since 1.0.0
 */

namespace Elementor;

class Travelor_Testimonial_Grid_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-testimonial-grid-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial Grid 01', 'travelor-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'testimonial_settings_section',
            [
                'label' => esc_html__('Testimonial Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_title',
            [
                'label' => __( 'Show / Hide title', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Populer Destination', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Shelter of Love, Compassion, and New Beginnings', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('communication and utilizes cutting edge logistic planning to get your shipment completed on time. itself founded of backgrounds, which simply.', 'travelor-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'show_bg_active',
            [
                'label' => __( 'Active Bg Color left', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'travelor-core' ),
                'label_off' => __( 'No', 'travelor-core' ),
                'return_value' => 'yes',
            ]
        );
        $repeater->add_control(
            'name', [
                'label' => esc_html__('Name', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Robert J. Hare/', 'travelor-core'),
                'show_label' => true,
                'description' => esc_html__('Enter Name', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'designation', [
                'label' => esc_html__('Designation', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Graphics Designer', 'travelor-core'),
                'description' => esc_html__('Enter Designation', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('Content', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'show_label' => false,
                'default' => esc_html__('Travelor hires great people from a widely variety of backgrounds, which simply makes our compan stronger, and we couldn’t be prouder of that. elevating your optimizing Business Growth.'),
                'description' => esc_html__('Enter Content', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'rating', [
                'label' => esc_html__('Rating Star', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('5', 'travelor-core'),
            ]
        );

        $repeater->add_control(
            'show_active_bg',
            [
                'label' => __( 'Active Bg Color', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'travelor-core' ),
                'label_off' => __( 'No', 'travelor-core' ),
                'return_value' => 'yes',
            ]
        );
        $repeater->add_control(
            'name_right', [
                'label' => esc_html__('Right Name', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Robert J. Hare/', 'travelor-core'),
                'show_label' => true,
                'description' => esc_html__('Enter Name', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'designation_right', [
                'label' => esc_html__('Right Designation', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Graphics Designer', 'travelor-core'),
                'description' => esc_html__('Enter Designation', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'content_right', [
                'label' => esc_html__('Right Content', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'show_label' => false,
                'default' => esc_html__('Travelor hires great people from a widely variety of backgrounds, which simply makes our compan stronger, and we couldn’t be prouder of that. elevating your optimizing Business Growth.'),
                'description' => esc_html__('Enter Content', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'rating_right', [
                'label' => esc_html__('Right Rating Star', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('5', 'medicol-core'),
            ]
        );
        $this->add_control('testimonial_item', [
            'label' => esc_html__('Testimonial grid Item', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);

        $this->add_control(
            'testi_shape_bg', [
                'label' => esc_html__('Testimonial Shape BG image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Testimonial Shape BG image', 'travelor-core'),
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.tw-text-lg" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.tw-text-lg"
        ]);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Title Margin', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .tw-mb-10" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);


        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_testimonial_items = $settings['testimonial_item'];

        ?>

            <div class="testimonial-area testimonial-panel-area pb-140 position-relative z-1">
                <div class="container">
                    <?php if( 'yes'===$settings['show_title'] ){ ?>
                        <div class="row justify-content-center">
                            <div class="col-xl-8"> 
                                <div class="section-wrapper  text-center tw-mb-14">
                                    <?php if($settings['subtitle']) : ?>
                                        <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">
                                            <?php echo $settings['subtitle']; ?>
                                        </h6>
                                    <?php endif; ?>
                                    <?php if($settings['title']) : ?>
                                        <h2 class="section-title fw-normal tw-mb-7 char-animation">
                                            <?php echo $settings['title']; ?>
                                        </h2>
                                    <?php endif; ?>
                                    <?php if($settings['description']) : ?>
                                        <p class="section-paragraph tw-text-lg fw-normal">
                                            <?php echo $settings['description']; ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="row">
                        <div class="col">
                            <?php foreach ($all_testimonial_items as $testimonial_item): ?>
                                <div class="row testimonial-panel">
                                    <div class="col-xl-6 col-lg-6">
                                        <div class="testimonial-wrapper position-relative z-1 bg-white tw-mb-8 <?php if('yes' === $testimonial_item['show_bg_active']){echo esc_attr('three');}?>">
                                            <?php if($testimonial_item['name']) : ?>
                                                <h6 class="testimonial-title tw-text-xl font-body tw-mb-14">
                                                    <?php echo esc_html($testimonial_item['name']); ?>
                                                    <?php if($testimonial_item['designation']) : ?>
                                                        <span class="tw-text-sm fw-normal font-body">
                                                            <?php echo esc_html($testimonial_item['designation']); ?>
                                                    </span>
                                                    <?php endif; ?>
                                                </h6>
                                            <?php endif; ?>
                                            <?php if($testimonial_item['content']) : ?>
                                                <p class="testimonial-paragraph text-main-600 tw-mb-14">
                                                    <?php echo esc_html($testimonial_item['content']); ?>
                                                </p>
                                            <?php endif; ?>
                                            <div class="testimonial-review">
                                                <?php
                                                    for ($i=0; $i < $testimonial_item['rating']; $i++) {  ?>
                                                        <i class="ph ph-star"></i>
                                                    <?php }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6">
                                        <div class="testimonial-wrapper position-relative bg-white z-1 tw-mb-8 <?php if('yes' === $testimonial_item['show_active_bg']){echo esc_attr('two');}?>">
                                            <?php if($testimonial_item['name_right']) : ?>
                                                <h6 class="testimonial-title tw-text-xl font-body tw-mb-14">
                                                    <?php echo esc_html($testimonial_item['name_right']); ?>
                                                    <?php if($testimonial_item['designation_right']) : ?>
                                                        <span class="tw-text-sm fw-normal font-body">
                                                            <?php echo esc_html($testimonial_item['designation_right']); ?>
                                                    </span>
                                                    <?php endif; ?>
                                                </h6>
                                            <?php endif; ?>
                                            <?php if($testimonial_item['content_right']) : ?>
                                                <p class="testimonial-paragraph text-main-600 tw-mb-14">
                                                    <?php echo esc_html($testimonial_item['content_right']); ?>
                                                </p>
                                            <?php endif; ?>
                                            <div class="testimonial-review">
                                                <?php
                                                    for ($i=0; $i < $testimonial_item['rating_right']; $i++) {  ?>
                                                        <i class="ph ph-star"></i>
                                                    <?php }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <?php if($settings['testi_shape_bg']['url']) : ?>
                    <div>
                        <img class="testimonial-bg-shape position-absolute start-0 z-1" src="<?php echo $settings['testi_shape_bg']['url']; ?>" alt="shape">
                    </div>
                <?php endif; ?>
            </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Testimonial_Grid_One_Widget());