<?php
/**
 * Elementor Widget
 * @package travelor
 * @since 1.0.0
 */

namespace Elementor;

class Travelor_Service_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-service-slider-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Service Slider 01', 'travelor-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'service_content',
            [
                'label' => esc_html__('Service Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

            $this->add_control(
                'subtitle', [
                    'label' => esc_html__('subtitle', 'travelor-core'),
                    'type' => Controls_Manager::TEXTAREA,
                    'show_label' => false,
                    'default' => esc_html__('Discount ackage'),
                    'description' => esc_html__('Entre subtitle', 'travelor-core'),
                ]
            );
            $this->add_control(
                'title', [
                    'label' => esc_html__('title', 'travelor-core'),
                    'type' => Controls_Manager::TEXTAREA,
                    'show_label' => false,
                    'default' => esc_html__('Shelter of Love, Compassion, and New Beginnings'),
                    'description' => esc_html__('Entre title', 'travelor-core'),
                ]
            );
            $this->add_control(
                'content', [
                    'label' => esc_html__('Content', 'travelor-core'),
                    'type' => Controls_Manager::TEXTAREA,
                    'show_label' => false,
                    'default' => esc_html__('communication and utilizes cutting edge logistic planning to get your shipment completed on time. itself founded of backgrounds, which simply.'),
                    'description' => esc_html__('Entre Content', 'travelor-core'),
                ]
            );

            $this->add_control(
                'background_image', [
                    'label' => esc_html__('Background Image', 'travelor-core'),
                    'type' => Controls_Manager::MEDIA,
                    'show_label' => false,
                    'description' => esc_html__('Background Image', 'travelor-core'),
                ]
            );
            $this->add_control(
                'bg_shape_image', [
                    'label' => esc_html__('BG Shape Image', 'travelor-core'),
                    'type' => Controls_Manager::MEDIA,
                    'show_label' => false,
                    'description' => esc_html__('BG Shape Image', 'travelor-core'),
                ]
            );



        $this->end_controls_section();

        $this->start_controls_section(
            'service_slider_section',
            [
                'label' => esc_html__('Service Slider', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'slider_sub_title', [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Save Up To 25%', 'travelor-core'),
                'show_label' => true,
                'description' => esc_html__('Enter Name', 'travelor-core'),
            ]
        );
       
        $repeater->add_control(
            'slider_title', [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Special Discount Offering', 'travelor-core'),
                'description' => esc_html__('Enter Title', 'travelor-core'),
            ]
        );

        $repeater->add_control(
            'slider_image', [
                'label' => esc_html__('Slider Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Slider Image', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'slider_background_image', [
                'label' => esc_html__('Slider BG Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Slider BG Image', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Booking Now', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'Booking Now', 'travelor-core' ),
            ]
        );
        $repeater->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );
        $this->add_control('service_items', [
            'label' => esc_html__('Service Slider Item', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
         $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.tw-text-lg" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.tw-text-lg"
        ]);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Title Margin', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .tw-mb-10" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);


        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $service_items = $settings['service_items'];
		
		echo '
            <script>
                jQuery(document).ready(function($) {
					var slider = new Swiper(".service-three-active", {
						slidesPerView: 3,
						spaceBetween: 30,
						loop: true,
						speed: 3000,
						autoplay: true,
						breakpoints: {
						  "1400": {
							slidesPerView: 4,
						  },
						  "1200": {
							slidesPerView: 4,
						  },
						  "992": {
							slidesPerView: 3,
						  },
						  "768": {
							slidesPerView: 2,
						  },
						  "576": {
							slidesPerView: 1,
						  },
						  "0": {
							slidesPerView: 1,
						  },
						},
					  });
				});
            </script>';
        ?>

            <div class="service-three-area background-img position-relative z-1" data-background-image="<?php echo $settings['background_image']['url'] ?>">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-8"> 
                            <div class="section-wrapper text-center tw-pt-10 tw-mb-10" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                <?php if($settings['subtitle']) : ?>
                                    <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4 text-main-two-600">
                                        <?php echo $settings['subtitle']; ?>
                                    </h6>
                                <?php endif; ?>
                                <?php if($settings['title']) : ?>
                                    <h2 class="section-title fw-normal tw-mb-7 char-animation">
                                        <?php echo $settings['title']; ?>
                                    </h2>
                                <?php endif; ?>
                                <?php if($settings['content']) : ?>
                                    <p class="section-paragraph tw-text-lg fw-normal">
                                        <?php echo $settings['content']; ?>
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($settings['bg_shape_image']['url']) : ?>
                    <div class="service-three-shape start-0 position-absolute z-n1">
                        <img src="<?php echo $settings['bg_shape_image']['url'] ?>" alt="">
                    </div>
                <?php endif; ?>
            </div>

            <div class="service-three-bottom-area position-relative z-1">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="service-three-slider overflow-hidden">
                                <div class="service-three-active swiper-container">
                                    <div class="swiper-wrapper">
                                        <?php 
                                            $i=0;
                                            foreach ($service_items as $item):
                                            $i++;
                                            ?>
                                            <div class="service-three-wrapper background-img tw-rounded-xl tw-py-12 tw-pb-5 swiper-slide <?php echo $i?>" data-background-image="<?php echo $item['slider_background_image']['url'] ?>" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                                <div class="tw-mb-10">
                                                    <?php if($item['slider_sub_title']) : ?>
                                                        <h6 class="tw-text-sm fw-medium text-capitalize text-main-two-600 tw-mb-3">
                                                            <?php echo $item['slider_sub_title']; ?>
                                                        </h6>
                                                    <?php endif; ?>
                                                    <?php if($item['slider_title']) : ?>
                                                        <h4 class="service-three-title tw-text-3xl text-capitalize tw-mb-4">
                                                            <?php echo $item['slider_title']; ?>
                                                        </h4>
                                                    <?php endif; ?>
                                                    <div class="service-three-button">
                                                        <a href="<?php echo esc_url($item['button_url']); ?>" class="service-three-btn fw-semibold tw-text-sm text-main-two-600 d-inline-flex align-items-center tw-gap-2 hover-text-primary">
                                                            <?php echo $item['button_text']; ?>
                                                            <span class="tw-text-lg">
                                                                <i class="ph ph-arrow-right"></i>
                                                            </span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <?php if($item['slider_image']['url']) : ?>
                                                    <div class="service-three-thumb">
                                                        <img src="<?php echo $item['slider_image']['url'] ?>" alt="thumb">
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Service_Slider_One_Widget());