<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Search_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-theme-search-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Travelor Search', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Search', 'search', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-search-bold';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'search_content',
            [
                'label' => esc_html__('Search Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'destination_icon',
            [
                'label' => esc_html__('Destination Icon', 'travelor-core'),
                'type' => Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'destination_title',
            [
                'label' => esc_html__('Destination Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Destination', 'travelor-core'),
            ]
        );
        $this->add_control(
            'activity_icon',
            [
                'label' => esc_html__('Activity Icon', 'travelor-core'),
                'type' => Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'activity_title',
            [
                'label' => esc_html__('Activity Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('All Activity', 'travelor-core'),
            ]
        );
        $this->add_control(
            'date_icon',
            [
                'label' => esc_html__('date Icon', 'travelor-core'),
                'type' => Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'date_title',
            [
                'label' => esc_html__('date Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Departure Date', 'travelor-core'),
            ]
        );
        $this->add_control(
            'guest_icon',
            [
                'label' => esc_html__('Guest Icon', 'travelor-core'),
                'type' => Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'guest_title',
            [
                'label' => esc_html__('Guest Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Guest', 'travelor-core'),
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__('Btn Icon', 'travelor-core'),
                'type' => Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Btn Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Search Here', 'travelor-core'),
            ]
        );
        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
            <style>
                .mw-25 svg {
                    max-width: 25px;
                }
                .checkout-main-wrapper .list {
                    padding: 10px 0 !important;
                }
                .checkout-main-wrapper .list li {
                    font-weight: 400 !important;
                }
                button {
                    cursor: pointer !important;
                }
            </style>
            <div class="checkout-two-area">
				<div class="checkout-area position-relative z-3">
					<div class="container">
						<form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>" class="checkout-bg bg-white tw-pt-11 tw-px-14 tw-pb-11 tw-rounded-md">
							<div class="row">
								<div class="col-xl-12">
									<div class="checkout-main-wrapper">

										<!-- Destination -->
										<div class="checkout-wrapper d-flex flex-column border-0">
											<?php if ( $settings['destination_title'] ) : ?>
												<label class="tw-text-sm fw-normal font-body d-flex align-content-center tw-gap-4 tw-mb-2">
													<?php if ( $settings['destination_icon'] ) : ?>
														<span class="mw-25"><?php Icons_Manager::render_icon( $settings['destination_icon'], ['aria-hidden' => 'true'] ); ?></span>
													<?php endif; ?>
													<?php echo esc_html( $settings['destination_title'] ); ?>
												</label>
											<?php endif; ?>
											<select name="destination" class="nice-select">
												<option value=""><?php esc_html_e( 'Your city Region', 'textdomain' ); ?></option>
												<?php
												$destinations = get_posts([
													'post_type'      => 'destination',
													'posts_per_page' => -1,
													'orderby'        => 'title',
													'order'          => 'ASC'
												]);
												foreach ( $destinations as $d ) {
													echo '<option value="' . esc_attr( $d->ID ) . '">' . esc_html( $d->post_title ) . '</option>';
												}
												?>
											</select>
										</div>

										<!-- Activity / Tour -->
										<div class="checkout-wrapper d-flex flex-column">
											<?php if ( $settings['activity_title'] ) : ?>
												<label class="tw-text-sm fw-normal font-body d-flex align-content-center tw-gap-4 tw-mb-2">
													<?php if ( $settings['activity_icon'] ) : ?>
														<span class="mw-25"><?php Icons_Manager::render_icon( $settings['activity_icon'], ['aria-hidden' => 'true'] ); ?></span>
													<?php endif; ?>
													<?php echo esc_html( $settings['activity_title'] ); ?>
												</label>
											<?php endif; ?>
											<select name="tour" class="nice-select">
												<option value=""><?php esc_html_e( 'Choose Activity', 'textdomain' ); ?></option>
												<?php
												$tours = get_posts([
													'post_type'      => 'tour',
													'posts_per_page' => -1,
													'orderby'        => 'title',
													'order'          => 'ASC'
												]);
												foreach ( $tours as $t ) {
													echo '<option value="' . esc_attr( $t->ID ) . '">' . esc_html( $t->post_title ) . '</option>';
												}
												?>
											</select>
										</div>

										<!-- Departure Date -->
										<div class="checkout-wrapper d-flex flex-column">
											<?php if ( $settings['date_title'] ) : ?>
												<label class="tw-text-sm fw-normal font-body d-flex align-content-center tw-gap-4 tw-mb-2">
													<?php if ( $settings['date_icon'] ) : ?>
														<span class="mw-25"><?php Icons_Manager::render_icon( $settings['date_icon'], ['aria-hidden' => 'true'] ); ?></span>
													<?php endif; ?>
													<?php echo esc_html( $settings['date_title'] ); ?>
												</label>
											<?php endif; ?>
											<input type="date" name="departure_date" class="nice-select">
										</div>

										<!-- Guest -->
										<div class="checkout-wrapper d-flex flex-column">
											<?php if ( $settings['guest_title'] ) : ?>
												<label class="tw-text-sm fw-normal font-body d-flex align-content-center tw-gap-4 tw-mb-2">
													<?php if ( $settings['guest_icon'] ) : ?>
														<span class="mw-25"><?php Icons_Manager::render_icon( $settings['guest_icon'], ['aria-hidden' => 'true'] ); ?></span>
													<?php endif; ?>
													<?php echo esc_html( $settings['guest_title'] ); ?>
												</label>
											<?php endif; ?>
											<select name="guests" class="nice-select">
												<option value=""><?php esc_html_e( 'Your Guest', 'textdomain' ); ?></option>
												<?php for ( $i = 1; $i <= 7; $i++ ) : ?>
													<option value="<?php echo $i; ?>"><?php echo $i; ?></option>
												<?php endfor; ?>
											</select>
										</div>

										<!-- Submit -->
										<div class="checkout-wrapper pe-0">
											<div class="checkout-button common-hover-yellow">
												<button type="submit" class="primary-btn bg-main-600 text-white tw-py-4 tw-px-9 fs-15 text-capitalize fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl text-center">
													<?php echo esc_html( $settings['btn_title'] ); ?>
													<?php if ( $settings['btn_icon'] ) : ?>
														<span class="mw-25"><?php Icons_Manager::render_icon( $settings['btn_icon'], ['aria-hidden' => 'true'] ); ?></span>
													<?php endif; ?>
												</button>
											</div>
										</div>

										<!-- Hidden field so WP search targets "tour" -->
										<input type="hidden" name="post_type" value="tour">

									</div>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Search_Widget());