<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Project_Section_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-project-section-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Project Section', 'travelor-core');
    }

    public function get_keywords()
    {
        return [ 'image','project', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'feature_content',
            [
                'label' => esc_html__('Project Section', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
    
        $this->add_control(
            'show_title',
            [
                'label' => __( 'Show / Hide title', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Populer Destination', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Shelter of Love, Compassion, and New Beginnings', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('communication and utilizes cutting edge logistic planning to get your shipment completed on time. itself founded of backgrounds, which simply.', 'travelor-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();

                $repeater->add_control(
                    'project_image', [
                        'label' => esc_html__('Project Image', 'travelor-core'),
                        'type' => Controls_Manager::MEDIA,
                        'show_label' => true,
                        'description' => esc_html__('Project Image', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'icons_type',
                    [
                        'label' => esc_html__('Select Icon or Image','travelor-core'),
                        'type' => \Elementor\Controls_Manager::CHOOSE,
                        'options' =>[
                            'img' =>[
                                'title' =>esc_html__('Image','travelor-core'),
                                'icon' =>'fa fa-picture-o',
                            ],
                            'icon' =>[
                                'title' =>esc_html__('Icon','travelor-core'),
                                'icon' =>'fa fa-info',
                            ],
                            'icon_cls' =>[
                                'title' =>esc_html__('Icon Class','travelor-core'),
                                'icon' =>'fa fa-code',
                            ]
                        ],
                        'default' => 'img',
                    ]
                );
                
                $repeater->add_control(
                    'select_icon',
                    [
                        'label' => esc_html__( 'Select Icon', 'travelor-core' ),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'condition'=>[
                            'icons_type'=> 'icon',
                        ],
                        'label_block' => true,
                    ]
                );
                
                $repeater->add_control(
                    'select_img',
                    [
                        'label' => esc_html__('Select Image','travelor-core'),
                        'type'=> \Elementor\Controls_Manager::MEDIA,
                        'condition' => [
                        'icons_type' => 'img',
                        ]
                    ]
                );

                $repeater->add_control(
                    'select_class',
                    [
                        'label' => esc_html__( 'Icon Class', 'travelor-core' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'condition'=>[
                            'icons_type'=> 'icon_cls',
                        ],
                        'label_block' => true,
                        'default' => __( 'ph-bold ph-check', 'medicol-core' ),
                    ]
                );
                $repeater->add_control(
                    'button_url',
                    [
                        'label' => __( 'Button Link', 'travelor-core' ),
                        'type' => Controls_Manager::TEXTAREA,
                        'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
                    ]
                );
                $repeater->add_control(
                    'project_title',
                    [
                        'label' => esc_html__('Project Title', 'travelor-core'),
                        'type' => Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Weekend Wanderer', 'travelor-core'),
                    ]
                );
                

            $this->add_control('project_right_items', [
                'label' => esc_html__('Project Right Item', 'medicol-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => array(
                            'url' => Utils::get_placeholder_image_src()
                        )
                    ]
                ],
            ]);

            $repeater = new \Elementor\Repeater();

                $repeater->add_control(
                    'project_image', [
                        'label' => esc_html__('Project Image', 'travelor-core'),
                        'type' => Controls_Manager::MEDIA,
                        'show_label' => true,
                        'description' => esc_html__('Project Image', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'icons_type',
                    [
                        'label' => esc_html__('Select Icon or Image','travelor-core'),
                        'type' => \Elementor\Controls_Manager::CHOOSE,
                        'options' =>[
                            'img' =>[
                                'title' =>esc_html__('Image','travelor-core'),
                                'icon' =>'fa fa-picture-o',
                            ],
                            'icon' =>[
                                'title' =>esc_html__('Icon','travelor-core'),
                                'icon' =>'fa fa-info',
                            ],
                            'icon_cls' =>[
                                'title' =>esc_html__('Icon Class','travelor-core'),
                                'icon' =>'fa fa-code',
                            ]
                        ],
                        'default' => 'img',
                    ]
                );
                
                $repeater->add_control(
                    'select_icon',
                    [
                        'label' => esc_html__( 'Select Icon', 'travelor-core' ),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'condition'=>[
                            'icons_type'=> 'icon',
                        ],
                        'label_block' => true,
                    ]
                );
                
                $repeater->add_control(
                    'select_img',
                    [
                        'label' => esc_html__('Select Image','travelor-core'),
                        'type'=> \Elementor\Controls_Manager::MEDIA,
                        'condition' => [
                        'icons_type' => 'img',
                        ]
                    ]
                );

                $repeater->add_control(
                    'select_class',
                    [
                        'label' => esc_html__( 'Icon Class', 'travelor-core' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'condition'=>[
                            'icons_type'=> 'icon_cls',
                        ],
                        'label_block' => true,
                        'default' => __( 'ph-bold ph-check', 'medicol-core' ),
                    ]
                );
                $repeater->add_control(
                    'button_url',
                    [
                        'label' => __( 'Button Link', 'travelor-core' ),
                        'type' => Controls_Manager::TEXTAREA,
                        'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
                    ]
                );
                $repeater->add_control(
                    'project_title',
                    [
                        'label' => esc_html__('Project Title', 'travelor-core'),
                        'type' => Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Hiking', 'travelor-core'),
                    ]
                );
                

            $this->add_control('project_items', [
                'label' => esc_html__('Project Item', 'medicol-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => array(
                            'url' => Utils::get_placeholder_image_src()
                        )
                    ]
                ],
            ]);

            $this->add_control(
            'show_bg_image',
            [
                'label' => __( 'Show / Hide BG Img', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'project_bg_img', [
                'label' => esc_html__('Project BG image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Project Img', 'travelor-core'),
                
            ]
        );
        $this->add_control(
            'show_shape',
            [
                'label' => __( 'Show / Hide Shape', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'project_shape1', [
                'label' => esc_html__('Project Shape1', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Project Shape1', 'travelor-core'),
                
            ]
        );
       $this->add_control(
            'project_shape2', [
                'label' => esc_html__('Project Shape2', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Project Shape2', 'travelor-core'),
                
            ]
        );
        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.tw-text-lg" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.tw-text-lg"
        ]);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Title Margin', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .tw-mb-10" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $project_right_items = $settings['project_right_items'];
        $project_items = $settings['project_items'];

        ?>
            <div class="project-area py-140 position-relative z-1">
                <div class="container">
                    <?php if( 'yes'===$settings['show_title'] ){ ?>
                        <div class="row justify-content-center">
                            <div class="col-xl-8"> 
                                <div class="section-wrapper text-center tw-mb-14" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                    <?php if($settings['subtitle']) : ?>
                                        <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">
                                            <?php echo $settings['subtitle']; ?>
                                        </h6>
                                    <?php endif; ?>
                                    <?php if($settings['title']) : ?>
                                        <h2 class="section-title fw-normal tw-mb-7 char-animation">
                                            <?php echo $settings['title']; ?>
                                        </h2>
                                    <?php endif; ?>
                                    <?php if($settings['description']) : ?>
                                        <p class="section-paragraph tw-text-lg fw-normal">
                                            <?php echo $settings['description']; ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="row">
                        <div class="col-xl-6 col-lg-5">
                            <?php foreach ($project_right_items as $item): ?>
                                <div class="project-thumb position-relative z-1 tw-mb-7" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                    <div class="project-thumb position-relative z-1 tw-mb-7">
                                        <?php if($item['project_image']['url']) : ?>
                                            <img src="<?php echo $item['project_image']['url']; ?>" alt="">
                                        <?php endif; ?>
                                        <div class="project-content d-flex align-items-center justify-content-between">
                                            <?php if($item['project_title']) : ?>
                                                <h4 class="project-title tw-text-2xl fw-normal">
                                                    <a class="hover-text-secondary" href="<?php echo esc_url($item['button_url']); ?>">
                                                        <?php echo $item['project_title']; ?>
                                                    </a>
                                                </h4>
                                            <?php endif; ?>
                                            <a class="project-btn" href="<?php echo esc_url($item['button_url']); ?>">
                                                    <?php if($item['icons_type'] == 'icon' ) : ?>
                                                    <span>
                                                        <i class="<?php echo esc_attr($item['select_icon']['value']); ?>"></i>
                                                    </span>
                                                <?php elseif($item['icons_type'] == 'img' ) : ?>
                                                    <span>
                                                        <img src="<?php echo $item['select_img']['url'];?>" alt=""/>
                                                    </span>
                                                <?php else: ?>
                                                    <span>
                                                        <i class="<?php echo esc_attr($item['select_class']); ?>"></i>
                                                    </span>
                                                <?php endif; ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="col-xl-6 col-lg-7">
                            <div class="row" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
                                <?php foreach ($project_items as $item): ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6">
                                        <div class="project-thumb position-relative z-1 tw-mb-7">
                                            <?php if($item['project_image']['url']) : ?>
                                                <img src="<?php echo $item['project_image']['url']; ?>" alt="">
                                            <?php endif; ?>
                                            <div class="project-content d-flex align-items-center justify-content-between">
                                                <?php if($item['project_title']) : ?>
                                                    <h4 class="project-title tw-text-2xl fw-normal">
                                                        <a class="hover-text-secondary" href="<?php echo esc_url($item['button_url']); ?>">
                                                            <?php echo $item['project_title']; ?>
                                                        </a>
                                                    </h4>
                                                <?php endif; ?>
                                                <a class="project-btn" href="<?php echo esc_url($item['button_url']); ?>">
                                                     <?php if($item['icons_type'] == 'icon' ) : ?>
                                                        <span>
                                                            <i class="<?php echo esc_attr($item['select_icon']['value']); ?>"></i>
                                                        </span>
                                                    <?php elseif($item['icons_type'] == 'img' ) : ?>
                                                        <span>
                                                            <img src="<?php echo $item['select_img']['url'];?>" alt=""/>
                                                        </span>
                                                    <?php else: ?>
                                                        <span>
                                                            <i class="<?php echo esc_attr($item['select_class']); ?>"></i>
                                                        </span>
                                                    <?php endif; ?>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if( 'yes'===$settings['show_bg_image'] ){ ?>
                    <?php if($settings['project_bg_img']['url']) : ?>
                        <div class="project-bg">
                            <img src="<?php echo $settings['project_bg_img']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                <?php } ?>
                <?php if( 'yes'===$settings['show_shape'] ){ ?>
                    <div class="project-bg-shape">
                        <?php if($settings['project_shape1']['url']) : ?>
                            <img class="project-bg-shape-1 position-absolute top-0 start-0 z-n1" src="<?php echo $settings['project_shape1']['url']; ?>" alt="">  
                        <?php endif; ?>
                        <?php if($settings['project_shape2']['url']) : ?>
                            <img class="project-bg-shape-2 position-absolute start-0 z-n1" src="<?php echo $settings['project_shape2']['url']; ?>" alt="">  
                        <?php endif; ?>
                    </div>
                <?php } ?>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Project_Section_Widget());