<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */
namespace Elementor;
class Travelor_Progress_Bar_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-progress-bar-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Progress Bar Travelor', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Progress', 'Bar', 'Progress Bar','skill', 'travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
	public function get_icon() {
		return 'eicon-skill-bar';
	}

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
			'icon_section',
			[
				'label' => __( 'Progress Bar', 'travelor-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
       
        $this->add_control(
            'select_style',
            [
                'label' => __( 'Select Style', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'one' => __( 'One', 'travelor-core' ),
                ],
                'default' => 'one',
            ]
        );
        $repeater = new \Elementor\Repeater();
       
        $repeater->add_control(
            'Progress_title',
            [
                'label' => esc_html__('Progress Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Business Managment', 'travelor-core'),
            ]
        );
        $repeater->add_control(
            'Progress_percent_number',
            [
                'label' => esc_html__('Progress Percent', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('70', 'travelor-core'),
            ]
        );
        $this->add_control('progress_bar_items', [
            'label' => esc_html__('Progress Item', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);

		$this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('title_color', [
            'label' => esc_html__('title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .progress-bar-content span" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .progress-bar-content span"
        ]);

        $this->end_controls_section();
    }

    /*
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $progress_bar_items = $settings['progress_bar_items'];
        ?>

            <?php if($settings['select_style']=='one'){ ?>
                
                <div class="d-flex flex-column tw-gap-4">
                    <?php foreach ($progress_bar_items as $item): ?>
                        <div class="progress-bar-content">
                            <?php if($item['Progress_title']) : ?>
                                <span class="text-lg fw-semibold tw-mb-3 d-block text-capitalize cursor-small">
                                    <?php echo $item['Progress_title']; ?>
                                </span>
                            <?php endif; ?>
                            <div class="progress-container" data-percentage='70'>
                                <div class="progress active">
                                </div>
                                <div class="percentage active cursor-small">
                                    0%
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    
                </div>

            <?php }elseif($settings['select_style']=='two'){ ?>


            <?php } ?>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Progress_Bar_Widget());