<?php
/**
 * Elementor WidgetTravelor
 * @package Travelor
 * @since 1.0.0
 */
namespace Elementor;
class Travelor_Navbar_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-navbar-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Navbar', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['icon', 'Box', 'icon box', 'travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
	public function get_icon() {
		return 'eicon-nav-menu';
	}

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
			'icon_section',
			[
				'label' => __('Nav Section', 'travelor-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control('navbar_style', [
            'label' => esc_html__('navbar style', 'medicol-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'style-1' => esc_html__('style 1', 'medicol-core'),
                'style-2' => esc_html__('style 2', 'medicol-core'),
            ),
            'default' => 'style-1',
            'description' => esc_html__('Select navbar style', 'medicol-core')
        ]);
		
        $this->add_control(
            'logo', [
                'label' => esc_html__('Logo', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Main Logo', 'travelor-core'),
            ]
        );
        $this->add_control(
            'search_status',
            [
                'label' => __( 'Show / Hide search', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'rightbar_status',
            [
                'label' => __( 'Show / Hide rightbar', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'right_link_text',
            [
                'label' => esc_html__('right link text', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Track Order', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'right_link_url',
            [
                'label' => esc_html__('right link url', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('#', 'travelor-core' ),
            ]
        );
		$this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
		$this->add_control('btn_bg_color', [
            'label' => esc_html__('Btn bg Color', 'medicol-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-two .primary-btn" => "background-color: {{VALUE}} !important"
            ]
        ]);
		$this->add_control('btn_bg_hover_color', [
            'label' => esc_html__('Btn bg hover Color', 'medicol-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-two .primary-btn::before" => "background-color: {{VALUE}} !important"
            ]
        ]);
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

            echo '
                <script>
                    jQuery(document).ready(function($) {

                        $("ul.nav-menu  > li").addClass("nav-menu__item");
                        $("ul.nav-menu  > li.menu-item-has-children").addClass("has-submenu position-relative");
                        $("ul.nav-menu  > li > a").addClass("fw-bold");
                        $("ul.nav-menu  > li.menu-item-has-children > a").addClass("nav-menu__link hover--translate-y-1 tw-pe-5 text-heading tw-py-4 fw-bold w-100");
                        $("ul.nav-menu  > li .sub-menu").addClass("nav-submenu scroll-sm position-absolute start-0 top-100 tw-w-max bg-white tw-rounded-md overflow-hidden tw-p-2 tw-mt-1 tw-duration-200 tw-z-99 p-2");
                        $("ul.nav-menu  > li .sub-menu li a").addClass("nav-submenu__link text-main-600 fw-medium w-100 d-block tw-py-2 tw-px-305 tw-rounded font-dmsans fw-semibold");
                        
                        $(".mobile-menu__menu ul > li a").addClass("nav-menu__link w-100");
                    });
                </script>';
            ?>
			
            <!--========= Start Prealoader ==============-->
		<?php
            $preloader_enable = cs_get_option('preloader_enable');
            $preloader_image = cs_get_option('preloader_image');
            $preloader_name = cs_get_option('preloader_name');
			$pln_letters = str_split($preloader_name);
            if($preloader_enable == true) :
        ?>
			 <div class="loading-screen" id="loading-screen">
				<span class="bar top-bar"></span>
				<span class="bar down-bar"></span>
				<div class="animation-preloader">
					<?php if($preloader_image['url']) : ?>
						<div class="spinner"><img src="<?php echo $preloader_image['url']; ?>" alt=""></div>
					<?php endif; ?>
					<div class="txt-loading">
						<?php foreach ($pln_letters as $letter) { ?>
							<span data-text-preloader="<?php echo $letter; ?>" class="letters-loading">
								<?php echo $letter; ?>
							</span>
						<?php } ?>
					</div>
				</div>
			</div>
		<?php endif; ?>
			<!--========= End Prealoader ==============-->
            
            <div class="overlay"></div>
            <div class="side-overlay"></div>
            <div id="toast-container"></div>
            <!-- Custom Toast Message End -->

            <!-- ==================== Scroll to Top End Here ==================== -->
            <div class="progress-wrap">
                <svg class="progress-circle svg-content"
                    width="100%"
                    height="100%"
                    viewBox="-1 -1 102 102">
                    <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
                </svg>
            </div>
            <!-- ==================== Scroll to Top End Here ==================== -->

            <!-- ==================== Header Start Here ==================== -->
            <header class="header header-two transition-all">
                <div class="container-fluid">
                    <nav class="d-flex align-items-center justify-content-between">

                        <?php if(!empty($settings['logo']['url'])) : ?>
                            <div class="logo">
                                <a href="<?php echo get_home_url(); ?>" class="link active-scale-09">
                                    <img src="<?php echo $settings['logo']['url']; ?>" alt="Logo" class="max-w-200-px" />
                                </a>
                            </div>
                        <?php else : ?>
                            <h4><a class="site-title" href="<?php echo get_home_url(); ?>"><?php echo get_bloginfo('title'); ?></a></h4>
                        <?php endif; ?>

                        <!-- Menu Start  -->
                        <div class="header-menu d-lg-block d-none">
                            <!-- Nav menu Start -->
							<?php
								if($settings['navbar_style'] == 'style-1') {
									wp_nav_menu(array(
										'theme_location' => 'main-menu',
										'menu_class' => 'nav-menu d-lg-flex align-items-center tw-gap-6',
										'container' => 'div',
										'container_id' => 'travelor_main_menu',
										'fallback_cb' => 'travelor_theme_fallback_menu',
									));
								}elseif($settings['navbar_style'] == 'style-2'){
									wp_nav_menu(array(
										'theme_location' => 'main-menu',
										'menu_class' => 'nav-menu d-lg-flex align-items-center tw-gap-6 bg-white tw-px-12 tw-rounded-4xl px-5 border-bottom-black',
										'container' => 'div',
										'container_id' => 'travelor_main_menu',
										'fallback_cb' => 'travelor_theme_fallback_menu',
									));
								}
							?>
                            
                            <!-- Nav menu End  -->
                        </div>
                        <!-- Menu End  -->

                        <!-- Header Right start -->
						<?php if($settings['rightbar_status'] == 'yes') : ?>
                            <div class="d-flex align-items-center tw-gap-20">
								<?php if($settings['search_status'] == 'yes') : ?>
									<div>
										<button class="open-search" aria-label="search products" title="open search box">
											<span>
												<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
													<path d="M10.999 2C15.967 2 19.999 6.032 19.999 11C19.999 15.968 15.967 20 10.999 20C6.03102 20 1.99902 15.968 1.99902 11C1.99902 6.032 6.03102 2 10.999 2ZM10.999 18C14.8665 18 17.999 14.8675 17.999 11C17.999 7.1325 14.8665 4 10.999 4C7.13152 4 3.99902 7.1325 3.99902 11C3.99902 14.8675 7.13152 18 10.999 18ZM19.4843 18.0711L22.3127 20.8995L20.8985 22.3137L18.0701 19.4853L19.4843 18.0711Z" fill="#113A75"/>
													</svg>
											</span>
										</button>
									</div>
								<?php endif; ?>
								<?php if($settings['right_link_text']) : ?>
									<a href="<?php echo $settings['right_link_url']; ?>" class="primary-btn bg-white text-main-600 tw-py-5 tw-px-10 fs-15 text-uppercase fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl d-lg-inline-block d-none">
										<span class=""><?php echo $settings['right_link_text']; ?></span>
										<i class="ph ph-arrow-up-right"></i>
									</a>
								<?php endif; ?>
								<button type="button" class="toggle-mobileMenu leading-none d-lg-none ms-3 text-neutral-800 tw-text-9">
									<i class="ph ph-list"></i>
								</button>
                            </div>
						<?php endif; ?>
                        <!-- Header Right End  -->
                    </nav>
                </div>
            </header>
            <!-- ==================== Header End Here ==================== -->

            <!-- ==================== Mobile Menu Start Here ==================== -->
            <div class="mobile-menu d-lg-none d-block scroll-sm top-0 position-fixed bg-white tw-w-300-px tw-h-screen overflow-y-auto tw-p-6 tw-z-999 tw--translate-x-full tw-pb-68 ">
                <button type="button" class="close-button position-absolute tw-end-0 top-0 tw-me-2 tw-mt-2 tw-w-605 tw-h-605 rounded-circle d-flex justify-content-center align-items-center text-neutral-900 bg-neutral-200 hover-bg-neutral-900 hover-text-white"> 
                    <i class="ph ph-x"></i>
                </button>
                <div class="mobile-menu__inner">
                    <?php if(!empty($settings['logo']['url'])) : ?>
                        <div class="logo">
                            <a href="<?php echo get_home_url(); ?>" class="mobile-menu__logo">
                                <img src="<?php echo $settings['logo']['url']; ?>" alt="Logo" class="max-w-200-px" />
                            </a>
                        </div>
                    <?php else : ?>
                        <h3><a class="mobile-menu__logo" href="<?php echo get_home_url(); ?>"><?php echo get_bloginfo('title'); ?></a></h3>
                    <?php endif; ?>
                    <div class="mobile-menu__menu">
                        <!-- Nav menu Start -->
                        <?php
                            wp_nav_menu(array(
                                'theme_location' => 'main-menu',
                                'menu_class' => 'nav-menu d-lg-flex align-items-center nav-menu--mobile d-block tw-mt-8',
                                'container' => 'div',
                                'container_id' => 'travelor_main_menu',
                                'fallback_cb' => 'travelor_theme_fallback_menu',
                            ));
                        ?>
                        <!-- Nav menu End  -->
                    </div>
                </div>
            </div>  
            <!-- ==================== Mobile Menu End Here ==================== -->

			<!-- Search Popup Start -->
			<div class="search_popup">
				<div class="container">
					<div class="row">
						<div class="col-xxl-12">
							<div class="search_wrapper">
								<div class="search_top d-flex justify-content-between align-items-center">
									<?php if(!empty($settings['logo']['url'])) : ?>
										<div class="search_logo">
											<a href="<?php echo get_home_url(); ?>" class="link active-scale-09">
												<img src="<?php echo $settings['logo']['url']; ?>" alt="Logo" class="max-w-200-px" />
											</a>
										</div>
									<?php else : ?>
										<h4><a class="site-title text-white" href="<?php echo get_home_url(); ?>"><?php echo get_bloginfo('title'); ?></a></h4>
									<?php endif; ?>
									<div class="search_close">
										<button type="button" class="search_close_btn">
											<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M17 1L1 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
												<path d="M1 1L17 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
											</svg>
										</button>
									</div>
								</div>
								<div class="search_form">
									<form action="<?php echo esc_url(home_url('/'))?>">
										<div class="search_input">
											<input class="search-input-field" name="s" type="text" placeholder="Type here to search...">
											<span class="search-focus-border"></span>
											<button type="submit">
												<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
													<path d="M9.55 18.1C14.272 18.1 18.1 14.272 18.1 9.55C18.1 4.82797 14.272 1 9.55 1C4.82797 1 1 4.82797 1 9.55C1 14.272 4.82797 18.1 9.55 18.1Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
													<path d="M19.0002 19.0002L17.2002 17.2002" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
												</svg>
											</button>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="search-popup-overlay"></div>
			<!-- Search Popup End-->
            
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Navbar_Widget());