<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Instagram_Image extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-instagram-image-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('instagram image', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['image', 'instagram', 'Travelor'];
    }


    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
        'show_title',
            [
                'label' => __( 'Show / Hide Title', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('...want to become a dontation partner & contribution...', 'travelor-core'),
            ]
        );
        

        $repeater = new \Elementor\Repeater();

           $repeater->add_control(
                'main_image', [
                    'label' => esc_html__('Main Image', 'travelor-core'),
                    'type' => Controls_Manager::MEDIA,
                    'show_label' => true,
                    'description' => esc_html__('Main Image', 'travelor-core'),
                ]
            );
            $repeater->add_control(
                'icon_image', [
                    'label' => esc_html__('Icon Image', 'travelor-core'),
                    'type' => Controls_Manager::MEDIA,
                    'show_label' => true,
                    'description' => esc_html__('Icon Image', 'travelor-core'),
                ]
            );
            $repeater->add_control(
            'button_url',
                [
                    'label' => __( 'Button Link', 'travelor-core' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
                ]
            );
            $this->add_control('instagram_items', [
            'label' => esc_html__('Instagram Item', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
            ]);
            
        $this->end_controls_section();


        /*  tab styling tabs start */
        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h6" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .tw-text-2xl"
        ]);

        

        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $instagram_items = $settings['instagram_items'];
        ?>

            <div class="instagram-area">
                <div class="container">
                    <?php if( 'yes'===$settings['show_title'] ){ ?>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="text-center tw-mb-6">
                                    <?php if($settings['subtitle']) : ?>
                                        <h6 class="instagram-title tw-text-2xl fw-normal text-capitalize">
                                            <?php echo $settings['subtitle']; ?>
                                        </h6>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="row row-cols-xl-6 row-cols-md-3 row-cols-sm-3 row-cols-1">
                        <?php foreach ($instagram_items as $item): ?>
                            <div class="col">
                                <div class="instagram-wrapper" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                    <div class="instagram-thumb position-relative z-1 overflow-hidden">
                                        <img class="tw-rounded-lg" src="<?php echo $item['main_image']['url']; ?>" alt="">
                                        <div class="instagram-btn position-absolute z-1">
                                            <a href="<?php echo esc_url($item['button_url']); ?>">
                                                <span>
                                                    <img src="<?php echo $item['icon_image']['url']; ?>" alt="">
                                                </span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        
                    </div>
                </div>
            </div>






        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Instagram_Image());