<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Image_Slider_Section_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-image-slider-section-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Image Slider Section', 'travelor-core');
    }

    public function get_keywords()
    {
        return [ 'image','img', 'slider', 'title', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'title_content',
            [
                'label' => esc_html__('Image Slider Section', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
    
        $this->add_control(
            'show_title',
            [
                'label' => __( 'Show / Hide title', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('we believe that a clean space is happy space. Founded in 1998, our mission is to make homes & businesses sparkle while...', 'travelor-core'),
            ]
        );
    
            $repeater = new \Elementor\Repeater();

                $repeater->add_control(
                    'slider_image', [
                        'label' => esc_html__('Slider Image', 'travelor-core'),
                        'type' => Controls_Manager::MEDIA,
                        'show_label' => true,
                        'description' => esc_html__('Slider Image', 'travelor-core'),
                    ]
                );
                $this->add_control('image_slider_items', [
                'label' => esc_html__('Image Slider Item', 'medicol-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => array(
                            'url' => Utils::get_placeholder_image_src()
                        )
                    ]
                ],
            ]);


        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h6.travelor-text" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h6.travelor-text"
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $image_slider_items = $settings['image_slider_items'];
		
		echo '
            <script>
                jQuery(document).ready(function($) {
					var slider = new Swiper(".gallery-two-active", {
						slidesPerView: 4,
						spaceBetween: 30,
						loop: true,
						speed: 3000,
						autoplay:true,
						centeredSlides: true,
						breakpoints: {
						  "1200": {
							slidesPerView: 4,
						  },
						  "992": {
							slidesPerView: 3,
						  },
						 "768": {
							slidesPerView: 2,
						  },
						  "576": {
							slidesPerView: 2,
						  },
						  "0": {
							slidesPerView: 1,
						  },
						},
					  });
				});
            </script>';

        ?>
            
            <div class="image-slider-section overflow-hidden">
                <?php if( 'yes'===$settings['show_title'] ){ ?>
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-xl-10">
                                <?php if($settings['title']) : ?>
                                    <div class="travelor-content tp-cursor-point-area text-center tw-mb-14">
                                        <h6 class="travelor-text fw-normal">
                                            <?php echo $settings['title']; ?>
                                        </h6>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <div class="container-fluid gx-0">
                    <div class="row align-items-center">
                        <div class="gallery-two-slider">
                            <div class="gallery-two-active swiper-container">
                                <div class="swiper-wrapper d-flex align-items-center">
                                    <?php foreach ($image_slider_items as $item): ?>
                                        <div class="gallery-two-wrapper swiper-slide">
                                            <div class="gallery-two-thumb">
                                                <img class="tw-rounded-xl" src="<?php echo $item['slider_image']['url']; ?>" alt="">
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Image_Slider_Section_Widget());