<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */
namespace Elementor;
class Travelor_Icon_List_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-icon-List-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Icon List Travelor', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['icon', 'List', 'icon list', 'travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
	public function get_icon() {
		return 'eicon-editor-list-ul';
	}

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['medicol_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
			'icon_section',
			[
				'label' => __( 'Icon List', 'travelor-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
       
        $this->add_control(
            'select_style',
            [
                'label' => __( 'Select Style', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'one' => __( 'One', 'travelor-core' ),
                    'two' => __( 'Two', 'travelor-core' ),
                ],
                'default' => 'one',
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'icons_type',
            [
                'label' => esc_html__('Select Icon or Image','travelor-core'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' =>[
                    'img' =>[
                        'title' =>esc_html__('Image','travelor-core'),
                        'icon' =>'fa fa-picture-o',
                    ],
                    'icon' =>[
                        'title' =>esc_html__('Icon','travelor-core'),
                        'icon' =>'fa fa-info',
                    ],
                    'icon_cls' =>[
                        'title' =>esc_html__('Icon Class','travelor-core'),
                        'icon' =>'fa fa-code',
                    ]
                ],
                'default' => 'img',
            ]
         );
         
         $repeater->add_control(
            'select_icon',
            [
                'label' => esc_html__( 'Select Icon', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'condition'=>[
                    'icons_type'=> 'icon',
                ],
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'select_img',
            [
                'label' => esc_html__('Select Image','travelor-core'),
                'type'=> \Elementor\Controls_Manager::MEDIA,
                'condition' => [
                  'icons_type' => 'img',
                ]
            ]
        );

        $repeater->add_control(
            'select_class',
            [
                'label' => esc_html__( 'Icon Class', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition'=>[
                    'icons_type'=> 'icon_cls',
                ],
                'label_block' => true,
                'default' => __( 'ph-bold ph-check', 'travelor-core' ),
            ]
        );
        $repeater->add_control(
            'icon_list_title',
            [
                'label' => esc_html__('List Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Best Quality Services', 'travelor-core'),
            ]
        );

        $this->add_control('icon_list_items', [
            'label' => esc_html__('List Item', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);

		$this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
       
        $this->add_control('list_title_color', [
            'label' => esc_html__('list title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .icon-list-one h6" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('List title Typography', 'travelor-core'),
            'name' => 'box_title_typography',
            'description' => esc_html__('List title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .icon-list-one h6.tw-text-base"
        ]);



        $this->end_controls_section();
    }

    /*
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $icon_list_items = $settings['icon_list_items'];
        ?>

            <?php if($settings['select_style']=='one'){ ?>
                <div class="icon-list-one">
                    <div class="row gy-4">
                        <?php foreach ($icon_list_items as $item): ?>
                            <div class="col-lg-6 col-md-6 col-sm-12">
                                <div class="d-flex align-items-center tw-gap-205">
                                    <?php if($item['icons_type'] == 'icon' ) : ?>
                                        <i class="<?php echo esc_attr($item['select_icon']['value']); ?>"></i>
                                    <?php elseif($item['icons_type'] == 'img' ) : ?>
                                        <img src="<?php echo $item['select_img']['url'];?>" alt=""/>
                                    <?php else: ?>
                                        <i class="<?php echo esc_attr($item['select_class']); ?>"></i>
                                    <?php endif; ?>
                                    <h6 class="tw-text-base">
                                        <?php echo $item['icon_list_title']; ?>
                                    </h6>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php }elseif($settings['select_style']=='two'){ ?>

                <div class="icon-list-two">
                    <div>
                        <ul>
                        
                            <?php foreach ($icon_list_items as $item): ?>
                                <li class="tw-text-base fw-medium tw-mb-6 align-items-center">
                                    <span class="align-items-center tw-gap-205">
                                        <?php if($item['icons_type'] == 'icon' ) : ?>
                                            <i class="<?php echo esc_attr($item['select_icon']['value']); ?>"></i>
                                        <?php elseif($item['icons_type'] == 'img' ) : ?>
                                            <img src="<?php echo $item['select_img']['url'];?>" alt=""/>
                                        <?php else: ?>
                                            <i class="<?php echo esc_attr($item['select_class']); ?>"></i>
                                        <?php endif; ?>
                                    </span>
                                    <?php echo $item['icon_list_title']; ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>

            <?php } ?>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Icon_List_Widget());