<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Heading_Title_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-heading-title-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Heading Title', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Heading', 'Title', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-heading';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['medicol_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => __( 'Select Style', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'one' => __( 'One', 'travelor-core' ),
                    'two' => __( 'Two', 'travelor-core' ),
                ],
                'default' => 'one',
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Populer Destination', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Populer destination', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('', 'travelor-core'),
            ]
        );
        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__('Alignment', 'travelor-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'travelor-core'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'travelor-core'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'travelor-core'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'condition' => [
                    'select_style' => 'one',
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    "{{WRAPPER}} .section-main-title" => "text-align: {{VALUE}}"
                ]
            ]
        );
        $this->add_responsive_control(
            'text_alignment',
            [
                'label' => esc_html__('Alignment', 'travelor-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'travelor-core'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'travelor-core'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'travelor-core'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'condition' => [
                    'select_style' => 'two',
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    "{{WRAPPER}} .section-main-title-two" => "text-align: {{VALUE}}"
                ]
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.tw-text-lg" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.tw-text-lg"
        ]);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Title Margin', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .tw-mb-14" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        
            <?php if($settings['select_style']=='one'){ ?>
                <div class="section-main-title">
                    <div class="section-wrapper tw-mb-14" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                        <?php if($settings['subtitle']) : ?>
                            <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">
                                <?php echo $settings['subtitle']; ?>
                            </h6>
                        <?php endif; ?>
                        <?php if($settings['title']) : ?>
                            <h2 class="section-title fw-normal tw-mb-7 char-animation">
                                <?php echo $settings['title']; ?>
                            </h2>
                        <?php endif; ?>
                        <?php if($settings['description']) : ?>
                            <p class="tw-text-lg fw-normal">
                                <?php echo $settings['description']; ?>
                            </p>
                        <?php endif; ?>
                    </div>
                </div>

            <?php }elseif($settings['select_style']=='two'){ ?>

                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-9"> 
                            <div class="section-main-title">
                                <div class="section-wrapper text-center tw-mb-14" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                    <?php if($settings['subtitle']) : ?>
                                        <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">
                                            <?php echo $settings['subtitle']; ?>
                                        </h6>
                                    <?php endif; ?>
                                    <?php if($settings['title']) : ?>
                                        <h2 class="section-title fw-normal tw-mb-7 char-animation">
                                            <?php echo $settings['title']; ?>
                                        </h2>
                                    <?php endif; ?>
                                    <?php if($settings['description']) : ?>
                                        <p class="section-paragraph tw-text-lg fw-normal">
                                            <?php echo $settings['description']; ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            <?php } ?>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new  Travelor_Heading_Title_Widget());