<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Gallery_Two_Section extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-gallery-two-section-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Gallery 02 Section', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['cta', 'gallery', 'image', 'Travelor'];
    }


    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {


        $this->start_controls_section(
            'image_content',
            [
                'label' => esc_html__('Gallery image content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'gallery_image1', [
                'label' => esc_html__('Gallery Image 1', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 1', 'travelor-core'),
            ]
        );

        $this->add_control(
            'gallery_image2', [
                'label' => esc_html__('Gallery Image 2', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 2', 'travelor-core'),
            ]
        );

        $this->add_control(
            'gallery_image3', [
                'label' => esc_html__('Gallery Image 3', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 3', 'travelor-core'),
            ]
        );

        $this->add_control(
            'gallery_image4', [
                'label' => esc_html__('Gallery Image 4', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 4', 'travelor-core'),
            ]
        );

        $this->add_control(
            'gallery_image5', [
                'label' => esc_html__('Gallery Image 5', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 5', 'travelor-core'),
            ]
        );

        $this->add_control(
            'gallery_image6', [
                'label' => esc_html__('Gallery Image 6', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 6', 'travelor-core'),
            ]
        );

        $this->add_control(
            'gallery_image7', [
                'label' => esc_html__('Gallery Image 7', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 7', 'travelor-core'),
            ]
        );

        $this->add_control(
            'gallery_image8', [
                'label' => esc_html__('Gallery Image 8', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 8', 'travelor-core'),
            ]
        );

        $this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );



        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
         
        ?>
            <div class="gallery-three-area text-center">
     			<div class="gallery-three-thumb-wrap position-relative">
                    <?php if($settings['gallery_image1']['url']) : ?>
                        <div class="gallery-three-thumb-inner-1 d-none d-xl-block">
                            <img src="<?php echo $settings['gallery_image1']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                    <?php if($settings['gallery_image2']['url']) : ?>
                        <div class="gallery-three-thumb-inner-2 d-none d-xl-block">
                            <img src="<?php echo $settings['gallery_image2']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                    <?php if($settings['gallery_image3']['url']) : ?>
                        <div class="gallery-three-thumb-inner-3 d-none d-xl-block">
                            <img src="<?php echo $settings['gallery_image3']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                    <?php if($settings['gallery_image4']['url']) : ?>
                        <div class="gallery-three-thumb-inner-4 d-none d-xl-block">
                            <img src="<?php echo $settings['gallery_image4']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                    <?php if($settings['gallery_image5']['url']) : ?>
                        <div class="gallery-three-thumb-inner-5 d-none d-xl-block">
                            <img src="<?php echo $settings['gallery_image5']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                    <?php if($settings['gallery_image6']['url']) : ?>
                        <div class="gallery-three-thumb-inner-6 d-none d-xl-block">
                            <img src="<?php echo $settings['gallery_image6']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                    <?php if($settings['gallery_image7']['url']) : ?>
                        <div class="gallery-three-thumb-inner-7 d-none d-xl-block">
                            <img src="<?php echo $settings['gallery_image7']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                    <?php if($settings['gallery_image8']['url']) : ?>
                        <div class="gallery-three-thumb">
                            <img src="<?php echo $settings['gallery_image8']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                </div>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Gallery_Two_Section());