<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Gallery_Section extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-gallery-section-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Gallery Section', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['cta', 'gallery', 'Travelor'];
    }


    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Populer Destination', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Shelter of Love, Compassion, and New Beginnings', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('communication and utilizes cutting edge logistic planning to get your shipment completed on time. itself founded of backgrounds, which simply.', 'travelor-core'),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'Booking Today', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );

        $this->add_control(
            'gallery_shape_1', [
                'label' => esc_html__('Shape Image One', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Shape Image One', 'travelor-core'),
            ]
        );

        $this->add_control(
            'gallery_shape_2', [
                'label' => esc_html__('Shape Image Two', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Shape Image Two', 'travelor-core'),
            ]
        );

        $this->add_control(
            'gallery_bg_shape', [
                'label' => esc_html__('BG Shape image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('BG Shape image', 'travelor-core'),
            ]
        );
            
        $this->end_controls_section();

        $this->start_controls_section(
            'image_content',
            [
                'label' => esc_html__('Gallery image content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'gallery_image1', [
                'label' => esc_html__('Gallery Image 1', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 1', 'travelor-core'),
            ]
        );
        $this->add_control(
            'gallery_image2', [
                'label' => esc_html__('Gallery Image 2', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 2', 'travelor-core'),
            ]
        );
        $this->add_control(
            'gallery_image3', [
                'label' => esc_html__('Gallery Image 3', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 3', 'travelor-core'),
            ]
        );
        $this->add_control(
            'gallery_image4', [
                'label' => esc_html__('Gallery Image 4', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 4', 'travelor-core'),
            ]
        );
        $this->add_control(
            'gallery_image5', [
                'label' => esc_html__('Gallery Image 5', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image 5', 'travelor-core'),
            ]
        );

        $this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

      $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.tw-text-lg" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.tw-text-lg"
        ]);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Title Margin', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .tw-mb-14" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);
        
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
         
        ?>

            <div class="gallery-area pb-140 position-relative z-1">
                <div class="gallery-top">
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-xl-8"> 
                                <div class="section-wrapper text-center tw-mb-14 position-relative z-1">
                                    <?php if($settings['subtitle']) : ?>
                                        <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">
                                            <?php echo $settings['subtitle']; ?>
                                        </h6>
                                    <?php endif; ?>
                                    <?php if($settings['title']) : ?>
                                        <h2 class="section-title fw-normal tw-mb-7 char-animation">
                                            <?php echo $settings['title']; ?>
                                        </h2>
                                    <?php endif; ?>
                                    <?php if($settings['description']) : ?>
                                        <p class="section-paragraph tw-text-lg fw-normal tw-mb-13">
                                            <?php echo $settings['description']; ?>
                                        </p>
                                    <?php endif; ?>

                                    <?php if($settings['button_text']) : ?>
                                        <div class="gallery-button d-flex justify-content-center">
                                            <a href="<?php echo esc_url($settings['button_url']); ?>" class="primary-btn bg-main-two-600 text-main-600 tw-py-4 tw-px-8 fs-15 text-capitalize fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                                                <?php echo $settings['button_text']; ?>
                                                <i class="ph ph-arrow-up-right"></i>
                                            </a> 
                                        </div>
                                    <?php endif; ?>
                                    <?php if($settings['gallery_shape_1']['url']) : ?>
                                        <img class="gallery-shape-1 position-absolute start-0 z-n1" src="<?php echo $settings['gallery_shape_1']['url']; ?>" alt="">
                                    <?php endif; ?>
                                    <?php if($settings['gallery_shape_2']['url']) : ?>
                                        <img class="gallery-shape-2 position-absolute end-0 z-n1" src="<?php echo $settings['gallery_shape_2']['url']; ?>" alt="">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="gallery-bottom tw-mt-17 position-relative z-1">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-xl-2">
                                <?php if($settings['gallery_image1']['url']) : ?>
                                    <div class="gallery-thumb one">
                                        <img class="wow tw-animation-img-top" src="<?php echo $settings['gallery_image1']['url']; ?>" alt="">
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-xl-4">
                                <?php if($settings['gallery_image2']['url']) : ?>
                                    <div class="gallery-thumb two">
                                        <img class="wow tw-animation-img-left" src="<?php echo $settings['gallery_image2']['url']; ?>" alt="">
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-xl-4">
                                <div class="gallery-thumb three position-relative z-1">
                                    <?php if($settings['gallery_image3']['url']) : ?>
                                        <img class="wow tw-animation-img-right" src="<?php echo $settings['gallery_image3']['url']; ?>" alt="">
                                    <?php endif; ?>
                                    <?php if($settings['gallery_image4']['url']) : ?>
                                        <div class="gallery-thumb-4">
                                            <img class="wow tw-animation-img-right" src="<?php echo $settings['gallery_image4']['url']; ?>" alt="">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-xl-2">
                                <?php if($settings['gallery_image5']['url']) : ?>
                                    <div class="gallery-thumb five">
                                        <img class="wow tw-animation-img-top" src="<?php echo $settings['gallery_image5']['url']; ?>" alt="">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($settings['gallery_bg_shape']['url']) : ?>
                    <div>
                        <img class="gallery-bg-shape position-absolute w-100 start-0" src="<?php echo $settings['gallery_bg_shape']['url']; ?>" alt="">
                    </div>
                <?php endif; ?>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Gallery_Section());