<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Gallery_Box_Three_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-gallery-box-three-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Gallery Box 03', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['box', 'gallery', 'Travelor'];
    }


    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Discovery Island', 'travelor-core'),
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('tour & travell', 'travelor-core'),
            ]
        );

        $this->add_control(
            'button_icon', [
                'label' => esc_html__('Button Icon Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Button Icon Image', 'travelor-core'),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );

        $this->add_control(
            'gallery_image', [
                'label' => esc_html__('Gallery Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Gallery Image', 'travelor-core'),
            ]
        );
  
        $this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'image_height',
            [
                'label' => esc_html__('Image Height', 'travelor-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vh'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .gallary-thumb-height' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h4.tw-text-2xl.text-white" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h4.tw-text-2xl.text-white"
        ]);

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .gallary-ip-paragraph" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .gallary-ip-paragraph"
        ]);
        
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
         
        ?>

            <div class="gallary-ip-thumb position-relative z-1 overflow-hidden">
                <?php if($settings['gallery_image']['url']) : ?>
                    <img class="w-100 object-fit-cover tw-rounded-lg gallary-thumb-height" src="<?php echo esc_url($settings['gallery_image']['url']); ?>" alt="">
                <?php endif; ?>
                <?php if($settings['button_icon']['url']) : ?>
                    <div class="gallary-ip-button position-absolute start-50 translate-middle">
                        <a href="<?php echo esc_url($settings['button_url']); ?>" class="gallary-ip-btn tw-w-25 tw-h-25 lh-1 d-inline-flex align-items-center justify-content-center bg-main-600 rounded-circle">
                            <span>
                                <img src="<?php echo $settings['button_icon']['url']; ?>" alt="">
                            </span>
                        </a>
                    </div>
                <?php endif; ?>
                <div class="gallary-ip-content position-absolute">
                    <?php if($settings['title']) : ?>
                        <h4 class="tw-text-2xl tw-mb-2 text-white">
                            <?php echo esc_html($settings['title']); ?>
                        </h4>
                    <?php endif; ?>
                    <?php if($settings['subtitle']) : ?>
                        <p class="gallary-ip-paragraph fw-medium">
                            <?php echo esc_html($settings['subtitle']); ?>
                        </p>
                    <?php endif; ?>
                </div>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Gallery_Box_Three_Widget());