<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Feature_Two_Section_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-feature-two-section-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Feature Two', 'travelor-core');
    }

    public function get_keywords()
    {
        return [ 'image','feature', 'title', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'feature_content',
            [
                'label' => esc_html__('Feature Section', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
    
        $this->add_control(
            'show_title',
            [
                'label' => __( 'Show / Hide title', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Populer Destination', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('The facts are the facts', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('The facts are the facts communication and utilizes cutting edge logistic planning to get your shipment completed on time. itself founded of backgrounds, which simply.', 'travelor-core'),
            ]
        );

        $this->add_control(
            'show_button',
            [
                'label' => __( 'Show / Hide Button', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'explore packge', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Link Here', 'travelor-core' ),
            ]
        );

        $this->add_control(
            'right_title',
            [
                'label' => esc_html__('Right Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('(Core features)', 'travelor-core'),
            ]
        );


            $repeater = new \Elementor\Repeater();

                $repeater->add_control(
                    'icons_type',
                    [
                        'label' => esc_html__('Select Icon or Image','travelor-core'),
                        'type' => \Elementor\Controls_Manager::CHOOSE,
                        'options' =>[
                            'img' =>[
                                'title' =>esc_html__('Image','travelor-core'),
                                'icon' =>'fa fa-picture-o',
                            ],
                            'icon' =>[
                                'title' =>esc_html__('Icon','travelor-core'),
                                'icon' =>'fa fa-info',
                            ],
                            'icon_cls' =>[
                                'title' =>esc_html__('Icon Class','travelor-core'),
                                'icon' =>'fa fa-code',
                            ]
                        ],
                        'default' => 'img',
                    ]
                );
                
                $repeater->add_control(
                    'select_icon',
                    [
                        'label' => esc_html__( 'Select Icon', 'travelor-core' ),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'condition'=>[
                            'icons_type'=> 'icon',
                        ],
                        'label_block' => true,
                    ]
                );
                
                $repeater->add_control(
                    'select_img',
                    [
                        'label' => esc_html__('Select Image','travelor-core'),
                        'type'=> \Elementor\Controls_Manager::MEDIA,
                        'condition' => [
                        'icons_type' => 'img',
                        ]
                    ]
                );

                $repeater->add_control(
                    'select_class',
                    [
                        'label' => esc_html__( 'Icon Class', 'travelor-core' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'condition'=>[
                            'icons_type'=> 'icon_cls',
                        ],
                        'label_block' => true,
                        'default' => __( 'ph-bold ph-check', 'medicol-core' ),
                    ]
                );
                $repeater->add_control(
                    'feature_title',
                    [
                        'label' => esc_html__('Feature Title', 'travelor-core'),
                        'type' => Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Best Pricing Garuentee', 'travelor-core'),
                    ]
                );
            
            $this->add_control('feature_slider_items', [
                'label' => esc_html__('Feature Slide Item', 'medicol-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => array(
                            'url' => Utils::get_placeholder_image_src()
                        )
                    ]
                ],
            ]);

        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.tw-text-lg" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.tw-text-lg"
        ]);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Title Margin', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .tw-mb-10" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);

        $this->add_control('boxtitle_color', [
            'label' => esc_html__('Box Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .destination-content h6" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Box Title Typography', 'travelor-core'),
            'name' => 'boxtitle_typography',
            'description' => esc_html__('Box Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .destination-content .tw-text-2xl"
        ]);

        $this->add_responsive_control(
			'section_padding',
			[
				'label' => __( 'Section Padding', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .destination-area.pt-140" => "padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $feature_slider_items = $settings['feature_slider_items'];

        ?>

            <section class="destination-area pt-140">
                <div class="container">
                    <div class="row align-items-center justify-content-between">
                        <?php if( 'yes'===$settings['show_title'] ){ ?>
                            <div class="col-xl-6 col-lg-7">
                                <div class="section-wrapper tw-mb-14" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                    <?php if($settings['subtitle']) : ?>
                                        <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">
                                            <?php echo $settings['subtitle']; ?>
                                        </h6>
                                    <?php endif; ?>
                                    <?php if($settings['title']) : ?>
                                        <h2 class="section-title fw-normal tw-mb-7 char-animation">
                                            <?php echo $settings['title']; ?>
                                        </h2>
                                    <?php endif; ?>
                                    <?php if($settings['description']) : ?>
                                        <p class="section-paragraph tw-text-lg fw-normal">
                                            <?php echo $settings['description']; ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php }?>
                        <?php if( 'yes'===$settings['show_button'] ){ ?>
                            <div class="col-xl-3 col-lg-3">
                                <div class="destination-button common-hover-yellow d-flex justify-content-end flex-wrap" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
                                    <a href="<?php echo esc_url($settings['button_url']); ?>" class="primary-btn bg-main-600 text-white tw-py-4 tw-px-8 fs-15 text-uppercase fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                                        <?php echo $settings['button_text']; ?>
                                        <i class="ph ph-arrow-up-right"></i>
                                    </a> 
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="destination-panel-area" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                <div class="panels position-relative overflow-hidden">
                                    <div class="panels-container d-flex tw-gap-7">
                                        <?php if($settings['right_title']) : ?>
                                            <div class="panel">
                                                <div class="destination-wrap-frist-chile">
                                                    <span class="destination-text text-uppercase tw-text-lg fw-medium">
                                                        <?php echo $settings['right_title']; ?>
                                                    </span>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php foreach ($feature_slider_items as $item): ?>
                                            <div class="panel">
                                                <div class="destination-wrap">
                                                    <div class="destination-icon">
                                                         <?php if($item['icons_type'] == 'icon' ) : ?>
                                                            <span>
                                                                <i class="<?php echo esc_attr($item['select_icon']['value']); ?>"></i>
                                                            </span>
                                                        <?php elseif($item['icons_type'] == 'img' ) : ?>
                                                            <span>
                                                                <img src="<?php echo $item['select_img']['url'];?>" alt=""/>
                                                            </span>
                                                        <?php else: ?>
                                                            <span>
                                                                <i class="<?php echo esc_attr($item['select_class']); ?>"></i>
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php if($item['feature_title']) : ?>
                                                        <div class="destination-content">
                                                            <h6 class="tw-text-2xl fw-normal">
                                                                <?php echo $item['feature_title']; ?>
                                                            </h6>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Feature_Two_Section_Widget());