<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Feature_Slider_Section_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-feature-slider-section-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Feature Slider Section', 'travelor-core');
    }

    public function get_keywords()
    {
        return [ 'image','feature', 'slider', 'title', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'feature_content',
            [
                'label' => esc_html__('Feature Section', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
    
        $this->add_control(
            'show_title',
            [
                'label' => __( 'Show / Hide title', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Populer package', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Explore Our Popular Picks Trusted by Thousands', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('communication and utilizes cutting edge logistic planning to get your shipment completed on time. itself founded of backgrounds, which simply.', 'travelor-core'),
            ]
        );

            $repeater = new \Elementor\Repeater();

                $repeater->add_control(
                    'feature_image', [
                        'label' => esc_html__('Feature Image', 'travelor-core'),
                        'type' => Controls_Manager::MEDIA,
                        'show_label' => true,
                        'description' => esc_html__('Feature Image', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'icons_type',
                    [
                        'label' => esc_html__('Select Icon or Image','travelor-core'),
                        'type' => \Elementor\Controls_Manager::CHOOSE,
                        'options' =>[
                            'img' =>[
                                'title' =>esc_html__('Image','travelor-core'),
                                'icon' =>'fa fa-picture-o',
                            ],
                            'icon' =>[
                                'title' =>esc_html__('Icon','travelor-core'),
                                'icon' =>'fa fa-info',
                            ],
                            'icon_cls' =>[
                                'title' =>esc_html__('Icon Class','travelor-core'),
                                'icon' =>'fa fa-code',
                            ]
                        ],
                        'default' => 'img',
                    ]
                );
                
                $repeater->add_control(
                    'select_icon',
                    [
                        'label' => esc_html__( 'Select Icon', 'travelor-core' ),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'condition'=>[
                            'icons_type'=> 'icon',
                        ],
                        'label_block' => true,
                    ]
                );
                
                $repeater->add_control(
                    'select_img',
                    [
                        'label' => esc_html__('Select Image','travelor-core'),
                        'type'=> \Elementor\Controls_Manager::MEDIA,
                        'condition' => [
                        'icons_type' => 'img',
                        ]
                    ]
                );

                $repeater->add_control(
                    'select_class',
                    [
                        'label' => esc_html__( 'Icon Class', 'travelor-core' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'condition'=>[
                            'icons_type'=> 'icon_cls',
                        ],
                        'label_block' => true,
                        'default' => __( 'ph-bold ph-check', 'medicol-core' ),
                    ]
                );
                $repeater->add_control(
                    'location',
                    [
                        'label' => esc_html__('Location', 'travelor-core'),
                        'type' => Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Lombok, Indonesia', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'feature_title',
                    [
                        'label' => esc_html__('Feature Title', 'travelor-core'),
                        'type' => Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Weekend Wanderer', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'feature_days',
                    [
                        'label' => esc_html__('Feature Days', 'travelor-core'),
                        'type' => Controls_Manager::TEXT,
                        'default' => esc_html__('7 Days . 6 Nights', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'feature_price',
                    [
                        'label' => esc_html__('Feature Price', 'travelor-core'),
                        'type' => Controls_Manager::TEXT,
                        'default' => esc_html__('$799', 'travelor-core'),
                    ]
                );

            $this->add_control('feature_slider_items', [
                'label' => esc_html__('Feature Slider Item', 'medicol-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => array(
                            'url' => Utils::get_placeholder_image_src()
                        )
                    ]
                ],
            ]);

        $this->add_control(
            'show_button',
            [
                'label' => __( 'Show / Hide Button', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'explore packge', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Link Here', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'show_line_shape',
            [
                'label' => __( 'Show / Hide Line Shape', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.tw-text-lg" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.tw-text-lg"
        ]);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Title Margin', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .tw-mb-10" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $feature_slider_items = $settings['feature_slider_items'];
		echo '
            <script>
                jQuery(document).ready(function($) {
					var slider = new Swiper(".feature-active", {
						slidesPerView: 4,
						spaceBetween: 30,
						loop: true,
						speed: 3000,
						autoplay: true,
						breakpoints: {
						  "1400": {
							slidesPerView: 4,
						  },
						  "1200": {
							slidesPerView: 4,
						  },
						  "992": {
							slidesPerView: 2,
						  },
						  "768": {
							slidesPerView: 2,
						  },
						  "576": {
							slidesPerView: 1,
						  },
						  "0": {
							slidesPerView: 1,
						  },
						},
					  });
        		});
            </script>';
        ?>
            <div class="feature-area position-relative z-1 pt-140">
                <div class="container">
                    <?php if( 'yes'===$settings['show_title'] ){ ?>
                        <div class="row justify-content-center">
                             <div class="col-xl-7"> 
                                <div class="section-wrapper text-center tw-mb-10" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                    <?php if($settings['subtitle']) : ?>
                                        <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">
                                            <?php echo $settings['subtitle']; ?>
                                        </h6>
                                    <?php endif; ?>
                                    <?php if($settings['title']) : ?>
                                        <h2 class="section-title fw-normal tw-mb-7 char-animation">
                                            <?php echo $settings['title']; ?>
                                        </h2>
                                    <?php endif; ?>
                                    <?php if($settings['description']) : ?>
                                        <p class="section-paragraph tw-text-lg fw-normal">
                                            <?php echo $settings['description']; ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="feature-slider overflow-hidden">
                                <div class="feature-active swiper-container">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($feature_slider_items as $item): ?>
                                            <div class="feature-wrapper tw-mb-7 tw-rounded-xl overflow-hidden  swiper-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                                <div class="feature-thumb position-relative z-1 tw-rounded-xl">
                                                    <?php if($item['feature_image']['url']) : ?>
                                                        <img class="w-100 tw-rounded-2xl" src="<?php echo $item['feature_image']['url']; ?>" alt="">
                                                    <?php endif; ?>
                                                    <div class="feature-wrap position-absolute start-0 bottom-0 z-1 w-100 tw-px-5 tw-mb-10">
                                                        <div class="feature-top tw-pb-4 tw-mb-3">
                                                            <?php if($item['location']) : ?>
                                                                <h6 class="text-white font-body fw-medium tw-text-xs d-inline-flex tw-gap-2 tw-mb-3">
                                                                    <?php if($item['icons_type'] == 'icon' ) : ?>
                                                                        <span>
                                                                            <i class="<?php echo esc_attr($item['select_icon']['value']); ?>"></i>
                                                                        </span>
                                                                    <?php elseif($item['icons_type'] == 'img' ) : ?>
                                                                        <span>
                                                                            <img src="<?php echo $item['select_img']['url'];?>" alt=""/>
                                                                        </span>
                                                                    <?php else: ?>
                                                                        <span>
                                                                            <i class="<?php echo esc_attr($item['select_class']); ?>"></i>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                    <?php echo $item['location']; ?>
                                                                </h6>
                                                            <?php endif; ?>
                                                            <?php if($item['feature_title']) : ?>
                                                                <h4 class="text-white text-capitalize tw-text-xl">
                                                                    <?php echo $item['feature_title']; ?>
                                                                </h4>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <?php if($item['feature_days']) : ?>
                                                                <span class="text-white fw-medium tw-text-sm">
                                                                    <?php echo $item['feature_days']; ?>
                                                                </span>
                                                            <?php endif; ?>
                                                            <?php if($item['feature_price']) : ?>
                                                                <span class="text-white tw-text-base fw-bold">
                                                                    <?php echo $item['feature_price']; ?>
                                                                </span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if( 'yes'===$settings['show_button'] ){ ?>
                        <div class="row">
                            <div class="feature-button common-hover-yellow text-center">
                                <a class="primary-btn bg-main-600 text-white tw-py-4 tw-px-8 fs-15 text-uppercase fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl" href="<?php echo esc_url($settings['button_url']); ?>">
                                    <?php echo $settings['button_text']; ?>
                                    <i class="ph ph-arrow-up-right"></i>
                                </a>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php if( 'yes'===$settings['show_line_shape'] ){ ?>
                    <div class="feature-bg-shape position-absolute start-0 z-n1">
                        <div class="line_shape">
                            <svg width="1920" height="287" viewBox="0 0 1920 287" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path id="line_path" d="M0 286C235.807 161.804 715.277 -31.6361 948 104C1192.5 246.5 1698.62 102.064 1920 1" stroke="#CEC7BE" stroke-dasharray="4 4" />
                                <g id="paper-plane">
                                    <path  d="M8.52862 0.643979C8.65472 0.654731 12.5944 5.1037 15.7327 8.66873C16.0616 8.64319 16.3357 8.62234 16.3357 8.62234L16.6797 8.10704L19.1766 7.91312L19.3247 9.82093L16.9109 10.0082C17.5051 10.6843 18.0375 11.2905 18.4682 11.7814C21.1362 11.6535 26.2869 11.419 27.1597 11.4798C28.3465 11.5623 30.0418 12.128 30.0368 12.5126C30.0318 12.8972 28.4581 13.7513 27.5404 14.0673C26.8454 14.3064 21.1236 14.8358 18.3473 15.0812C17.9672 15.7098 17.5181 16.4498 17.0277 17.2557L19.8851 17.0334L20.0333 18.9412L17.5364 19.1351L17.1173 18.6791C17.1173 18.6791 16.5828 18.7209 16.1125 18.7568C13.4463 23.1189 10.1742 28.3838 9.92358 28.3613C9.49623 28.3236 8.49302 27.2688 8.49302 27.2688L9.96254 22.7816C9.52126 22.7861 9.19671 22.7262 9.18859 22.6259C9.17946 22.5123 9.58103 22.3871 10.1098 22.3303L10.8472 20.079C10.5083 20.0669 10.2756 20.0104 10.2686 19.9261C10.2611 19.828 10.5617 19.7202 10.9855 19.6563L12.4419 15.2098L6.2911 15.3333L3.00246 20.403L1.50247 20.2363L2.61746 15.6496L4.02107 15.0837C4.02107 15.0837 2.47224 15.1697 2.47782 14.7758C2.4834 14.3819 3.85476 14.0784 3.85476 14.0784L2.61875 13.8202L0.562775 9.68354L2.55228 8.81392L6.31432 13.4946L12.3097 12.4928L10.3991 8.9086C9.84767 8.93961 9.41072 8.87701 9.4014 8.76046C9.39341 8.6582 9.71898 8.54567 10.1719 8.48324L9.06011 6.39696C9.04924 6.39738 9.03867 6.39894 9.02779 6.39936C8.42442 6.44647 7.92762 6.38376 7.91735 6.25891C7.90894 6.14578 8.30449 6.02093 8.82844 5.96421L6.75475 2.07323C6.75475 2.07323 8.31696 0.625839 8.5282 0.6447L8.52862 0.643979Z" fill="#113A75"/>
                                </g>
                            </svg>
                        </div>
                    </div>
                <?php } ?>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Feature_Slider_Section_Widget());