<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;

class Travelor_Destination_Search_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-destination-search-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Destination Search', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Search', 'Destination', 'Travelor'];
    }

    /**
     * Get widget icon.
     * 
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-search-bold';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'destination_settings_section',
            [
                'label' => esc_html__('Destination Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'place_holder',
            [
                'label' => esc_html__('Place Holder Text', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Search Here...', 'travelor-core'),
            ]
        );
        
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>

            <form role="search" method="get" class="position-relative" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                <input 
                    type="search" 
                    name="s" 
                    value="<?php echo get_search_query(); ?>" 
                    class="tw-ps-4 tw-pe-12 tw-py-4 bg-neutral-100 tw-rounded-xl tw-placeholder-text-main-two-600 focus-outline-0 w-100 tw-placeholder-transition-2 focus-tw-placeholder-text-hidden shadow-none flex-grow-1 border border-white focus-border-main-600 tw-duration-300" 
                    placeholder=" <?php echo $settings['place_holder']; ?>"
                >
                <input type="hidden" name="post_type" value="destination" />
                
                <button type="submit" class="position-absolute top-50 tw--translate-y-50 tw-end-0 text-main-600 tw-text-xl d-flex tw-me-5">
                    <i class="ph-bold ph-magnifying-glass"></i>
                </button>
            </form>

           
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Destination_Search_Widget());