<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;

class Travelor_Destination_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-destination-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Destination One', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Tour', 'Destination', 'Travelor'];
    }

    /**
     * Get widget icon.
     * 
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-featured-image';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'destination_settings_section',
            [
                'label' => esc_html__('Destination Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'btn_icon', [
                'label' => esc_html__('Button Icon img', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Button Icon img', 'travelor-core'),
                
            ]
        );
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'travelor-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('Enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'travelor-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => travelor()->get_terms_names('destination-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'travelor-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'travelor-core'),
                'DESC' => esc_html__('Descending', 'travelor-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'travelor-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'travelor-core'),
                'title' => esc_html__('Title', 'travelor-core'),
                'date' => esc_html__('Date', 'travelor-core'),
                'rand' => esc_html__('Random', 'travelor-core'),
                'comment_count' => esc_html__('Most Comments', 'travelor-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'travelor-core')
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h4.project-two-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('title_hover_color', [
            'label' => esc_html__('Title Hover Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h4.project-two-title .hover-text-secondary:hover" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h4.project-two-title"
        ]);

        $this->add_control('destination_color', [
            'label' => esc_html__('Destination Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .project-two-paragraph" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Destination Typography', 'travelor-core'),
            'name' => 'dest_typography',
            'description' => esc_html__('Destination typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .project-two-paragraph"
        ]);

        $this->add_control('listing_color', [
            'label' => esc_html__('Listing Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('listing_bg_color', [
            'label' => esc_html__('Listing BG Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .bg-main-two-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Listing Typography', 'travelor-core'),
            'name' => 'listing_typography',
            'description' => esc_html__('Listing typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .text-main-600"
        ]);
        
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        //setup query
        $args = array(
            'post_type' => 'destination',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'destination-cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>
        <div class="destination position-relative z-1">
            <div class="container service-container">
                <div class="row align-items-end">
                    <div class="col-xl-12">
                        <div class="row-custom-wrapper" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
                            <div class="row-custom d-flex">
                                <?php
                                $i = 0;
                                while ($post_data->have_posts()) : $post_data->the_post();
                                    $i++;

                                    if($i < 2) {
                                        $j = 'active';
                                        
                                    }else {
                                        $j = '';
                                    };

                                    $post_id = get_the_ID();
                                    $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                                    $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
                                    $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                                    $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
                                    $destination_single_meta_data = get_post_meta(get_the_ID(), 'travelor_destination_options', true);
                                    
                                    $social_icons = isset($destination_single_meta_data['social-icons']) && !empty($destination_single_meta_data['social-icons']) ? $destination_single_meta_data['social-icons'] : '';

                                    // icon
                                    $destination_icon = isset($destination_single_meta_data['destination_icon']) && !empty($destination_single_meta_data['destination_icon']) ? $destination_single_meta_data['destination_icon'] : '';
                                    $destination_description = isset($destination_single_meta_data['destination_description']) && !empty($destination_single_meta_data['destination_description']) ? $destination_single_meta_data['destination_description'] : '';
                                    
                                    ?>
                                        <div class="col-custom <?php echo $j;?>" style="background-image: url('<?php echo get_template_directory_uri().'/assets/img/1.jpg'; ?>')">
                                            <div class="service-item zn-2">
                                                <div class="service-content text-center">
                                                    <h4 class="service-title text-white child-one">
                                                        <?php echo esc_html(get_the_title($post_id)) ?>
                                                    </h4>
                                                </div>
                                            </div>
                                            <div class="service-item-2 zn-2 h-100">
                                                <div class="service-content-2 d-flex justify-content-between flex-column h-100">
                                                    <div class="d-flex justify-content-between align-items-center position-relative z-1">
                                                        <h6 class="service-listing">
                                                            <?php echo $destination_single_meta_data['destination_listing'] ?>
                                                        </h6>
                                                        <?php if($settings['btn_icon']['url']) : ?>
                                                            <div class="service-button">
                                                                <a class="service-btn" href="<?php the_permalink(); ?>">
                                                                    <span>
                                                                        <img src="<?php echo $settings['btn_icon']['url']; ?>" alt="">
                                                                    </span>
                                                                </a>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div>
                                                        <h4 class="service-title-2 text-white hover-text-secondary">
                                                            <?php echo esc_html(get_the_title($post_id)) ?>
                                                        </h4>
                                                         <?php if($destination_description) : ?>
                                                            <p class="text-white">
                                                                <?php echo $destination_description; ?>
                                                            </p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>    
                        </div>
                    </div>
                </div>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Destination_One_Widget());