<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_CTA_Section extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-cta-section-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('CTA Beauty Section', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['cta', 'beauty', 'Travelor'];
    }


    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title1',
            [
                'label' => esc_html__('Title1', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Let’s Capture', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title2',
            [
                'label' => esc_html__('Title2', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Beauty of the World', 'travelor-core'),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'Booking Today ', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );

        $this->add_control(
            'cta_bg_image', [
                'label' => esc_html__('Background Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Background Image', 'travelor-core'),
            ]
        );

        $this->add_control(
            'cta_shape_1', [
                'label' => esc_html__('Shape Image One', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Shape Image One', 'travelor-core'),
            ]
        );

        $this->add_control(
            'cta_shape_2', [
                'label' => esc_html__('Shape Image Two', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Shape Image Two', 'travelor-core'),
            ]
        );

        $this->add_control(
            'cta_bg_shape', [
                'label' => esc_html__('BG Shape image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('BG Shape image', 'travelor-core'),
            ]
        );
            
        $this->end_controls_section();


        /*  tab styling tabs start */
        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('title2_color', [
            'label' => esc_html__('Title2 Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-white" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .cta-area .section-title"
        ]);
        

        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
         
        ?>

            <div class="cta-area py-140 background-img position-relative z-1" data-background-image="<?php echo $settings['cta_bg_image']['url']; ?>">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-11">
                            <div class="section-wrapper mb-5 text-center position-relative z-1" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                <h2 class="section-title fw-normal tw-mb-7 char-animation text-white char-animation"> 
                                    <?php if($settings['title1']) : ?>
                                        <span class="text-main-600">
                                            <?php echo $settings['title1']; ?>
                                        </span>
                                    <?php endif; ?>
                                    <?php echo $settings['title2']; ?>
                                </h2>
                                <div class="gallery-button d-flex justify-content-center">
                                    <a class="primary-btn bg-main-two-600 text-main-900 tw-py-4 tw-px-8 fs-15 text-capitalize fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl" href="<?php echo esc_url($settings['button_url']); ?>">
                                        <?php echo $settings['button_text']; ?>
                                        <i class="ph ph-arrow-up-right"></i>
                                    </a> 
                                </div>
                                <div class="gallery-shape">
                                    <?php if($settings['cta_shape_1']['url']) : ?>
                                        <img class="gallery-shape-1 position-absolute start-0 z-n1" src="<?php echo $settings['cta_shape_1']['url']; ?>" alt="">
                                    <?php endif; ?>
                                    <?php if($settings['cta_shape_2']['url']) : ?>
                                        <img class="gallery-shape-2 position-absolute end-0 z-n1" src="<?php echo $settings['cta_shape_2']['url']; ?>" alt="">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($settings['cta_bg_shape']['url']) : ?>
                    <div class="cta-bg-shape position-absolute start-0 z-n1">
                        <img src="<?php echo $settings['cta_bg_shape']['url']; ?>" alt="">
                    </div>
                <?php endif; ?>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_CTA_Section());