<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Counter_One extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-counter-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Counter One', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['number', 'counter', 'Travelor'];
    }


    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-counter';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

            $repeater->add_control(
                'number', [
                    'label' => esc_html__('Number', 'travelor-core'),
                    'type' => Controls_Manager::TEXT,
                    'description' => esc_html__('enter title.', 'travelor-core'),
                    'default' => esc_html__('145', 'travelor-core')
                ]
            );
            $repeater->add_control(
                'title_text',
                [
                    'label' => __( 'Title', 'travelor-core' ),
                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'placeholder' => __( 'Enter title', 'travelor-core' ),
                    'default' => __( 'Travel Tales', 'travelor-core' ),
                ]
            );

            $this->add_control('counter_items', [
            'label' => esc_html__('Counter Item', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
            ]);
            $this->add_control(
            'show_shape_image',
                [
                    'label' => __( 'Show / Hide shape', 'travelor-core' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'travelor-core' ),
                    'label_off' => __( 'Hide', 'travelor-core' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
             $this->add_control(
                'counter_shape_bg', [
                    'label' => esc_html__('Shape bg Image', 'travelor-core'),
                    'type' => Controls_Manager::MEDIA,
                    'show_label' => true,
                    'description' => esc_html__('Shape bg Image', 'travelor-core'),
                ]
            );
        $this->end_controls_section();


        /*  tab styling tabs start */
        $this->start_controls_section(
            'styling_section',
            [
                'label' => esc_html__('counter Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('number_color', [
            'label' => esc_html__('Number Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .counter-two-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'selector' => '{{WRAPPER}} .counter-title',
            ]
        );

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .counter-two-paragraph" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .counter-two-paragraph.tw-text-505',
            ]
        );

        $this->add_responsive_control(
			'counter_padding',
			[
				'label' => __( 'Title Padding', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .counter-two-area" => "padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);



        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $counter_items = $settings['counter_items'];
        ?>

            <div class="counter-two-area position-relative z-1">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-10">
                            <div class="row">
                                 <?php foreach ($counter_items as $item): ?>
                                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6">
                                        <div class="counter-wrap text-center tw-mb-8" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                            <div class="counter-content">
                                                <?php if($item['number']) : ?>
                                                    <h2 class="counter-title counter-two-title fw-semibold">
                                                        <span class="purecounter" data-purecounter-duration="1" data-purecounter-end="<?php echo $item['number']; ?>">
                                                        </span>
                                                    </h2>
                                                <?php endif; ?>
                                                <?php if($item['title_text']) : ?>
                                                    <p class="counter-paragraph counter-two-paragraph tw-text-3xl tw-text-505 fw-bold text-capitalize">
                                                        <?php echo $item['title_text']; ?>
                                                    </p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if( 'yes'===$settings['show_shape_image'] ){ ?>
                    <?php if($settings['counter_shape_bg']['url']) : ?>
                        <div class="counter-two-shape position-absolute start-0 bottom-0 z-n1 w-100">
                            <img class="w-100" src="<?php echo $settings['counter_shape_bg']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                <?php } ?>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Counter_One());