<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Circle_Button_Widget extends Widget_Base
{

    /**
     * Get widget name.
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'travelor-circle-button-widget';
    }

    /**
     * Get widget title.
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Circle Button', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['circle', 'Button', 'Travelor'];
    }

    /**
     * Get widget icon.
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-button';
    }

    /**
     * Get widget categories.
     * @return array Widget categories.
     *
     */
    public function get_categories()
    {
        return ['Travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => __('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => __( 'Select Style', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'one' => __( 'One', 'travelor-core' ),
                    'two' => __( 'Two', 'travelor-core' ),
                ],
                'default' => 'one',
            ]
        );
        
        $this->add_control(
            'btn_text',
            [
                'label' => __('Btn text', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'description' => __('enter  btn text.', 'travelor-core'),
                'default' => __('explore more', 'travelor-core'),
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => __('Btn url', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => __('Enter  btn url.', 'travelor-core'),
                'default' => __('#', 'travelor-core'),
            ]
        );
        $this->add_control(
            'show_icon',
            [
                'label' => __( 'Show / Hide Icon', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
				'icons_type',
				[
				    'label' => esc_html__('Select Icon or Image','travelor-core'),
				    'type' => \Elementor\Controls_Manager::CHOOSE,
				    'options' =>[
                        'img' =>[
                            'title' =>esc_html__('Image','travelor-core'),
                            'icon' =>'fa fa-picture-o',
                        ],
                        'icon' =>[
                            'title' =>esc_html__('Icon','travelor-core'),
                            'icon' =>'fa fa-info',
                        ],
                        'icon_cls' =>[
                            'title' =>esc_html__('Icon Class','travelor-core'),
                            'icon' =>'fa fa-code',
                        ]
				    ],
				    'default' => 'icon_cls',
				]
			 );
			 
			 $this->add_control(
				'select_icon',
				[
					'label' => esc_html__( 'Select Icon', 'travelor-core' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'condition'=>[
						'icons_type'=> 'icon',
					],
					'label_block' => true,
				]
			);
			
			$this->add_control(
				'select_img',
				[
				    'label' => esc_html__('Select Image','travelor-core'),
				    'type'=> \Elementor\Controls_Manager::MEDIA,
				    
				    'condition' => [
					  'icons_type' => 'img',
				    ]
				]
			);

            $this->add_control(
				'select_class',
				[
					'label' => esc_html__( 'Icon Class', 'travelor-core' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'condition'=>[
						'icons_type'=> 'icon_cls',
					],
					'label_block' => true,
                    'default' => __( 'ph ph-arrow-up-right', 'travelor-core' ),
				]
			);
        
        $this->end_controls_section();

        //style tab start
        $this->start_controls_section(
            'styling_section',
            [
                'label' => __('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
		
        $this->add_responsive_control(
            'btn_border_radius',
            [
                'label' => __('Button Border Radius', 'medicol-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    "{{WRAPPER}} .btn-wrapper .tw-rounded-4xl" => "border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
                ],
            ]
        );
        $this->add_control('btn_color', [
            'label' => __('btn Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('btn_bg_color', [
            'label' => __('btn bg Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .bg-main-two-600" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('btn_before_bg_color', [
            'label' => __('btn before bg Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .primary-btn::before" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('btn_hover_color', [
            'label' => __('btn hover Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .primary-btn.text-main-600:hover" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'btn_extra_typography',
            'label' => __('Btn Typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .btn-wrapper .primary-btn"
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
    ?>
        <?php if($settings['select_style']=='one'){ ?>

            <div class="tw-hover-btn-wrapper d-inline-block">
                <a class="tw-btn-circle tw-hover-btn-item tw-hover-btn" href="<?php echo $settings['btn_url'] ?>">
                    <span class="d-flex flex-column justify-content-center">
                        <?php if( 'yes'===$settings['show_icon'] ){ ?>
                            <?php if($settings['icons_type'] == 'icon' ) : ?>
                                <span class="tw-btn-circle-icon">
                                    <i class=" <?php echo esc_attr($settings['select_icon']['value']); ?>"></i>
                                </span>
                            <?php elseif($settings['icons_type'] == 'img' ) : ?>
                                <span class="tw-btn-circle-icon">
                                    <img src="<?php echo $settings['select_img']['url'];?>" alt=""/>
                                </span>
                            <?php else: ?>
                                <span class="tw-btn-circle-icon">
                                    <i class="<?php echo esc_attr($settings['select_class']); ?>"></i>
                                </span>
                            <?php endif; ?>
                        <?php } ?>
                        <span class="text-white fw-bold">
                            <?php echo $settings['btn_text'] ?>
                        </span>
                    </span>
                    <i class="tw-btn-circle-dot"></i>
                </a>
            </div>

            <?php }elseif($settings['select_style']=='two'){ ?>
            
        <?php } ?>
    <?php
    }
}
Plugin::instance()->widgets_manager->register(new Travelor_Circle_Button_Widget());