<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Category_Slider_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-category-slider-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('category Slider', 'travelor-core');
    }

    public function get_keywords()
    {
        return [ 'image','img', 'category', 'slider', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

       $this->start_controls_section(
            'category_slider_section',
            [
                'label' => esc_html__('Category Slider Items', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
    
            $repeater = new \Elementor\Repeater();

                $repeater->add_control(
                    'category_image', [
                        'label' => esc_html__('Category Image', 'travelor-core'),
                        'type' => Controls_Manager::MEDIA,
                        'show_label' => true,
                        'description' => esc_html__('Category Image', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'category_title',
                    [
                        'label' => esc_html__('Title', 'travelor-core'),
                        'type' => Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Adventure', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'category_tour_text',
                    [
                        'label' => esc_html__('Tour Text', 'travelor-core'),
                        'type' => Controls_Manager::TEXT,
                        'default' => esc_html__('3 Tours', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'category_price',
                    [
                        'label' => esc_html__('Price', 'travelor-core'),
                        'type' => Controls_Manager::TEXT,
                        'default' => esc_html__('from 256$', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'category_shape', [
                        'label' => esc_html__('Category Shape', 'travelor-core'),
                        'type' => Controls_Manager::MEDIA,
                        'show_label' => true,
                        'description' => esc_html__('Category Shape', 'travelor-core'),
                    ]
                );

                $this->add_control('category_slider_items', [
                'label' => esc_html__('Category Slider Item', 'medicol-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => array(
                            'url' => Utils::get_placeholder_image_src()
                        )
                    ]
                ],
            ]);

        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);


        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $category_slider_items = $settings['category_slider_items'];
		
		echo '
            <script>
                jQuery(document).ready(function($) {
					var slider = new Swiper(".catagori-three-active", {
						slidesPerView: 3,
						spaceBetween: 30,
						loop: true,
						speed: 3000,
						autoplay: true,
						breakpoints: {
						  "1400": {
							slidesPerView: 5,
						  },
						  "1200": {
							slidesPerView: 4,
						  },
						  "992": {
							slidesPerView: 3,
						  },
						  "768": {
							slidesPerView: 2,
						  },
						  "576": {
							slidesPerView: 1,
						  },
						  "0": {
							slidesPerView: 1,
						  },
						},
					  });
				});
            </script>';

        ?>
            <div class="catagori-three-area">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="catagori-three-slider overflow-hidden">
                                <div class="catagori-three-active swiper-container">
                                    <div class="swiper-wrapper">
                                        <?php foreach ($category_slider_items as $item): ?>
                                            
                                            <div class="catagori-three-wrapper text-center tw-p-10 tw-rounded-md tw-mb-8 position-relative z-1 swiper-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                                <?php if($item['category_image']['url']) : ?>
                                                    <div class="tw-mb-8">
                                                        <span class="tw-h-16">
                                                            <img src="<?php echo $item['category_image']['url']; ?>" alt="">
                                                        </span>
                                                    </div>
                                                <?php endif ?>
                                                <div>
                                                    <?php if($item['category_title']) : ?>
                                                        <h4 class="catagori-three-title fw-semibold tw-mb-6 tw-text-xl">
                                                            <?php echo $item['category_title']; ?>
                                                        </h4>
                                                    <?php endif; ?>
                                                    <?php if($item['category_tour_text']) : ?>
                                                        <span class="catagori-three-tour bg-white tw-py-1 tw-px-6 tw-rounded-4xl tw-mb-10 text-main-600 fw-medium tw-text-sm">
                                                            <?php echo $item['category_tour_text']; ?>
                                                        </span>
                                                    <?php endif; ?>
                                                    <?php if($item['category_price']) : ?>
                                                        <p class="catagori-three-text fw-bold text-main-600">
                                                            <?php echo $item['category_price']; ?>
                                                        </p>
                                                    <?php endif; ?>
                                                </div>
                                                 <?php if($item['category_shape']['url']) : ?>
                                                    <div class="catagori-three-shape position-absolute z-n1 ">
                                                        <img src="<?php echo $item['category_shape']['url']; ?>" alt="">
                                                    </div>
                                                <?php endif?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Category_Slider_Widget());