<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Category_Section_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-category-section-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Category Section', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['section', 'category', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-post';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'category_content',
            [
                'label' => esc_html__('Category Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('tour catagorires', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Shelter of Love, Compassion, and New Beginnings', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('communication and utilizes cutting edge logistic planning to get your shipment completed 
                              on time. itself founded of backgrounds, which simply.', 'travelor-core'),
            ]
        );

        $this->add_control(
            'category_title1',
            [
                'label' => esc_html__('Category Title1', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Cultural', 'travelor-core'),
            ]
        );
        $this->add_control(
            'category_url1',
            [
                'label' => __( 'Category Link1', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'category_bg1', [
                'label' => esc_html__('Category BG1 ', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );

        $this->add_control(
            'plane_icon1', [
                'label' => esc_html__('Plane Icon', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );
        $this->add_control(
            'category_title2',
            [
                'label' => esc_html__('Category Title2', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Adventure', 'travelor-core'),
            ]
        );
        $this->add_control(
            'category_url2',
            [
                'label' => __( 'Category Link2', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'plane_icon2', [
                'label' => esc_html__('Plane Icon', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );
        $this->add_control(
            'category_bg2', [
                'label' => esc_html__('Category BG2', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );

        $this->add_control(
            'category_title3',
            [
                'label' => esc_html__('Category Title3', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Nature & wildlife', 'travelor-core'),
            ]
        );
        $this->add_control(
            'category_url3',
            [
                'label' => __( 'Category Link3', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'category_bg3', [
                'label' => esc_html__('Category BG3 ', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );
        $this->add_control(
            'category_title4',
            [
                'label' => esc_html__('Category Title4', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Histtorical', 'travelor-core'),
            ]
        );
        $this->add_control(
            'category_url4',
            [
                'label' => __( 'Category Link4', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'category_bg4', [
                'label' => esc_html__('Category BG4 ', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );
        $this->add_control(
            'plane_icon3', [
                'label' => esc_html__('Plane Icon', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );
        $this->add_control(
            'category_title5',
            [
                'label' => esc_html__('Category Title5', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Religious', 'travelor-core'),
            ]
        );
        $this->add_control(
            'category_url5',
            [
                'label' => __( 'Category Link5', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'category_bg5', [
                'label' => esc_html__('Category BG5', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );
        $this->add_control(
            'show_button',
            [
                'label' => __( 'Show / Hide Button', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'See all destination ', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );

        $this->add_control(
            'top_shape_bg', [
                'label' => esc_html__('Top Shape BG', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );
        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .font-sofia.tw-text-2xl"
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h1.banner-two-title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h1.banner-two-title"
        ]);

        $this->add_control('button_color', [
            'label' => esc_html__('Button Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .primary-btn.text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('btn_bg_color', [
            'label' => esc_html__('btn bg Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .bg-main-two-600" => "background: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Button Typography', 'travelor-core'),
            'name' => 'button_typography',
            'description' => esc_html__('Button typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .primary-btn.font-heading"
        ]);

        $this->add_control('btn_before_color', [
            'label' => esc_html__('btn before Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .primary-btn::before" => "background: {{VALUE}} !important"
            ]
        ]);
        
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
            
            <div class="catagori-area py-140 position-relative z-1">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-10"> 
                            <div class="section-wrapper text-center tw-pt-20 tw-mb-19" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                <?php if($settings['sub_title']) : ?>
                                    <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">
                                        <?php echo $settings['sub_title']; ?>
                                    </h6>
                                <?php endif; ?>
                                <?php if($settings['title']) : ?>
                                    <h2 class="section-title fw-normal tw-mb-7 char-animation text-white">
                                        <?php echo $settings['title']; ?>
                                    </h2>
                                <?php endif; ?>
                                <?php if($settings['description']) : ?>
                                    <p class="section-paragraph tw-text-lg fw-normal text-white">
                                        <?php echo $settings['description']; ?>
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-center">
                        <div class="col-xl-12">
                            <div class="catagori-widgets one wt-hover__widget d-flex justify-content-between tw-mb-10">
                                <?php if($settings['category_title1']) : ?>
                                    <div class="catagori-item current wt-widget__item wt-hover__reveal-item">
                                        <a href="<?php echo esc_url($settings['category_url1']); ?>">
                                            <div class="catagori-content">
                                                <h3 class="catagori-title text-white tw-text-18 fw-normal text-decoration-underline hover-text-secondary">
                                                    <?php echo $settings['category_title1']; ?>
                                                </h3>
                                            </div>
                                        </a>
                                        <?php if($settings['category_bg1']['url']) : ?>
                                            <div class="wt-hover__reveal-bg background-img" data-background-image="<?php echo $settings['category_bg1']['url']; ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <?php if($settings['category_title2']) : ?>
                                    <div class="catagori-item wt-widget__item wt-hover__reveal-item">
                                        <a href="<?php echo esc_url($settings['category_url2']); ?>">
                                            <div class="catagori-content d-flex tw-gap-4 align-items-center">
                                                <?php if($settings['plane_icon1']['url']) : ?>
                                                    <span>
                                                        <img src="<?php echo $settings['plane_icon1']['url']; ?>" alt="plant">
                                                    </span>
                                                <?php endif; ?>
                                                <h3 class="catagori-title text-white tw-text-18 fw-normal text-decoration-underline hover-text-secondary">
                                                    <?php echo $settings['category_title2']; ?>
                                                </h3>
                                            </div>
                                        </a>
                                        <?php if($settings['category_bg2']['url']) : ?>
                                            <div class="wt-hover__reveal-bg background-img" data-background-image="<?php echo $settings['category_bg2']['url']; ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <?php if($settings['category_title3']) : ?>
                                    <div class="catagori-item wt-widget__item wt-hover__reveal-item">
                                        <a href="<?php echo esc_url($settings['category_url3']); ?>">
                                            <div class="catagori-content d-flex tw-gap-4 align-items-center">
                                                <?php if($settings['plane_icon2']['url']) : ?>
                                                    <span>
                                                        <img src="<?php echo $settings['plane_icon2']['url']; ?>" alt="plant">
                                                    </span>
                                                <?php endif; ?>
                                                <h3 class="catagori-title text-white tw-text-18 fw-normal text-decoration-underline hover-text-secondary">
                                                    <?php echo $settings['category_title3']; ?>
                                                </h3>
                                            </div>
                                        </a>
                                        <?php if($settings['category_bg3']['url']) : ?>
                                            <div class="wt-hover__reveal-bg background-img" data-background-image="<?php echo $settings['category_bg3']['url']; ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <span class="active-bg"></span>
                            </div>
                        </div>
                        
                        <div class="col-xl-8 col-lg-8 col-md-10">
                            <div class="catagori-widgets two wt-hover__widget d-flex justify-content-between">
                                <?php if($settings['category_title4']) : ?>
                                    <div class="catagori-item current wt-widget__item wt-hover__reveal-item">
                                        <a href="<?php echo esc_url($settings['category_url4']); ?>">
                                            <div class="catagori-content">
                                                <h3 class="catagori-title text-white tw-text-18 fw-normal text-decoration-underline hover-text-secondary">
                                                    <?php echo $settings['category_title4']; ?>
                                                </h3>
                                            </div>
                                        </a>
                                        <?php if($settings['category_bg4']['url']) : ?>
                                            <div class="wt-hover__reveal-bg background-img" data-background-image="<?php echo $settings['category_bg4']['url']; ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <?php if($settings['category_title5']) : ?>
                                    <div class="catagori-item wt-widget__item wt-hover__reveal-item">
                                        <a href="<?php echo esc_url($settings['category_url5']); ?>">
                                            <div class="catagori-content d-flex tw-gap-4 align-items-center">
                                                <?php if($settings['plane_icon3']['url']) : ?>
                                                    <span>
                                                        <img src="<?php echo $settings['plane_icon3']['url']; ?>" alt="plant">
                                                    </span>
                                                <?php endif; ?>
                                                <h3 class="catagori-title text-white tw-text-18 fw-normal text-decoration-underline hover-text-secondary">
                                                    <?php echo $settings['category_title5']; ?>
                                                </h3>
                                            </div>
                                        </a>
                                        <?php if($settings['category_bg5']['url']) : ?>
                                            <div class="wt-hover__reveal-bg background-img" data-background-image="<?php echo $settings['category_bg5']['url']; ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <span class="active-bg"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                    <div class="col-xl-12">
                        <div class="catagori-button common-hover-yellow text-center tw-mt-18">
                            <?php if( 'yes'===$settings['show_button'] ){ ?>
                                <div class="banner-two-button">
                                    <a href="<?php echo esc_url($settings['button_url']); ?>" class="primary-btn bg-white text-main-600 tw-py-5 tw-px-13 fs-15 text-uppercase fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                                        <?php echo $settings['button_text']; ?>
                                        <i class="ph ph-arrow-up-right"></i>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                    </div>
                </div>
                <?php if($settings['top_shape_bg']['url']) : ?>
                    <div class="catagori-shape position-absolute start-0 z-n1 w-100">
                        <img src="<?php echo $settings['top_shape_bg']['url']; ?>" alt="">
                    </div>
                <?php endif; ?>
            </div>
            
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Category_Section_Widget());