<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Button_Widget extends Widget_Base
{

    /**
     * Get widget name.
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'travelor-button-widget';
    }

    /**
     * Get widget title.
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Travelor Button', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Button', 'Travelor'];
    }

    /**
     * Get widget icon.
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-button';
    }

    /**
     * Get widget categories.
     * @return array Widget categories.
     *
     */
    public function get_categories()
    {
        return ['Travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => __('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => __( 'Select Style', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'one' => __( 'One', 'travelor-core' ),
                    'two' => __( 'Two', 'travelor-core' ),
                ],
                'default' => 'one',
            ]
        );
        $this->add_responsive_control(
            'text_alignment',
            [
                'label' => esc_html__('Alignment', 'travelor-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'travelor-core'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'travelor-core'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'travelor-core'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    "{{WRAPPER}} .btn-wrapper" => "text-align: {{VALUE}}"
                ]
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label' => __('Btn text', 'travelor-core'),
                'type' => Controls_Manager::TEXT,
                'description' => __('enter  btn text.', 'travelor-core'),
                'default' => __('explore more', 'travelor-core'),
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => __('Btn url', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => __('Enter  btn url.', 'travelor-core'),
                'default' => __('#', 'travelor-core'),
            ]
        );
        $this->add_control(
            'show_icon',
            [
                'label' => __( 'Show / Hide Icon', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
				'icons_type',
				[
				    'label' => esc_html__('Select Icon or Image','travelor-core'),
				    'type' => \Elementor\Controls_Manager::CHOOSE,
				    'options' =>[
                        'img' =>[
                            'title' =>esc_html__('Image','travelor-core'),
                            'icon' =>'fa fa-picture-o',
                        ],
                        'icon' =>[
                            'title' =>esc_html__('Icon','travelor-core'),
                            'icon' =>'fa fa-info',
                        ],
                        'icon_cls' =>[
                            'title' =>esc_html__('Icon Class','travelor-core'),
                            'icon' =>'fa fa-code',
                        ]
				    ],
				    'default' => 'icon_cls',
				]
			 );
			 
			 $this->add_control(
				'select_icon',
				[
					'label' => esc_html__( 'Select Icon', 'travelor-core' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'condition'=>[
						'icons_type'=> 'icon',
					],
					'label_block' => true,
				]
			);
			
			$this->add_control(
				'select_img',
				[
				    'label' => esc_html__('Select Image','travelor-core'),
				    'type'=> \Elementor\Controls_Manager::MEDIA,
				    
				    'condition' => [
					  'icons_type' => 'img',
				    ]
				]
			);

            $this->add_control(
				'select_class',
				[
					'label' => esc_html__( 'Icon Class', 'travelor-core' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'condition'=>[
						'icons_type'=> 'icon_cls',
					],
					'label_block' => true,
                    'default' => __( 'ph ph-arrow-up-right', 'travelor-core' ),
				]
			);
        
        $this->end_controls_section();

        //style tab start
        $this->start_controls_section(
            'styling_section',
            [
                'label' => __('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_responsive_control(
			'btn_custom_width',
			[
				'label' => __('Btn Width', 'plugin-name'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['%', 'px', 'vw'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'vw' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .primary-btn' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __('Button Padding', 'travelor-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    "{{WRAPPER}} .tw-py-4.tw-px-8" => "padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_padding_hover',
            [
                'label' => __('Button Hover Padding', 'travelor-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    "{{WRAPPER}} .primary-btn.tw-py-4.tw-px-8:hover" => "padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_border_radius',
            [
                'label' => __('Button Border Radius', 'medicol-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    "{{WRAPPER}} .btn-wrapper .tw-rounded-4xl" => "border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_icon_margin',
            [
                'label' => __('Button Icon Margin', 'travelor-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .primary-btn i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control('btn_color', [
            'label' => __('btn Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('btn_bg_color', [
            'label' => __('btn bg Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .bg-main-two-600" => "background-color: {{VALUE}} !important"
            ]
        ]); 
        $this->add_control('btn_before_bg_color', [
            'label' => __('btn before bg Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .primary-btn::before" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('btn_hover_color', [
            'label' => __('btn hover Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .primary-btn.text-main-600:hover" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'btn_extra_typography',
            'label' => __('Btn Typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .btn-wrapper .primary-btn"
        ]);
        $this->add_control('btn_icon_color', [
            'label' => __('btn Icon Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .primary-btn i" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('btn_icon_hover_color', [
            'label' => __('btn Icon hover Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .primary-btn:hover i" => "color: {{VALUE}} !important"
            ]
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
    ?>
    <?php if($settings['select_style']=='one'){ ?>

        <div class="btn-wrapper flex-wrap" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
            <a  href="<?php echo $settings['btn_url'] ?>" class="primary-btn bg-main-two-600 text-main-600 tw-py-4 tw-px-8 fs-15 text-uppercase fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                <?php echo $settings['btn_text'] ?>
                <?php if( 'yes'===$settings['show_icon'] ){ ?>
                    <?php if($settings['icons_type'] == 'icon' ) : ?>
                        <i class=" <?php echo esc_attr($settings['select_icon']['value']); ?>"></i>
                    <?php elseif($settings['icons_type'] == 'img' ) : ?>
                        <img src="<?php echo $settings['select_img']['url'];?>" alt=""/>
                    <?php else: ?>
                        <i class="<?php echo esc_attr($settings['select_class']); ?>"></i>
                    <?php endif; ?>
                <?php } ?>
            </a> 
        </div>

        <?php }elseif($settings['select_style']=='two'){ ?>
            
            <div>
                <a class="d-flex align-items-center tw-gap-3 tw-text-sm text-main-two-600" href="<?php echo $settings['btn_url'] ?>">
                    <?php echo $settings['btn_text'] ?>
                    <?php if( 'yes'===$settings['show_icon'] ){ ?>
                        <?php if($settings['icons_type'] == 'icon' ) : ?>
                            <span>
                                <i class=" <?php echo esc_attr($settings['select_icon']['value']); ?>"></i>
                            </span>
                        <?php elseif($settings['icons_type'] == 'img' ) : ?>
                            <span>
                                <img src="<?php echo $settings['select_img']['url'];?>" alt=""/>
                            </span>
                        <?php else: ?>
                            <span>
                                <i class="<?php echo esc_attr($settings['select_class']); ?>"></i>
                            </span>
                        <?php endif; ?>
                    <?php } ?>
                </a>
            </div>

        <?php } ?>
    <?php
    }
}
Plugin::instance()->widgets_manager->register(new Travelor_Button_Widget());