<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Breadcrumb_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-breadcrumb-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Breadcrumb', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Breadcrumb', 'Title', "HugeBinary", 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-t-letter';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'breadcrumb_section',
            [
                'label' => esc_html__('Breadcrumb Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $page_id = travelor()->page_id();
        $check_page = (!is_home() && !is_front_page() && is_singular()) || is_search() || is_author() || is_404() || is_archive() ? true : false;
        $check_home_page = travelor()->is_home_page();
        $header_variant_class = isset($page_header_meta['navbar_type']) ? 'navbar-' . $page_header_meta['navbar_type'] : 'navbar-default';
        $breadcrumb_enable = cs_get_option('breadcrumb_enable');
        ?>
        <?php if(!empty($breadcrumb_enable)){ ?>    
            <?php if (travelor()->is_travelor_core_active()) : ?>    
                <div class="breadcrumb-wrap breadcrumb-area breadcrumb-wrap-icon bg-cover py-120 gradient-overlay-five <?php echo esc_attr($header_variant_class); ?>">
            <?php else : ?>     
                <div class="breadcrumb-wrap breadcrumb-area background-img gradient-overlay-five  bg-cover  <?php echo esc_attr($header_variant_class); ?>">
            <?php endif; ?>
                <div class="container">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="breadcrumb-content text-center">
                                    <?php
                                    if (is_archive()) {
                                        if (class_exists('WooCommerce') && is_shop()) {
                                            printf('<h2 class="page-title">%1$s </h2>', str_replace("Archives: ", "", get_the_archive_title()));
                                        } else {
                                            the_archive_title('<h2 class="page-title">', '</h2>');
                                        }
                                    } elseif (is_404()) {
                                        printf('<h2 class="page-title">%1$s</h2>', esc_html__('Error 404', 'travelor'));
                                    } elseif (is_search()) {
                                        printf('<h2 class="page-title">%1$s %2$s</h2>', esc_html__('Search Results for:', 'travelor'), get_search_query());
                                    } elseif (is_singular('post')) {
                                        printf('<h2 class="page-title">%1$s </h2>', get_the_title());
                                    } elseif (is_singular('page')) {
                                        printf('<h2 class="page-title">%1$s </h2>', get_the_title());
                                    } else {
                                        printf('<h2 class="page-title">%1$s </h2>', get_the_title($page_id));
                                    }
                                    travelor_breadcrumb();
                                    ?>
                                </div>
                            </div>
                        </div>
                </div>
            </div> 
        <?php
        }
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Breadcrumb_Widget());