<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Blog_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-blog-slider-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Blog Slider One', 'travelor-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'show_button',
            [
                'label' => esc_html__('Button Show/Hide', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'travelor-core'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'btn_text', [
            'label' => esc_html__('Button Text', 'travelor-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Enter button text', 'travelor-core'),
            'default' => esc_html__('Read More', 'travelor-core'),
            'condition' => ['show_button' => 'yes'],
        ]);
        $this->add_control(
            'button_image', [
                'label' => esc_html__('Button Icon img', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Button Icon img', 'travelor-core'),
                'condition' => ['show_button' => 'yes'],
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => __('Btn url', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => __('Enter  btn url.', 'travelor-core'),
                'default' => __('#', 'travelor-core'),
            ]
        );
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'travelor-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'travelor-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => travelor_core()->get_terms_names('category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'travelor-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'travelor-core'),
                'DESC' => esc_html__('Descending', 'travelor-core'),
            ),
            'default' => 'DESC',
            'description' => esc_html__('select order', 'travelor-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'travelor-core'),
                'title' => esc_html__('Title', 'travelor-core'),
                'date' => esc_html__('Date', 'travelor-core'),
                'rand' => esc_html__('Random', 'travelor-core'),
                'comment_count' => esc_html__('Most Comments', 'travelor-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'travelor-core')
        ]);
        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                25 => esc_html__('Short', 'travelor-core'),
                55 => esc_html__('Regular', 'travelor-core'),
                100 => esc_html__('Long', 'travelor-core'),
            ),
            'default' => 25,
            'description' => esc_html__('select excerpt length', 'travelor-core')
        ]);
        
           $this->add_control(
            'image_thumb_display',
            [
                'label' => esc_html__('Image Display', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'travelor-core'),
            ]
        );
        
        $this->add_control(
            'thumb_date',
            [
                'label' => esc_html__('Thumb Date Show/Hide', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'travelor-core'),
            ]
        );
        $this->add_control(
            'details_date',
            [
                'label' => esc_html__('Details Date Show/Hide', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'travelor-core'),
            ]
        );
        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes to show pagination.', 'travelor-core'),
                'default' => 'yes'
            ]
        );
        
          $this->add_control(
            'category_display',
            [
                'label' => esc_html__('Category Display', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('Show  Or Hide Category.', 'travelor-core'),
            ]
        );
        
        $this->add_control(
            'pagination_alignment',
            [
                'label' => esc_html__('Pagination Alignment', 'travelor-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left Align', 'travelor-core'),
                    'center' => esc_html__('Center Align', 'travelor-core'),
                    'right' => esc_html__('Right Align', 'travelor-core'),
                ),
                'description' => esc_html__('you can set pagination alignment.', 'travelor-core'),
                'default' => 'left',
                'condition' => array('pagination' => 'yes')
            ]
        );
        $this->end_controls_section();

        //style tab start
        $this->start_controls_section(
            'title_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
         $this->add_control('normal_post_wrapper_padding', [
            'label' => esc_html__('Grid Padding', 'travelor-core'),
            'type' => Controls_Manager::DIMENSIONS,
             'size_units' => [ 'px', 'em', '%' ],
            'selectors' => [
                "{{WRAPPER}} .group-item" => "padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};",
            ]
        ]);

        $this->add_control(
            'image_radius',
            [
                'label' => esc_html__('Image Radius', 'travelor-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .group-item a img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control('normal_post_title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h5" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h5"
        ]);
        $this->add_control('normal_post_date_color', [
            'label' => esc_html__('Date Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-heading.tw-text-base" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Date Typography', 'travelor-core'),
            'name' => 'date_typography',
            'description' => esc_html__('Date typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .text-heading.tw-text-base"
        ]);
        $this->add_control('normal_post_readmore_color', [
            'label' => esc_html__('button text Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Button Typography', 'travelor-core'),
            'name' => 'button_typography',
            'description' => esc_html__('Button typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .fw-medium.tw-text-lg"
        ]);
        $this->add_control('normal_post_readmore_margin', [
            'label' => esc_html__('Read More Margin', 'travelor-core'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors' => [
                "{{WRAPPER}} .text-main-600" =>  "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};",
            ]
        ]);

        $this->end_controls_tabs();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];

        //other settings
        $pagination = $settings['pagination'] ? false : true;
        $pagination_alignment = $settings['pagination_alignment'];

        //setup query
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>
            <div class="blog-two-area blog-panel-area py-140">
                <div class="container">
					<div class="row align-items-center justify-content-between">
                         <div class="col-xl-6 col-lg-7">
                              <div class="section-wrapper tw-mb-14" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                   <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">news & blogs</h6>
                                   <h2 class="section-title fw-normal tw-mb-7 char-animation">latest news & Blog</h2>
                                   <p class="tw-text-lg fw-normal">communication and utilizes cutting edge logistic planning to get your shipment completed 
                                        on time. itself founded of backgrounds, which simply.</p>
                              </div>
                         </div>
                         <div class="col-xl-3 col-lg-4">
                              <div class="counter-button project-two-button d-flex justify-content-end flex-wrap" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
                              <a class="primary-btn bg-main-two-600 text-main-600 tw-py-4 tw-px-8 fs-15 text-uppercase fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl" href="<?php echo $settings['btn_url'] ?>">explore more <i class="ph ph-arrow-up-right"></i></a> 
                              </div>
                         </div>
                    </div>
                    <?php while ($post_data->have_posts()):$post_data->the_post(); 
                        
                        //image condition here
                        $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                        $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'travelor_grid_blog_12', false) : '';
                        $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                        $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                        $comments_count = get_comments_number(get_the_ID());
                        $comment_text = ($comments_count > 1) ? 'Comments (' . $comments_count . ')' : 'Comment (' . $comments_count . ')';
                        ?>                    
                        <div class="row blog-panel tw-mb-8">
							<div class="col-xl-12">
								<div class="blog-two-wrapper tw-rounded-xl d-flex align-items-center justify-content-between tw-p-2">
									<div class="blog-two-content">
										<div class="blog-two-meta tw-mb-6 tw-ms-4">
											<ul class="d-flex tw-gap-10">
												<li class="fw-medium text-black"><?php echo date('j, M y') ?></li>
												<li class="fw-medium text-black"><?php travelor()->comment_count(); ?></li>
											</ul>
										</div>
										<h4 class="blog-two-title tw-text-9 text-capitalize fw-normal tw-mb-9">
											<a class="hover-text-secondary" href="<?php the_permalink(); ?>">
												<?php echo get_the_title(); ?>
											</a>
										</h4>
										<?php if( 'yes'===$settings['show_button'] ){ ?>
											<div class="blog-two-button">
												<a class="text-black fw-medium d-inline-flex tw-gap-4" href="<?php the_permalink(); ?>">
													<?php echo $settings['btn_text']; ?> 
													<?php if($settings['button_image']['url']) : ?>
													<span>
														<img src="<?php echo $settings['button_image']['url']; ?>" alt="">
													</span>
													<?php endif; ?>
												</a>
											</div>
										<?php } ?>
                                    </div>
                                    <div class="blog-two-thumb">
                                        <a href="<?php the_permalink(); ?>">
                                            <img src="<?php echo esc_url($img_url); ?>" alt="">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php
                    endwhile;
                    wp_reset_query();
                    ?>
                </div>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Blog_Slider_One_Widget());