<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Blog_Grid_List_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-blog-grid-list-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Blog Grid List One', 'travelor-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-box';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'show_top_title',
            [
                'label' => __( 'Show / Hide Top Title', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Insights to help you do what you do better, faster and more profitably.', 'travelor-core'),
            ]
        );

        $this->add_control(
            'show_button',
            [
                'label' => __( 'Show / Hide Button', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Continue reading ', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'Continue reading', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __('Btn url', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => __('Enter  btn url.', 'travelor-core'),
                'default' => __('#', 'travelor-core'),
            ]
        );

        $this->add_control('blog_grid', [
            'label' => esc_html__('Blog Grid', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'col-xl-2' => esc_html__('col-xl-2', 'travelor-core'),
                'col-xl-3' => esc_html__('col-xl-3', 'travelor-core'),
                'col-xl-4' => esc_html__('col-xl-4', 'travelor-core'),
                'col-xl-6' => esc_html__('col-xl-6', 'travelor-core'),
                'col-xl-12' => esc_html__('col-xl-12', 'travelor-core'),
            ),
            'default' => 'col-xl-6',
            'description' => esc_html__('Select Blog Grid', 'travelor-core')
        ]);
        $this->add_control(
            'read_more',
            [
                'label' => esc_html__('Read More Show/Hide', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'travelor-core'),
                'default' => 'yes',
            ]
        );
        $this->add_control('read-btn', [
            'label' => esc_html__('Read More', 'travelor-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('Enter button text', 'travelor-core'),
            'default' => esc_html__('Continue reading', 'travelor-core'),
            'condition' => ['read_more' => 'yes'],
        ]);
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'travelor-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'travelor-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => travelor_core()->get_terms_names('category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'travelor-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'travelor-core'),
                'DESC' => esc_html__('Descending', 'travelor-core'),
            ),
            'default' => 'DESC',
            'description' => esc_html__('select order', 'travelor-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'travelor-core'),
                'title' => esc_html__('Title', 'travelor-core'),
                'date' => esc_html__('Date', 'travelor-core'),
                'rand' => esc_html__('Random', 'travelor-core'),
                'comment_count' => esc_html__('Most Comments', 'travelor-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'travelor-core')
        ]);
        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'travelor-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                25 => esc_html__('Short', 'travelor-core'),
                55 => esc_html__('Regular', 'travelor-core'),
                100 => esc_html__('Long', 'travelor-core'),
            ),
            'default' => 25,
            'description' => esc_html__('select excerpt length', 'travelor-core')
        ]);
        
           $this->add_control(
            'image_thumb_display',
            [
                'label' => esc_html__('Image Display', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'travelor-core'),
            ]
        );
        
        $this->add_control(
            'thumb_date',
            [
                'label' => esc_html__('Thumb Date Show/Hide', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'travelor-core'),
            ]
        );
        $this->add_control(
            'details_date',
            [
                'label' => esc_html__('Details Date Show/Hide', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'travelor-core'),
            ]
        );
        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes to show pagination.', 'travelor-core'),
                'default' => 'yes'
            ]
        );
        
          $this->add_control(
            'category_display',
            [
                'label' => esc_html__('Category Display', 'travelor-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('Show  Or Hide Category.', 'travelor-core'),
            ]
        );
        
        $this->add_control(
            'pagination_alignment',
            [
                'label' => esc_html__('Pagination Alignment', 'travelor-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left Align', 'travelor-core'),
                    'center' => esc_html__('Center Align', 'travelor-core'),
                    'right' => esc_html__('Right Align', 'travelor-core'),
                ),
                'description' => esc_html__('you can set pagination alignment.', 'travelor-core'),
                'default' => 'left',
                'condition' => array('pagination' => 'yes')
            ]
        );
        $this->end_controls_section();

        //style tab start
        $this->start_controls_section(
            'title_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_radius',
            [
                'label' => esc_html__('Image Radius', 'travelor-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .group-item a img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control('normal_post_title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}}  h4.blog-three-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h4.blog-three-title.tw-text-2xl"
        ]);
       
        $this->add_control('normal_post_readmore_color', [
            'label' => esc_html__('button text Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} a.text-white" => "color: {{VALUE}} !important"
            ]
        ]);
         $this->add_control('normal_post_readmore_bg_color', [
            'label' => esc_html__('button bg Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} a.bg-main-600" => "background-color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Button Typography', 'travelor-core'),
            'name' => 'button_typography',
            'description' => esc_html__('Button typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .primary-btn"
        ]);

        $this->end_controls_tabs();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];

        //other settings
        $pagination = $settings['pagination'] ? false : true;
        $pagination_alignment = $settings['pagination_alignment'];

        //setup query
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>
            <div class="blog-grid-one">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-11">
                            <div class="blog-three-wrapper tw-pt-11 tw-pb-20 tw-px-13 tw-rounded-2xl">
                                <?php if( 'yes'===$settings['show_top_title'] ){ ?>
                                    <div class="row">
                                        <div class="blog-three-top d-flex align-items-center justify-content-between flex-wrap row-gap-4 tw-mb-7">
                                            <?php if($settings['title']) : ?>
                                                <div data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                                    <h4 class="tw-text-2xl">
                                                        <?php echo $settings['title']; ?>
                                                    </h4>
                                                </div>
                                            <?php endif; ?>
                                            <?php if( 'yes'===$settings['show_button'] ){ ?>
                                                <div data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
                                                    <a href="<?php echo $settings['button_url']; ?>" class="primary-btn bg-main-two-600 text-main-600 tw-py-4 tw-px-8 fs-15 text-capitalize fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                                                        <?php echo $settings['button_text']; ?>
                                                        <i class="ph ph-arrow-up-right"></i>
                                                    </a>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                <?php } ?>
                                <div class="row">

                                    <?php while ($post_data->have_posts()):$post_data->the_post(); 
                                        
                                        //image condition here
                                        $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                                        $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'travelor_grid_blog_12', false) : '';
                                        $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                                        $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                                        $comments_count = get_comments_number(get_the_ID());
                                        $comment_text = ($comments_count > 1) ? 'Comments (' . $comments_count . ')' : 'Comment (' . $comments_count . ')';
                                        ?>                    

                                        <div class="col-lg-6 col-md-6 <?php echo esc_attr($settings['blog_grid']); ?>">
                                            <div class="blog-three-wrap" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                                <div class="blog-three-thumb tw-rounded-xl overflow-hidden tw-mb-6">
                                                    <a href="<?php the_permalink(); ?>"><img class="w-100" src="<?php echo esc_url($img_url); ?>" alt=""></a>
                                                </div>
                                                <div class="blog-three-meta tw-mb-6">
                                                    <ul class="d-flex tw-gap-4">
                                                        <li class="d-inline-flex align-items-center tw-gap-2">
                                                            <span class="tw-text-xl text-main-600 d-inline-block lh-1">
                                                                <i class="ph ph-user-circle"></i>
                                                            </span> 
                                                            <?php travelor()->posted_by(); ?>
                                                        </li>
                                                        <li class="d-inline-flex align-items-center tw-gap-2">
                                                            <span class="tw-text-xl text-main-600 d-inline-block lh-1">
                                                            <i class="ph ph-chats-circle"></i></span>
                                                            <?php travelor()->comment_count(); ?>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div>
                                                    <h4 class="blog-three-title tw-text-2xl tw-mb-8">
                                                        <a class="hover-text-secondary" href="<?php the_permalink(); ?>">
                                                            <?php echo get_the_title(); ?>
                                                        </a>
                                                    </h4>
                                                    <div class="blog-three-button common-hover-yellow">
                                                        <a href="<?php the_permalink(); ?>" class="primary-btn bg-main-600 text-white tw-py-4 tw-px-8 fs-15 text-capitalize fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                                                            <?php echo $settings['read-btn']; ?> 
                                                            <i class="ph ph-arrow-up-right"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; wp_reset_query(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Blog_Grid_List_Widget());