<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Banner_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-theme-banner-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner 02', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Banner', 'Hero', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-banner';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'banner_content',
            [
                'label' => esc_html__('Banner Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('The Most', 'travelor-core'),
            ]
        );

        $this->add_control(
            'title2',
            [
                'label' => esc_html__('Title2', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Impressive Adventures On The World.', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('where soft sands meet crystal-clear waters under endless blue skies. 
                                                        Whether you seek relaxation, adventure,', 'travelor-core'),
            ]
        );
        $this->add_control(
            'show_button',
            [
                'label' => __( 'Show / Hide Button', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'See all destination', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Link Here', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'banner_bg_image', [
                'label' => esc_html__('Banner BG Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Banner BG Image', 'travelor-core'),
            ]
        );
        $this->add_control(
            'banner_shape_image', [
                'label' => esc_html__('Shape Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Shape Image', 'travelor-core'),
            ]
        );
        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

    
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-main-600" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .banner-title"
        ]);

        $this->add_control('title2_color', [
            'label' => esc_html__('Title2 Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .banner-title .text-white" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title2 Typography', 'travelor-core'),
            'name' => 'title2_typography',
            'description' => esc_html__('Title2 typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .banner-title"
        ]);

        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .banner-paragraph.text-white" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .banner-paragraph.tw-text-lg"
        ]);


        $this->add_control('button_color', [
            'label' => esc_html__('Button Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .primary-btn.text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('btn_bg_color', [
            'label' => esc_html__('btn bg Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .bg-main-two-600" => "background: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Button Typography', 'travelor-core'),
            'name' => 'button_typography',
            'description' => esc_html__('Button typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .primary-btn.font-heading"
        ]);

        $this->add_control('btn_before_color', [
            'label' => esc_html__('btn before Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .primary-btn::before" => "background: {{VALUE}} !important"
            ]
        ]);
        
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
            <div id="scrollSmoother-container">
                <div class="banner-area pd-top-120 position-relative z-1">
                    <div class="banner-bg background-img position-absolute w-100 bottom-0 start-0 z-n1" data-background-image="<?php echo $settings['banner_bg_image']['url']; ?>">

                    </div>
                    <div class="container">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="banner-wrapper">
                                    <h1 class="banner-title fw-normal text-center text-white tw-mb-28 char-animation">
                                        <?php if($settings['title']) : ?>
                                            <span class="d-inline-block text-main-600">
                                                <?php echo $settings['title']; ?>
                                            </span> <br> 
                                        <?php endif; ?>
                                        <?php echo $settings['title2']; ?>
                                    </h1>
                                    <div class="d-flex justify-content-between flex-wrap row-gap-3">
                                        <?php if($settings['description']) : ?>
                                            <div>
                                                <p class="banner-paragraph tw-text-lg fw-semibold font-dmsans text-white">
                                                    <?php echo $settings['description']; ?>
                                                </p>
                                            </div>
                                        <?php endif; ?>
                                        <?php if( 'yes'===$settings['show_button'] ){ ?>
                                            <div class="banner-button">
                                                <a href="<?php echo esc_url($settings['button_url']); ?>" class="primary-btn bg-main-two-600 text-main-600 tw-py-5 tw-px-18 fs-15 text-capitalize fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                                                    <?php echo $settings['button_text']; ?>
                                                    <i class="ph ph-arrow-up-right"></i>
                                                </a>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if($settings['banner_shape_image']['url']) : ?>
                        <div class="banner-bg-shape position-absolute w-100 start-0 z-n1">
                            <img src="<?php echo $settings['banner_shape_image']['url']; ?>" alt="">
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Banner_Two_Widget());