<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Banner_Three_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-theme-banner-three-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner 03', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Banner', 'Hero', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-banner';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'banner_content',
            [
                'label' => esc_html__('Banner Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Trusted, Fast & Affordable Service at Your Doorstep.', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Discover New', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title2',
            [
                'label' => esc_html__('Title2', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Destinationss', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title3',
            [
                'label' => esc_html__('Title3', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('world Travel Experts', 'travelor-core'),
            ]
        );
        $this->add_control(
            'show_button',
            [
                'label' => __( 'Show / Hide Button', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'See all destination ', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
            ]
        );

         $this->add_control(
            'banner_bg_image', [
                'label' => esc_html__('Banner BG Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Banner BG Image', 'travelor-core'),
            ]
        );
        $this->add_control(
            'banner_bg_shape_image', [
                'label' => esc_html__('BG Shape Image', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('BG Shape Image', 'travelor-core'),
            ]
        );

        $this->add_control(
            'banner_shape_image1', [
                'label' => esc_html__('Shape Image1', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Shape Image1', 'travelor-core'),
            ]
        );
        $this->add_control(
            'banner_shape_image2', [
                'label' => esc_html__('Shape Image2', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Shape Image2', 'travelor-core'),
            ]
        );
        $this->add_control(
            'banner_shape_image3', [
                'label' => esc_html__('Shape Image3', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('Shape Image3', 'travelor-core'),
            ]
        );


        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .banner-three-subtitle.text-white" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .banner-three-subtitle"
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .banner-three-title.text-white" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .banner-three-title"
        ]);

        $this->add_control('button_color', [
            'label' => esc_html__('Button Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('btn_bg_color', [
            'label' => esc_html__('btn bg Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .bg-white" => "background: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Button Typography', 'travelor-core'),
            'name' => 'button_typography',
            'description' => esc_html__('Button typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .primary-btn"
        ]);

        $this->add_control('btn_before_color', [
            'label' => esc_html__('btn before Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .common-hover-yellow .primary-btn::before" => "background: {{VALUE}} !important"
            ]
        ]);
        
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
            
            <div class="banner-three-space tw-px-20">
                <div class="banner-three-area tw-rounded-3xl background-img position-relative z-1 overflow-hidden" data-background-image="<?php echo $settings['banner_bg_image']['url']; ?>">
                    <div class="container">
                        <div class="row">
                            <div class="col-xl-7 col-lg-9">
                                <div class="position-relative z-1">
                                    <?php if($settings['sub_title']) : ?>
                                        <h6 class="banner-three-subtitle font-sofia fw-normal text-capitalize text-white tw-mb-7">
                                            <?php echo $settings['sub_title']; ?>
                                        </h6>
                                    <?php endif; ?>
                                    <?php if($settings['title']) : ?>
                                        <h1 class="banner-three-title text-white tw-mb-13 char-animation">
                                            <?php echo $settings['title']; ?>
                                            <?php if($settings['title2']) : ?>
                                                <span class="position-relative z-1">
                                                    <?php echo $settings['title2']; ?>
                                                </span> 
                                            <?php endif; ?>
                                            <?php if($settings['title3']) : ?>
                                                <?php echo $settings['title3']; ?>
                                            <?php endif; ?>
                                        </h1>
                                    <?php endif; ?>
                                    <?php if( 'yes'===$settings['show_button'] ){ ?>
                                    <div class="banner-three-button common-hover-yellow">
                                        <a href="<?php echo esc_url($settings['button_url']); ?>" class="primary-btn bg-white text-main-600 tw-py-5 tw-px-10 text-capitalize fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                                            <?php echo $settings['button_text']; ?> 
                                            <i class="ph ph-arrow-up-right"></i>
                                        </a>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="banner-three-shape">
                        <?php if($settings['banner_shape_image1']['url']) : ?>
                            <img class="banner-three-shape-1 position-absolute start-0 top-0 z-n1" src="<?php echo $settings['banner_shape_image1']['url']; ?>" alt="">
                        <?php endif; ?>
                        <?php if($settings['banner_shape_image2']['url']) : ?>
                            <img class="banner-three-shape-2 position-absolute end-0 z-n1" src="<?php echo $settings['banner_shape_image2']['url']; ?>" alt="">
                        <?php endif; ?>
                        <?php if($settings['banner_shape_image3']['url']) : ?>
                            <img class="banner-three-shape-3 position-absolute end-0 bottom-0 z-n1" src="<?php echo $settings['banner_shape_image3']['url']; ?>" alt="">
                        <?php endif; ?>
                        <?php if($settings['banner_bg_shape_image']['url']) : ?>
                            <img class="banner-three-shape-4 position-absolute start-0 z-n1" src="<?php echo $settings['banner_bg_shape_image']['url']; ?>" alt="">
                        <?php endif; ?>
                    </div>
                </div>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Banner_three_Widget());