<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Advance_Image_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-advance-image-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Image Travelor', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['img', 'image', 'advance', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-featured-image';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'image_content',
            [
                'label' => esc_html__('Image Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

           $repeater->add_control(
                'image', [
                    'label' => esc_html__('Main Image', 'medicol-core'),
                    'type' => Controls_Manager::MEDIA,
                    'show_label' => false,
                    'description' => esc_html__('Upload image', 'medicol-core'),
                ]
            );

			
            $this->add_control('image_items', [
            'label' => esc_html__('Image Item', 'medicol-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        
        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

            $image_items = $settings['image_items'];

        ?>
            
            <div class="advance-area position-relative z-1">
                <div class="advance-wrap advance-two-wrap">
                    <?php foreach ($image_items as $item): ?>
                        <?php if($item['image']['url']) : ?>
                            <div class="advance-two-item">
                                <div class="advance-two-thumb">
                                    <img src="<?php echo $item['image']['url']; ?>" alt="">
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Advance_Image_Widget());