<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Advance_Category_Section_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-advance-category-section-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('advance category Section', 'travelor-core');
    }

    public function get_keywords()
    {
        return [ 'image','img', 'category', 'advance', 'title', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'title_content',
            [
                'label' => esc_html__('Advance Category Section', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
    
        $this->add_control(
            'show_title',
            [
                'label' => __( 'Show / Hide title', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Tour catagories', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Explore Our Tour Categories Adventure, Culture & More', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('communication and utilizes cutting edge logistic planning to get your shipment completed on time. itself founded of backgrounds, which simply.', 'travelor-core'),
            ]
        );
    
            $repeater = new \Elementor\Repeater();

                $repeater->add_control(
                    'category_image', [
                        'label' => esc_html__('Category Image', 'travelor-core'),
                        'type' => Controls_Manager::MEDIA,
                        'show_label' => true,
                        'description' => esc_html__('Category Image', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'category_title',
                    [
                        'label' => esc_html__('Title', 'travelor-core'),
                        'type' => Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Nature & Wildlife', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'btn_icon_image', [
                        'label' => esc_html__('Button Icon Image', 'travelor-core'),
                        'type' => Controls_Manager::MEDIA,
                        'show_label' => true,
                        'description' => esc_html__('Button Icon Image', 'travelor-core'),
                    ]
                );
                $repeater->add_control(
                    'button_url',
                    [
                        'label' => __( 'Button Link', 'travelor-core' ),
                        'type' => Controls_Manager::TEXTAREA,
                        'placeholder' => __( 'Enter Your Link Here', 'travelor-core' ),
                    ]
                );

                $this->add_control('advance_category_items', [
                'label' => esc_html__('Image Slider Item', 'medicol-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => array(
                            'url' => Utils::get_placeholder_image_src()
                        )
                    ]
                ],
            ]);

            
            $this->add_control(
                'category_shape_image1', [
                    'label' => esc_html__('Shape Image One', 'travelor-core'),
                    'type' => Controls_Manager::MEDIA,
                    'show_label' => true,
                    'description' => esc_html__('Shape Image One', 'travelor-core'),
                ]
            );
            $this->add_control(
                'category_shape_image2', [
                    'label' => esc_html__('Shape Image Two', 'travelor-core'),
                    'type' => Controls_Manager::MEDIA,
                    'show_label' => true,
                    'description' => esc_html__('Shape Image Two', 'travelor-core'),
                ]
            );

        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .section-subtitle" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .section-subtitle.font-sofia.tw-text-2xl"
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.section-title" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.section-title"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.tw-text-lg" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.tw-text-lg"
        ]);
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Title Margin', 'travelor-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					"{{WRAPPER}} .tw-mb-14" => "margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important",
				],
			]
		);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $advance_category_items = $settings['advance_category_items'];

        ?>
            
            <div class="advance-area py-140 position-relative z-1">
                <div class="container">
                    <?php if( 'yes'===$settings['show_title'] ){ ?>
                        <div class="row justify-content-center">
                            <div class="col-xl-8"> 
                                <div class="section-wrapper text-center tw-mb-14" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                    <?php if($settings['subtitle']) : ?>
                                        <h6 class="section-subtitle font-sofia tw-text-2xl fw-normal tw-mb-4">
                                            <?php echo $settings['subtitle']; ?>
                                        </h6>
                                    <?php endif; ?>
                                    <?php if($settings['title']) : ?>
                                        <h2 class="section-title fw-normal tw-mb-7 char-animation">
                                            <?php echo $settings['title']; ?>
                                        </h2>
                                    <?php endif; ?>
                                    <?php if($settings['description']) : ?>
                                        <p class="section-paragraph tw-text-lg fw-normal">
                                            <?php echo $settings['description']; ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="advance-wrap">
                                 <?php foreach ($advance_category_items as $item): ?>
                                    <div class="advance-item">
                                        <?php if($item['category_image']['url']) : ?>
                                            <div class="advance-thumb">
                                                <img src="<?php echo $item['category_image']['url']; ?>" alt="">
                                            </div>
                                        <?php endif ?>
                                        <div class="advance-content d-flex align-items-center justify-content-between flex-wrap tw-px-4 tw-py-4">
                                            <?php if($item['category_title']) : ?>
                                                <h6 class="tw-text-2xl fw-normal mb-0">
                                                    <?php echo $item['category_title']; ?>
                                                </h6>
                                            <?php endif; ?>
                                            <?php if($item['btn_icon_image']['url']) : ?>
                                                <a class="advance-btn" href="<?php echo esc_url($item['button_url']); ?>">
                                                    <span>
                                                        <img src="<?php echo $item['btn_icon_image']['url']; ?>" alt="">
                                                    </span>
                                                </a>
                                            <?php endif ?>
                                        </div>
                                    </div>
                                 <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="advance-bg-shape">
                    <?php if($settings['category_shape_image1']['url']) : ?>
                        <img class="advance-bg-shape-1 position-absolute start-0 z-n1" src="<?php echo $settings['category_shape_image1']['url']; ?>" alt="">
                    <?php endif ?>
                    <?php if($settings['category_shape_image2']['url']) : ?>
                        <img class="advance-bg-shape-2 position-absolute top-0 end-0 z-n1" src="<?php echo $settings['category_shape_image2']['url']; ?>" alt="">
                    <?php endif ?>
                </div>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Advance_Category_Section_Widget());