<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_Accordion_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-accordion-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Accordion 02', 'travelor-core');
    }
    public function get_keywords()
    {
        return ['accordion', 'faq', 'Travelor'];
    }
    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['medicol_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => __( 'Select Style', 'travelor-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'one' => __( 'One', 'travelor-core' ),
                    'two' => __( 'Two', 'travelor-core' ),
                ],
                'default' => 'one',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'accordion_title', [
                'label' => esc_html__('Accordion Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('Enter Title.', 'travelor-core'),
                'default' => esc_html__('How does GoDaddy help small business owners succeed?', 'travelor-core')
            ]
        );
        $repeater->add_control(
            'content_title', [
                'label' => esc_html__('Content', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('Enter Description.', 'travelor-core'),
                'default' => esc_html__('GoDaddy offers more than just a platform to build your website, we offer everything you need to create an effective, memorable online presence. Already have a site? We offer hosting plans that will keep it fast, secure and online. Our professional', 'travelor-core')
            ]
        );
        $this->add_control('accordion_items', [
            'label' => esc_html__('Accordion Item', 'travelor-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        
             
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .accordion-button" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .faq-accordion-button"
        ]);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .faq-accordion-body p" => "color: {{VALUE}} !important"
            ],
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [ 
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .faq-accordion-body p"
        ]);
       




        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $accordion_items = $settings['accordion_items'];
        $random_number = rand(999, 999999);
        ?>


        <?php if($settings['select_style']=='one'){ ?>
           
           
            
            <div class="package-details-faq" data-aos-duration="1000" data-aos-delay="300">
               
                <div class="faq-wrapper">
                     <div class="accordion" id="general_faqaccordion">
                         <?php $i = 0; foreach ($accordion_items as $item): ?>
                            <?php
                                $j = '';
                                $k = '';
                                if($i < 1) {
                                    $j = 'show';
                                    $k = 'collapsed';
                                    $l = '';
                                }else {
                                    $k = '';
                                    $l = 'collapsed';
                                }
                            ?>
                         
                              <div class="accordion-item faq-accordion-item">
                                   <h2 class="accordion-header" id="order_one">
                                        <button class="accordion-button faq-accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#order__collapse_one" aria-expanded="true" aria-controls="order__collapse_one">
                                             <?php echo esc_html($item['accordion_title']); ?>
                                        </button>
                                   </h2>
                                   <div id="order__collapse_one" class="accordion-collapse collapse" aria-labelledby="order_one" data-bs-parent="#general_faqaccordion">
                                        <div class="accordion-body faq-accordion-body">
                                             <p>
                                                <?php echo esc_html($item['content_title']); ?>
                                             </p>
                                        </div>
                                   </div>
                              </div>
                         <?php $i++; endforeach; ?>
                     </div>
                </div>
           </div>
            

            <?php }elseif($settings['select_style']=='two'){ ?>
                
            <?php } ?>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_Accordion_Two_Widget());