<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_About_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-theme-about-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('About 02', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Section', 'about', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-about';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'about_content',
            [
                'label' => esc_html__('About Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We specialize in providing innovative', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title2',
            [
                'label' => esc_html__('Title2', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('tourist', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title3',
            [
                'label' => esc_html__('Title3', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('solutions tailored to meet the unique needs of our clients.', 'travelor-core'),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('About Us', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('tourist hires great people from a Real Transport Inc was founded of backgrounds, which simply makes tourist hires great people from a Real Transport stronger and we couldn’t be prouder elevating your optimizing Busines and incorporated in 1997 in Milwaukee Wisconsin experienced team provides unparalleled service,', 'travelor-core'),
            ]
        );
        $this->add_control(
            'show_button',
            [
                'label' => __( 'Show / Hide Button', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'explore more', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Link Here', 'travelor-core' ),
            ]
        );

        $this->add_control(
            'about_image1', [
                'label' => esc_html__('About Image One', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('About Image One', 'travelor-core'),
            ]
        );
        $this->add_control(
            'about_image2', [
                'label' => esc_html__('About Image Two', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('About Image Two', 'travelor-core'),
            ]
        );

        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h6.text-main-two-600" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h6.tw-text-7"
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.about-three-title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .about-three-title.tw-text-15"
        ]);

        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} p.text-main-600" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} p.tw-text-lg"
        ]);

        $this->add_control('button_color', [
            'label' => esc_html__('Button Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} a.text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('btn_bg_color', [
            'label' => esc_html__('btn bg Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .bg-main-two-600" => "background: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Button Typography', 'travelor-core'),
            'name' => 'button_typography',
            'description' => esc_html__('Button typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .primary-btn"
        ]);

        $this->add_control('btn_before_color', [
            'label' => esc_html__('btn before Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .primary-btn::before" => "background: {{VALUE}} !important"
            ]
        ]);
        
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        
            <div class="about-three-area pt-140">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-5 col-lg-7">
                            <div class="about-three-thumb position-relative z-1" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                <?php if($settings['about_image1']['url']) : ?>
                                    <img src="<?php echo $settings['about_image1']['url']; ?>" alt="">
                                <?php endif; ?>
                                <?php if($settings['about_image2']['url']) : ?>
                                    <div class="about-three-thumb-two position-absolute">
                                        <img src="<?php echo $settings['about_image2']['url']; ?>" alt="">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-7">
                            <div class="about-three-wrapper" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
                                <?php if($settings['title']) : ?>
                                    <h2 class="about-three-title tw-text-15 text-invert fw-normal tw-mb-13">
                                        <?php echo $settings['title']; ?>
                                        <?php if($settings['title2']) : ?>
                                            <span class="position-relative z-1">
                                                <?php echo $settings['title2']; ?>
                                            </span>
                                        <?php endif; ?>
                                        <?php if($settings['title3']) : ?>
                                            <?php echo $settings['title3']; ?>
                                        <?php endif; ?>
                                    </h2>
                                <?php endif; ?>
                                <div class="d-md-flex tw-gap-21">
                                    <?php if($settings['subtitle']) : ?>
                                        <div>
                                            <h6 class="section-subtitle font-sofia tw-text-7 tw-w-30 fw-normal tw-mb-4 text-main-two-600">
                                                <?php echo $settings['subtitle']; ?>
                                            </h6>
                                        </div>
                                    <?php endif; ?>
                                    <div>
                                        <?php if($settings['description']) : ?>
                                            <p class="about-three-paragraph tw-text-lg fw-medium text-main-600 tw-mb-9">
                                                <?php echo $settings['description']; ?>
                                            </p>
                                        <?php endif; ?>
                                         <?php if( 'yes'===$settings['show_button'] ){ ?>
                                            <div class="about-three-button">
                                                <a href="<?php echo $settings['button_url']; ?>" class="primary-btn bg-main-two-600 text-main-600 tw-py-4 tw-px-8 fs-15 text-uppercase fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                                                    <?php echo $settings['button_text']; ?>
                                                    <i class="ph ph-arrow-up-right"></i>
                                                </a>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_About_Two_Widget());