<?php
/**
 * Elementor Widget
 * @package Travelor
 * @since 1.0.0
 */

namespace Elementor;
class Travelor_About_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'travelor-theme-about-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('About 01', 'travelor-core');
    }

    public function get_keywords()
    {
        return ['Section', 'about', 'title', 'Travelor'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-about';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['travelor_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'about_content',
            [
                'label' => esc_html__('About Content', 'travelor-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('about us', 'travelor-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Explore the', 'travelor-core'),
            ]
        );

        $this->add_control(
            'title2',
            [
                'label' => esc_html__('Title2', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('world with expert guidance', 'travelor-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'travelor-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Touriex hires great people from a Real Transport founded of backgrounds, which simply makes stronger and we couldnot be prouder elevating your optimizing Inc was', 'travelor-core'),
            ]
        );
        $this->add_control(
            'show_button',
            [
                'label' => __( 'Show / Hide Button', 'travelor-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'travelor-core' ),
                'label_off' => __( 'Hide', 'travelor-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'Button Text', 'travelor-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __( 'Read More', 'travelor-core' ),
                'label_block' => true,
                'default' => __( 'explore more', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'button_url',
            [
                'label' => __( 'Button Link', 'travelor-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter Link Here', 'travelor-core' ),
            ]
        );
        $this->add_control(
            'about_image1', [
                'label' => esc_html__('About Image One', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('About Image One', 'travelor-core'),
            ]
        );
        $this->add_control(
            'about_image2', [
                'label' => esc_html__('About Image Two', 'travelor-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => true,
                'description' => esc_html__('About Image Two', 'travelor-core'),
            ]
        );

        $this->end_controls_section();


        //Style tab style
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'travelor-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('subtitle_color', [
            'label' => esc_html__('Subtitle Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-subtitle" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Subtitle Typography', 'travelor-core'),
            'name' => 'subtitle_typography',
            'description' => esc_html__('Subtitle typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .about-subtitle.tw-text-2xl"
        ]);

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} h2.about-title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'travelor-core'),
            'name' => 'title_typography',
            'description' => esc_html__('Title typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} h2.about-title"
        ]);

        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .about-paragraph" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'travelor-core'),
            'name' => 'desc_typography',
            'description' => esc_html__('Description typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .about-paragraph.tw-text-lg"
        ]);


        $this->add_control('button_color', [
            'label' => esc_html__('Button Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .primary-btn.text-main-600" => "color: {{VALUE}} !important"
            ]
        ]);
        $this->add_control('btn_bg_color', [
            'label' => esc_html__('btn bg Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .bg-main-two-600" => "background: {{VALUE}} !important"
            ]
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Button Typography', 'travelor-core'),
            'name' => 'button_typography',
            'description' => esc_html__('Button typography', 'travelor-core'),
            'selector' => "{{WRAPPER}} .primary-btn.font-heading"
        ]);

        $this->add_control('btn_before_color', [
            'label' => esc_html__('btn before Color', 'travelor-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .primary-btn::before" => "background: {{VALUE}} !important"
            ]
        ]);
        
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        
            <div class="about-area">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-3">
                            <?php if($settings['subtitle']) : ?>
                                <h6 class="about-subtitle fw-normal font-sofia tw-text-2xl">
                                    <?php echo $settings['subtitle']; ?>
                                </h6>
                            <?php endif; ?>
                        </div>
                        <div class="col-xl-6">
                            <div class="ps-lg-5 tw-mb-14">
                                <h2 class="about-title fw-normal char-animation">
                                    <?php if($settings['title']) : ?>
                                        <?php echo $settings['title']; ?> <br> 
                                    <?php endif; ?>
                                    <?php echo $settings['title2']; ?>
                                </h2>
                            </div>
                        </div>
                    </div>
                    <div class="row align-items-end">
                        <div class="col-xl-8">
                            <div class="about-thumb d-flex tw-gap-8" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                                <?php if($settings['about_image1']['url']) : ?>
                                    <div class="image">
                                        <img class="wow tw-animation-img-left" src="<?php echo $settings['about_image1']['url']; ?>" alt="thumb">
                                    </div>
                                <?php endif; ?>
                                <?php if($settings['about_image2']['url']) : ?>
                                    <div class="image">
                                        <img class="wow tw-animation-img-left" src="<?php echo $settings['about_image2']['url']; ?>" alt="thumb">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-4">
                            <div class="about-wrapper" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
                                <?php if($settings['description']) : ?>
                                    <p class="about-paragraph tw-text-lg fw-medium tw-mb-6">
                                        <?php echo $settings['description']; ?>
                                    </p>
                                <?php endif; ?>
                                <?php if( 'yes'===$settings['show_button'] ){ ?>
                                    <div class="about-button">
                                        <a href="<?php echo esc_url($settings['button_url']); ?>" class="primary-btn bg-main-two-600 text-main-600 tw-py-4 tw-px-8 fs-15 text-uppercase fw-bold font-heading tw-gap-2 d-inline-flex align-items-center tw-rounded-4xl">
                                            <?php echo $settings['button_text']; ?>
                                            <i class="ph ph-arrow-up-right"></i>
                                        </a>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Travelor_About_One_Widget());