<?php
/**
 * Post Column Customize Custom Function
 * @package Travelor
 * @since 1.0.0
 */

if (!defined('ABSPATH')){
    exit(); //exit if access directly
}

if (!class_exists('Travelor_Post_Column_Customize')){
    class Travelor_Post_Column_Customize{
        //$instance variable
        private static $instance;

        public function __construct() {
            //event admin add table value hook
            add_filter("manage_edit-event_columns", array($this, "edit_event_columns") );
            add_action('manage_event_posts_custom_column', array($this, 'add_event_thumbnail_columns'), 10,2);
            //event category icon
            add_filter("manage_edit-event-cat_columns", array($this, "edit_event_cat_columns") );
            add_filter('manage_event-cat_custom_column', array($this, 'add_event_category_columns'), 13, 3);
            //destination admin add table value hook
            add_filter("manage_edit-destination_columns", array($this, "edit_destination_columns") );
            add_action('manage_destination_posts_custom_column', array($this, 'add_destination_thumbnail_columns'), 20,4);
            //destination category icon
            add_filter("manage_edit-destination-cat_columns", array($this, "edit_destination_cat_columns") );
            add_filter('manage_destination-cat_custom_column', array($this, 'add_destination_category_columns'), 23, 4);
            //team admin add table value hook
            add_filter("manage_edit-team_columns", array($this, "edit_team_columns") );
            add_action('manage_team_posts_custom_column', array($this, 'add_team_thumbnail_columns'), 20,4);
            //team category icon
            add_filter("manage_edit-team-cat_columns", array($this, "edit_team_cat_columns") );
            add_filter('manage_team-cat_custom_column', array($this, 'add_team_category_columns'), 23, 4);
        }

        /**
         * get Instance
         * @since 1.0.0
         */
        public static function getInstance(){
            if (null == self::$instance){
                self::$instance = new self();
            }
            return self::$instance;
        }


        /**
         * Edit event
         * @since 1.0.0
         */
        public function edit_event_columns($columns){

            $order = ( 'asc' == $_GET['order'] ) ? 'desc' : 'asc';
            $cat_title = $columns['taxonomy-event-cat'];
            $tag_title = $columns['taxonomy-event-tag'];
            unset($columns);
            $columns['cb'] = '<input type="checkbox" />';
            $columns['title'] = esc_html__('Title','travelor-core');
            $columns['thumbnail'] = '<a href="edit.php?post_type=event&orderby=title&order='.urlencode($order).'">'.esc_html__('Thumbnail','travelor-core').'</a>';
            $columns['taxonomy-event-cat'] = '<a href="edit.php?post_type=event&orderby=taxonomy&order='.urlencode($order).'">'.$cat_title.'<span class="sorting-indicator"></span></a>';
            $columns['taxonomy-event-tag'] = '<a href="edit.php?post_type=tour&orderby=taxonomy&order='.urlencode($order).'">'.$tag_title.'<span class="sorting-indicator"></span></a>';
            $columns['icon'] = esc_html__('Icon','travelor-core');
            $columns['date'] = esc_html__('Date','travelor-core');
            return $columns;
        }

        /**
         * Add event thumbnail
         * @since 1.0.0
         */
        public function add_event_thumbnail_columns($column,$post_id) {
            switch ( $column ) {
                case 'thumbnail' :
                    echo '<a class="row-thumbnail" href="' . esc_url( admin_url( 'post.php?post=' . $post_id . '&amp;action=edit' ) ) . '">' . get_the_post_thumbnail( $post_id, 'thumbnail' ) . '</a>';
                    break;
                case 'icon' :
                    $event_meta_option = get_post_meta($post_id ,'travelor_event_options', true);
                    $event_icon = $event_meta_option['event_icon'];
                    printf('<i class="neaterller-font-size50 %s"></i>',esc_attr($event_icon));
                    break;
                default:
                    break;
            }
        }

        /**
         * Event category column customize
         * @since 1.0.0
         */
        public function edit_event_cat_columns($columns){
            $columns['icon'] = esc_html__('Icon','travelor-core');
            return $columns;
        }

        /**
         * Event Category column add
         * @since 1.0.0
         */
        public function add_event_category_columns($string,$columns,$post_id){
            $post_term_meta = get_term_meta($post_id,'travelor_event_category',true);
            $icon = isset($post_term_meta['icon']) ? $post_term_meta['icon'] : '';
            switch ( $columns ) {
                case 'icon' :
                    echo '<i class="neaterller-font-size50 '.$icon.'"></i>';
                    break;
                default:
                    break;
            }
        }

        /**
         * Edit destination
         * @since 1.0.0
         */
        public function edit_destination_columns($columns){

            $order = ( 'asc' == $_GET['order'] ) ? 'desc' : 'asc';
            $cat_title = $columns['taxonomy-destination-cat'];
            $tag_title = $columns['taxonomy-destination-tag'];
            unset($columns);
            $columns['cb'] = '<input type="checkbox" />';
            $columns['title'] = esc_html__('Title','travelor-core');
            $columns['thumbnail'] = '<a href="edit.php?post_type=destination&orderby=title&order='.urlencode($order).'">'.esc_html__('Thumbnail','travelor-core').'</a>';
            $columns['taxonomy-destination-cat'] = '<a href="edit.php?post_type=destination&orderby=taxonomy&order='.urlencode($order).'">'.$cat_title.'<span class="sorting-indicator"></span></a>';
            $columns['taxonomy-destination-tag'] = '<a href="edit.php?post_type=tour&orderby=taxonomy&order='.urlencode($order).'">'.$tag_title.'<span class="sorting-indicator"></span></a>';
            $columns['icon'] = esc_html__('Icon','travelor-core');
            $columns['date'] = esc_html__('Date','travelor-core');
            return $columns;
        }

        /**
         * Add destination thumbnail
         * @since 1.0.0
         */
        public function add_destination_thumbnail_columns($column,$post_id) {
            switch ( $column ) {
                case 'thumbnail' :
                    echo '<a class="row-thumbnail" href="' . esc_url( admin_url( 'post.php?post=' . $post_id . '&amp;action=edit' ) ) . '">' . get_the_post_thumbnail( $post_id, 'thumbnail' ) . '</a>';
                    break;
                // case 'icon' :
                //     $destination_meta_option = get_post_meta($post_id ,'travelor_destination_options', true);
                //     $destination_icon = $destination_meta_option['destination_icon'];
                //     printf('<i class="neaterller-font-size50 %s"></i>',esc_attr($destination_icon));
                    break;
                default:
                    break;
            }
        }

        /**
         * Destination category column customize
         * @since 1.0.0
         */
        public function edit_destination_cat_columns($columns){
            $columns['icon'] = esc_html__('Icon','travelor-core');
            return $columns;
        }

        /**
         * Destination Category column add
         * @since 1.0.0
         */
        public function add_destination_category_columns($string,$columns,$post_id){
            $post_term_meta = get_term_meta($post_id,'travelor_destination_category',true);
            $icon = isset($post_term_meta['icon']) ? $post_term_meta['icon'] : '';
            switch ( $columns ) {
                case 'icon' :
                    echo '<i class="neaterller-font-size50 '.$icon.'"></i>';
                    break;
                default:
                    break;
            }
        }

        /**
         * Edit team
         * @since 1.0.0
         */
        public function edit_team_columns($columns){

            $order = ( 'asc' == $_GET['order'] ) ? 'desc' : 'asc';
            $cat_title = $columns['taxonomy-team-cat'];
            $tag_title = $columns['taxonomy-team-tag'];
            unset($columns);
            $columns['cb'] = '<input type="checkbox" />';
            $columns['title'] = esc_html__('Title','travelor-core');
            $columns['thumbnail'] = '<a href="edit.php?post_type=team&orderby=title&order='.urlencode($order).'">'.esc_html__('Thumbnail','travelor-core').'</a>';
            $columns['taxonomy-team-cat'] = '<a href="edit.php?post_type=team&orderby=taxonomy&order='.urlencode($order).'">'.$cat_title.'<span class="sorting-indicator"></span></a>';
            $columns['taxonomy-team-tag'] = '<a href="edit.php?post_type=tour&orderby=taxonomy&order='.urlencode($order).'">'.$tag_title.'<span class="sorting-indicator"></span></a>';
            $columns['date'] = esc_html__('Date','travelor-core');
            return $columns;
        }

        /**
         * Add team thumbnail
         * @since 1.0.0
         */
        public function add_team_thumbnail_columns($column,$post_id) {
            switch ( $column ) {
                case 'thumbnail' :
                    echo '<a class="row-thumbnail" href="' . esc_url( admin_url( 'post.php?post=' . $post_id . '&amp;action=edit' ) ) . '">' . get_the_post_thumbnail( $post_id, 'thumbnail' ) . '</a>';
                    break;
                case 'icon' :
                    $team_meta_option = get_post_meta($post_id ,'travelor_team_options', true);
                    $team_icon = $team_meta_option['team_icon'];
                    printf('<i class="neaterller-font-size50 %s"></i>',esc_attr($team_icon));
                    break;
                default:
                    break;
            }
        }

        /**
         * Team category column customize
         * @since 1.0.0
         */
        public function edit_team_cat_columns($columns){
            $columns['icon'] = esc_html__('Icon','travelor-core');
            return $columns;
        }

        /**
         * Team Category column add
         * @since 1.0.0
         */
        public function add_team_category_columns($string,$columns,$post_id){
            $post_term_meta = get_term_meta($post_id,'travelor_team_category',true);
            $icon = isset($post_term_meta['icon']) ? $post_term_meta['icon'] : '';
            switch ( $columns ) {
                case 'icon' :
                    echo '<i class="neaterller-font-size50 '.$icon.'"></i>';
                    break;
                default:
                    break;
            }
        }

    }//end class
    if ( class_exists('Travelor_Post_Column_Customize')){
        Travelor_Post_Column_Customize::getInstance();
    }
}