<?php
/**
 * Theme Custom Post Type(CPTs)
 * @package Travelor
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}

if (!class_exists('Travelor_Custom_Post_Type')) {
    class Travelor_Custom_Post_Type
    {

        //$instance variable
        private static $instance;

        public function __construct()
        {
            //register post type
            add_action('init', array($this, 'register_custom_post_type'));
        }

        /**
         * get Instance
         * @since  2.0.0
         */
        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        /**
         * Register Custom Post Type
         * @since  2.0.0
         */
        public function register_custom_post_type()
        {
            if (!defined('ELEMENTOR_VERSION')) {
                return;
            }
            $all_post_type = array(
                [
                    'post_type' => 'tour',
                    'args' => array(
                        'label' => esc_html__('Tour', 'travelor-core'),
                        'description' => esc_html__('Tour', 'travelor-core'),
                        'labels' => array(
                            'name' => esc_html_x('Tour', 'Post Type General Name', 'travelor-core'),
                            'singular_name' => esc_html_x('Tour', 'Post Type Singular Name', 'travelor-core'),
                            'menu_name' => esc_html__('Tour', 'travelor-core'),
                            'all_items' => esc_html__('Tour', 'travelor-core'),
                            'view_item' => esc_html__('View Tour', 'travelor-core'),
                            'add_new_item' => esc_html__('Add New Tour', 'travelor-core'),
                            'add_new' => esc_html__('Add New Tour', 'travelor-core'),
                            'edit_item' => esc_html__('Edit Tour', 'travelor-core'),
                            'update_item' => esc_html__('Update Tour', 'travelor-core'),
                            'search_items' => esc_html__('Search Tour', 'travelor-core'),
                            'not_found' => esc_html__('Not Found', 'travelor-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'travelor-core'),
                            'featured_image' => esc_html__('Tour Image', 'travelor-core'),
                            'remove_featured_image' => esc_html__('Remove Tour Image', 'travelor-core'),
                            'set_featured_image' => esc_html__('Set Tour Image', 'travelor-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => true,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => true,
                        "rewrite" => array('slug' => 'all-tour', 
                        'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true,
                    )
                ],
                [
                    'post_type' => 'destination',
                    'args' => array(
                        'label' => esc_html__('Destination', 'travelor-core'),
                        'description' => esc_html__('Destination', 'travelor-core'),
                        'labels' => array(
                            'name' => esc_html_x('Destination', 'Post Type General Name', 'travelor-core'),
                            'singular_name' => esc_html_x('Destination', 'Post Type Singular Name', 'travelor-core'),
                            'menu_name' => esc_html__('Destination', 'travelor-core'),
                            'all_items' => esc_html__('Destination', 'travelor-core'),
                            'view_item' => esc_html__('View Destination', 'travelor-core'),
                            'add_new_item' => esc_html__('Add New Destination', 'travelor-core'),
                            'add_new' => esc_html__('Add New Destination', 'travelor-core'),
                            'edit_item' => esc_html__('Edit Destination', 'travelor-core'),
                            'update_item' => esc_html__('Update Destination', 'travelor-core'),
                            'search_items' => esc_html__('Search Destination', 'travelor-core'),
                            'not_found' => esc_html__('Not Found', 'travelor-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'travelor-core'),
                            'featured_image' => esc_html__('Destination Image', 'travelor-core'),
                            'remove_featured_image' => esc_html__('Remove Destination Image', 'travelor-core'),
                            'set_featured_image' => esc_html__('Set Destination Image', 'travelor-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => true,
                        "rewrite" => array('slug' => 'all-destination', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
                [
                    'post_type' => 'team',
                    'args' => array(
                        'label' => esc_html__('team', 'travelor-core'),
                        'description' => esc_html__('team', 'travelor-core'),
                        'labels' => array(
                            'name' => esc_html_x('Team', 'Post Type General Name', 'travelor-core'),
                            'singular_name' => esc_html_x('Team', 'Post Type Singular Name', 'travelor-core'),
                            'menu_name' => esc_html__('Teams', 'travelor-core'),
                            'all_items' => esc_html__('Teams', 'travelor-core'),
                            'view_item' => esc_html__('View Teams', 'travelor-core'),
                            'add_new_item' => esc_html__('Add New Team Member', 'travelor-core'),
                            'add_new' => esc_html__('Add New Team Member', 'travelor-core'),
                            'edit_item' => esc_html__('Edit Team', 'travelor-core'),
                            'update_item' => esc_html__('Update Team', 'travelor-core'),
                            'search_items' => esc_html__('Search Team', 'travelor-core'),
                            'not_found' => esc_html__('Not Found', 'travelor-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'travelor-core'),
                            'featured_image' => esc_html__('Team Image', 'travelor-core'),
                            'remove_featured_image' => esc_html__('Remove Team Image', 'travelor-core'),
                            'set_featured_image' => esc_html__('Set Team Image', 'travelor-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => true,
                        "rewrite" => array('slug' => 'all-team', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ]
            );

            if (!empty($all_post_type) && is_array($all_post_type)) {

                foreach ($all_post_type as $post_type) {
                    call_user_func_array('register_post_type', $post_type);
                }
            }


            /**
             * Custom Taxonomy Register
             * @since 1.0.0
             */

            $all_custom_taxonmy = array(
                array(
                    'taxonomy' => 'tour-cat',
                    'object_type' => 'tour',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Tour Category", 'travelor-core'),
                            "singular_name" => esc_html__("Tour Category", 'travelor-core'),
                            "menu_name" => esc_html__("Tour Category", 'travelor-core'),
                            "all_items" => esc_html__("All Tour Category", 'travelor-core'),
                            "add_new_item" => esc_html__("Add New Tour Category", 'travelor-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'tour-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'destination-cat',
                    'object_type' => 'destination',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Destination Category", 'travelor-core'),
                            "singular_name" => esc_html__("Destination Category", 'travelor-core'),
                            "menu_name" => esc_html__("Destination Category", 'travelor-core'),
                            "all_items" => esc_html__("All Destination Category", 'travelor-core'),
                            "add_new_item" => esc_html__("Add New Destination Category", 'travelor-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'destination-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'team-cat',
                    'object_type' => 'team',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Team Category", 'travelor-core'),
                            "singular_name" => esc_html__("Team Category", 'travelor-core'),
                            "menu_name" => esc_html__("Team Category", 'travelor-core'),
                            "all_items" => esc_html__("All Team Category", 'travelor-core'),
                            "add_new_item" => esc_html__("Add New Team Category", 'travelor-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'team-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                )
            );

            if (is_array($all_custom_taxonmy) && !empty($all_custom_taxonmy)) {
                foreach ($all_custom_taxonmy as $taxonomy) {
                    call_user_func_array('register_taxonomy', $taxonomy);
                }
            }


            /**
             * Custom Tags Register
             * @since 1.0.0
             */

            $all_custom_tags = array(
                array(
                    'taxonomy' => 'tour-tag',
                    'object_type' => 'tour',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Tour Tag", 'travelor-core'),
                            "singular_name" => esc_html__("Tour Tag", 'travelor-core'),
                            "menu_name" => esc_html__("Tour Tag", 'travelor-core'),
                            "all_items" => esc_html__("All Tour Tag", 'travelor-core'),
                            "add_new_item" => esc_html__("Add New Tour Tag", 'travelor-core')
                        ),
                        "public" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'tour-tag'),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                        'hierarchical' => false,
                        'update_count_callback' => '_update_post_term_count',
                    )
                ),
                array(
                    'taxonomy' => 'destination-tag',
                    'object_type' => 'destination',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Destination Tag", 'travelor-core'),
                            "singular_name" => esc_html__("Destination Tag", 'travelor-core'),
                            "menu_name" => esc_html__("Destination Tag", 'travelor-core'),
                            "all_items" => esc_html__("All Destination Tag", 'travelor-core'),
                            "add_new_item" => esc_html__("Add New Destination Tag", 'travelor-core')
                        ),
                        "public" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'destination-tag'),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                        'hierarchical' => false,
                        'update_count_callback' => '_update_post_term_count',
                    )
                ),
                array(
                    'taxonomy' => 'team-tag',
                    'object_type' => 'team',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Team Tag", 'travelor-core'),
                            "singular_name" => esc_html__("Team Tag", 'travelor-core'),
                            "menu_name" => esc_html__("Team Tag", 'travelor-core'),
                            "all_items" => esc_html__("All Team Tag", 'travelor-core'),
                            "add_new_item" => esc_html__("Add New Team Tag", 'travelor-core')
                        ),
                        "public" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'team-tag'),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                        'hierarchical' => false,
                        'update_count_callback' => '_update_post_term_count',
                    )
                ),
            );

            if (is_array($all_custom_tags) && !empty($all_custom_tags)) {
                foreach ($all_custom_tags as $tags) {
                    call_user_func_array('register_taxonomy', $tags);
                }
            }


            flush_rewrite_rules();
        }

    }//end class

    if (class_exists('Travelor_Custom_Post_Type')) {
        Travelor_Custom_Post_Type::getInstance();
    }
}