<?php

/**
 * Theme Options
 * @package travelor
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {

    $allowed_html = travelor()->kses_allowed_html(array('mark'));
    $prefix = 'travelor';
    // Create options
    CSF::createOptions($prefix . '_theme_options', array(
        'menu_title' => esc_html__('Theme Options', 'travelor'),
        'menu_slug' => 'travelor_theme_options',
        'menu_parent' => 'travelor_theme_options',
        'menu_type' => 'submenu',
        'footer_credit' => ' ',
        'menu_icon' => 'fa fa-filter',
        'show_footer' => false,
        'enqueue_webfont' => false,
        'show_search' => true,
        'show_reset_all' => true,
        'show_reset_section' => true,
        'show_all_options' => false,
        'theme' => 'dark',
        'framework_title' => travelor()->get_theme_info('name')
    ));

    /*-------------------------------------------------------
        ** General  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('General', 'travelor'),
        'id' => 'general_options',
        'icon' => 'fas fa-cogs',
    ));
    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Preloader & SVG Enable', 'travelor'),
        'id' => 'theme_general_preloader_options',
        'icon' => 'fa fa-spinner',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Preloader Options', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'preloader_enable',
                'title' => esc_html__('Preloader', 'travelor'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable preloader', 'travelor'), $allowed_html),
                'default' => false,
            ),
			array(
                'id' => 'preloader_image',
                'type' => 'media',
                'title' => esc_html__('Preloader Image', 'travelor'),
                'dependency' => array('preloader_enable', '==', 'true')
            ),
            array(
                'id' => 'preloader_name',
                'type' => 'text',
                'title' => esc_html__('Preloader Name', 'travelor'),
                'default' => esc_html__('TRAVELOR', 'travelor'),
                'dependency' => array('preloader_enable', '==', 'true')
            ),
            array(
                'id' => 'preloader_bg_color',
                'title' => esc_html__('Background Color', 'travelor'),
                'type' => 'color',
                'default' => '#ffffff',
                'desc' => wp_kses(__('you can set <mark>overlay color</mark> for preloader background image', 'travelor'), $allowed_html),
                'dependency' => array('preloader_enable', '==', 'true')
            ),
            array(
                'id' => 'enable_svg_upload',
                'type' => 'switcher',
                'title' => esc_html__('Enable Svg Upload ?', 'travelor'),
                'desc' => esc_html__('If you want to enable or disable svg upload you can set ( YES / NO )', 'travelor'),
                'default' => false,
            ),
        )
    ));

    /*-------------------------------------------------------
           ** Typography  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'typography',
        'title' => esc_html__('Typography', 'travelor'),
        'icon' => 'fas fa-text-height',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Body Font Options', 'travelor') . '</h3>',
            ),
            array(
                'type' => 'typography',
                'title' => esc_html__('Typography', 'travelor'),
                'id' => '_body_font',
                'default' => array(
                    'font-family' => 'Satoshi',
                    'font-size' => '16',
                    'line-height' => '26',
                    'unit' => 'px',
                    'type' => 'google',
                ),
                'color' => false,
                'subset' => false,
                'text_align' => false,
                'text_transform' => false,
                'letter_spacing' => false,
                'line_height' => false,
                'desc' => wp_kses(__('you can set <mark>font</mark> for all html tags (if not use different heading font)', 'travelor'), $allowed_html),
            ),
            array(
                'id' => 'body_font_variant',
                'type' => 'select',
                'title' => esc_html__('Load Font Variant', 'travelor'),
                'multiple' => true,
                'chosen' => true,
                'options' => array(
                    '300' => esc_html__('Light 300', 'travelor'),
                    '400' => esc_html__('Regular 400', 'travelor'),
                    '500' => esc_html__('Medium 500', 'travelor'),
                    '600' => esc_html__('Semi Bold 600', 'travelor'),
                    '700' => esc_html__('Bold 700', 'travelor'),
                    '800' => esc_html__('Extra Bold 800', 'travelor'),
                ),
                'default' => array('400', '500', '600', '700')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading Font Options', 'travelor') . '</h3>',
            ),
            array(
                'type' => 'switcher',
                'id' => 'heading_font_enable',
                'title' => esc_html__('Heading Font', 'travelor'),
                'desc' => wp_kses(__('you can set <mark>yes</mark> to select different heading font', 'travelor'), $allowed_html),
                'default' => true
            ),
            array(
                'type' => 'typography',
                'title' => esc_html__('Typography', 'travelor'),
                'id' => 'heading_font',
                'default' => array(
                    'font-family' => 'Philosopher',
                    'type' => 'google',
                ),
                'color' => false,
                'subset' => false,
                'text_align' => false,
                'text_transform' => false,
                'letter_spacing' => false,
                'font_size' => false,
                'line_height' => false,
                'desc' => wp_kses(__('you can set <mark>font</mark> for  for heading tag .eg: h1,h2,h3,h4,h5,h6', 'travelor'), $allowed_html),
                'dependency' => array('heading_font_enable', '==', 'true')
            ),
            array(
                'id' => 'heading_font_variant',
                'type' => 'select',
                'title' => esc_html__('Load Font Variant', 'travelor'),
                'multiple' => true,
                'chosen' => true,
                'options' => array(
                    '300' => esc_html__('Light 300', 'travelor'),
                    '400' => esc_html__('Regular 400', 'travelor'),
                    '500' => esc_html__('Medium 500', 'travelor'),
                    '600' => esc_html__('Semi Bold 600', 'travelor'),
                    '700' => esc_html__('Bold 700', 'travelor'),
                    '800' => esc_html__('Extra Bold 800', 'travelor'),
                ),
                'default' => array('400', '500', '600', '700'),
                'dependency' => array('heading_font_enable', '==', 'true')
            ),
        )
    ));

    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Back To Top', 'travelor'),
        'id' => 'theme_general_back_top_options',
        'icon' => 'fa fa-arrow-up',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Back Top Options', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'back_top_enable',
                'title' => esc_html__('Back Top', 'travelor'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide back to top', 'travelor'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'back_top_icon',
                'title' => esc_html__('Back Top Icon', 'travelor'),
                'type' => 'icon',
                'default' => 'fa fa-angle-up',
                'desc' => wp_kses(__('you can set <mark>icon</mark> for back to top.', 'travelor'), $allowed_html),
                'dependency' => array('back_top_enable', '==', 'true')
            ),
        )
    ));

    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('sitebar', 'travelor'),
        'id' => 'theme_general_sitebar_options',
        'icon' => 'fa fa-arrow-up',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Sitebar Option', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'sitebar_logo',
                'type' => 'media',
                'title' => esc_html__('Sitebar Logo', 'travelor'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'travelor'), $allowed_html),
            ),
            array(
                'id' => 'sitebar_address',
                'type' => 'text',
                'title' => esc_html__('Sitebar Address', 'travelor'),
                'default' => esc_html__('Lavaca Street, Suite 2000', 'travelor'),
            ),
            array(
                'id' => 'sitebar_phone',
                'type' => 'text',
                'title' => esc_html__('Sitebar phone', 'travelor'),
                'default' => esc_html__('(+880) 172570051', 'travelor'),
            ),
            array(
                'id' => 'sitebar_phone_2',
                'type' => 'text',
                'title' => esc_html__('Sitebar phone 2', 'travelor'),
                'default' => esc_html__('(+880) 172570051', 'travelor'),
            ),
            array(
                'id' => 'sitebar_email',
                'type' => 'text',
                'title' => esc_html__('Sitebar email', 'travelor'),
                'default' => esc_html__('email@evha.com', 'travelor'),
            ),
            array(
                'id' => 'sitebar_email_2',
                'type' => 'text',
                'title' => esc_html__('Sitebar email 2', 'travelor'),
                'default' => esc_html__('email@evha.com', 'travelor'),
            ),
            array(
                'id' => 'gmap_address',
                'type' => 'text',
                'title' => esc_html__('iframe google map Address', 'travelor'),
            ),
            array(
                'id' => 'sitebar_facebook',
                'type' => 'text',
                'title' => esc_html__('Sitebar facebook url', 'travelor'),
                'default' => esc_html__('#', 'travelor'),
            ),
            array(
                'id' => 'sitebar_twitter',
                'type' => 'text',
                'title' => esc_html__('Sitebar twitter url', 'travelor'),
                'default' => esc_html__('#', 'travelor'),
            ),
            array(
                'id' => 'sitebar_instagram',
                'type' => 'text',
                'title' => esc_html__('Sitebar instagram', 'travelor'),
                'default' => esc_html__('#', 'travelor'),
            ),
            array(
                'id' => 'sitebar_linkedin',
                'type' => 'text',
                'title' => esc_html__('Sitebar linkedin', 'travelor'),
                'default' => esc_html__('#', 'travelor'),
            ),
            array(
                'id' => 'map_enable',
                'title' => esc_html__('map Enable', 'travelor'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable preloader', 'travelor'), $allowed_html),
                'default' => true,
            ),
        )
    ));

    /*----------------------------------
        Header & Footer Style
    -----------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Set Header & Footer Type', 'travelor'),
        'id' => 'header_footer_style_options',
        'icon' => 'eicon-banner',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => esc_html__('Global Header Style', 'travelor'),
            ),
            array(
                'id' => 'navbar_type',
                'title' => esc_html__('Navbar Type', 'travelor'),
                'type' => 'image_select',
                'options' => array(
                    '' => TRAVELOR_THEME_SETTINGS_IMAGES . '/header/01.png'
                ),
                'default' => '',
                'desc' => wp_kses(__('you can set <mark>navbar type</mark> it will show in every page except you select specific navbar type form page settings.', 'travelor'), $allowed_html),
            ),
            array(
                'type' => 'subheading',
                'content' => esc_html__('Global Footer Style', 'travelor'),
            ),
            array(
                'id' => 'footer_type',
                'title' => esc_html__('Footer Type', 'travelor'),
                'type' => 'image_select',
                'options' => array(
                    '' => TRAVELOR_THEME_SETTINGS_IMAGES . '/footer/01.png'
                ),
                'default' => '',
                'desc' => wp_kses(__('you can set <mark>footer type</mark> it will show in every page except you select specific navbar type form page settings.', 'travelor'), $allowed_html),
            ),
        )
    ));

    /* Breadcrumb */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Breadcrumb', 'travelor'),
        'id' => 'breadcrumb_options',
        'icon' => ' eicon-product-breadcrumbs',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Breadcrumb Options', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'breadcrumb_enable',
                'title' => esc_html__('Breadcrumb', 'travelor'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide breadcrumb', 'travelor'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'breadcrumb_bg',
                'title' => esc_html__('Background Image', 'travelor'),
                'type' => 'background',
                'desc' => wp_kses(__('you can set <mark>background</mark> for breadcrumb', 'travelor'), $allowed_html),
                'default' => array(
                    'background-size' => '',
                    'background-position' => 'center bottom',
                    'background-repeat' => 'no-repeat',
                ),
                'background_color' => false,
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
            array(
                'id' => 'breadcrumb_bg_color',
                'title' => esc_html__('Breadcrumb Background Color', 'travelor'),
                'type' => 'color',
                'default' => 'rgba(232,0,0, 0.6);',
                'desc' => wp_kses(__('you can set <mark>overlay color</mark> for Breadcrumb background image', 'travelor'), $allowed_html),
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
        )
    ));


    /*-------------------------------------------------------
       ** Entire Site Header  Options
   --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'headers_settings',
        'title' => esc_html__('Headers', 'travelor'),
        'icon' => 'fa fa-home'
    ));

    /* Header Style 01 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header One', 'travelor'),
        'id' => 'theme_header_one_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Header Options', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'header_one_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'travelor'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'travelor'), $allowed_html),
            ),
        )
    ));

    /* Header Style 02 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header Two', 'travelor'),
        'id' => 'theme_header_two_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Navbar Options', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'header_two_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'travelor'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'travelor'), $allowed_html),
            ),
            array(
                'id' => 'header_two_signin_enable',
                'title' => esc_html__('Signin Enable', 'travelor'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable signin', 'travelor'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'header_two_signin_text',
                'type' => 'text',
                'title' => esc_html__('Signin Text', 'travelor'),
                'default' => esc_html__('Sign in', 'travelor'),
                'dependency' => array('header_two_signin_enable', '==', 'true')
            ),
            array(
                'id' => 'header_two_btn_enable',
                'title' => esc_html__('Btn Enable', 'travelor'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable btn', 'travelor'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'header_two_btn_text',
                'type' => 'text',
                'title' => esc_html__('Btn Text', 'travelor'),
                'default' => esc_html__('Get Started', 'travelor'),
                'dependency' => array('header_two_btn_enable', '==', 'true')
            ),
            array(
                'id' => 'header_two_btn_url',
                'type' => 'text',
                'title' => esc_html__('Btn Url', 'travelor'),
                'default' => esc_html__('#', 'travelor'),
                'dependency' => array('header_two_btn_enable', '==', 'true')
            ),
        )
    ));

    /* Header Style 02 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header Three', 'travelor'),
        'id' => 'theme_header_three_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Navbar Options', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'header_three_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'travelor'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'travelor'), $allowed_html),
            ),
            // array(
            //     'id' => 'category_enable',
            //     'title' => esc_html__('Category Enable', 'travelor'),
            //     'type' => 'switcher',
            //     'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable Category', 'travelor'), $allowed_html),
            //     'default' => true,
            // ),
            // array(
            //     'id' => 'search_enable',
            //     'title' => esc_html__('search Enable', 'travelor'),
            //     'type' => 'switcher',
            //     'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable search', 'travelor'), $allowed_html),
            //     'default' => true,
            // ),
            // array(
            //     'id' => 'login_btn_enable',
            //     'title' => esc_html__('login btn Enable', 'travelor'),
            //     'type' => 'switcher',
            //     'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable login btn', 'travelor'), $allowed_html),
            //     'default' => true,
            // ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Navbar Mobile Options', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'header_three_social_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Repeater', 'travelor'),
                'fields' => array(
                    array(
                        'id' => 'header_three_social_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'travelor'),
                    ),
                    array(
                        'id' => 'header_three_social_url',
                        'type' => 'text',
                        'title' => esc_html__('Info URL', 'travelor'),
                        'default' => '#'
                    ),
                )
            ),
        )
    ));

    /*-------------------------------------------------------
           ** Footer  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Footer', 'travelor'),
        'id' => 'footer_options',
        'icon' => 'fa fa-image',
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_general_options',
        'title' => esc_html__('Footer One', 'travelor'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Subscribe settings', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'footer_one_subscribe_bg',
                'type' => 'media',
                'title' => esc_html__('Subscribe Bg', 'travelor'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'travelor'), $allowed_html),
            ),
            array(
                'id' => 'footer_one_subscribe_title',
                'type' => 'text',
                'title' => esc_html__('Subscribe Title', 'travelor'),
                'default' => esc_html__('Join Our Newsletter', 'travelor'),
            ),
            array(
                'id' => 'footer_one_subscribe_content',
                'type' => 'text',
                'title' => esc_html__('Subscribe Content', 'travelor'),
                'default' => esc_html__('Subscribe to our newsletter for the latest updates, news, and exclusive insights straight to your inbox.', 'travelor'),
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Area Options', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'footer_one_bg_image',
                'type' => 'media',
                'title' => esc_html__('Footer Background Image', 'travelor'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'travelor'), $allowed_html),
            ),
            array(
                'id' => 'copyright_one_text',
                'title' => esc_html__('Copyright Area Text', 'travelor'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'travelor'), $allowed_html)
            )
        )
    ));

    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_two_options',
        'title' => esc_html__('Footer Two', 'travelor'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Subscribe settings', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'footer_two_subscribe_bg',
                'type' => 'media',
                'title' => esc_html__('Subscribe Bg', 'travelor'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'travelor'), $allowed_html),
            ),
            array(
                'id' => 'footer_two_subscribe_title',
                'type' => 'text',
                'title' => esc_html__('Subscribe Title', 'travelor'),
                'default' => esc_html__('Join Our Newsletter', 'travelor'),
            ),
            array(
                'id' => 'footer_two_subscribe_content',
                'type' => 'text',
                'title' => esc_html__('Subscribe Content', 'travelor'),
                'default' => esc_html__('Subscribe to our newsletter for the latest updates, news, and exclusive insights straight to your inbox.', 'travelor'),
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Area Options', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'footer_two_bg_image',
                'type' => 'media',
                'title' => esc_html__('Footer Background Image', 'travelor'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'travelor'), $allowed_html),
            ),
            array(
                'id' => 'copyright_two_text',
                'title' => esc_html__('Copyright Area Text', 'travelor'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'travelor'), $allowed_html)
            )
        )
    ));

    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_three_options',
        'title' => esc_html__('Footer Three', 'travelor'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Subscribe settings', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'footer_three_subscribe_bg',
                'type' => 'media',
                'title' => esc_html__('Subscribe Bg', 'travelor'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'travelor'), $allowed_html),
            ),
            array(
                'id' => 'footer_three_subscribe_title',
                'type' => 'text',
                'title' => esc_html__('Subscribe Title', 'travelor'),
                'default' => esc_html__('Join Our Newsletter', 'travelor'),
            ),
            array(
                'id' => 'footer_three_subscribe_content',
                'type' => 'text',
                'title' => esc_html__('Subscribe Content', 'travelor'),
                'default' => esc_html__('Subscribe to our newsletter for the latest updates, news, and exclusive insights straight to your inbox.', 'travelor'),
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Area Options', 'travelor') . '</h3>'
            ),
            array(
                'id' => 'footer_three_bg_image',
                'type' => 'media',
                'title' => esc_html__('Footer Background Image', 'travelor'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> background image</mark> here it will overwrite customizer uploaded logo', 'travelor'), $allowed_html),
            ),
            array(
                'id' => 'copyright_three_text',
                'title' => esc_html__('Copyright Area Text', 'travelor'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'travelor'), $allowed_html)
            )
        )
    ));

    /*-------------------------------------------------------
          ** Blog  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_settings',
        'title' => esc_html__('Blog Settings', 'travelor'),
        'icon' => 'fa fa-book'
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'blog_settings',
        'id' => 'blog_post_options',
        'title' => esc_html__('Blog Post', 'travelor'),
        'icon' => 'fa fa-list-ul',
        'fields' => Travelor_Group_Fields::post_meta('blog_post', esc_html__('Blog Page', 'travelor'))
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'blog_settings',
        'id' => 'blog_single_post_options',
        'title' => esc_html__('Single Post', 'travelor'),
        'icon' => 'fa fa-list-alt',
        'fields' => Travelor_Group_Fields::post_meta('blog_single_post', esc_html__('Blog Single Page', 'travelor'))
    ));

    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'shop_settings',
        'title' => esc_html__('Shop Settings', 'travelor'),
        'icon' => 'fas fa-shopping-basket',
    ));
    /*  Product page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'product_shop_page',
        'title' => esc_html__('Product Page', 'travelor'),
        'parent' => 'shop_settings',
        'icon' => 'fas fa-shopping-basket',
        'fields' => Travelor_Group_Fields::page_layout_options(esc_html__('Product Shop Page', 'travelor'), 'product_shop')
    ));
    /*  Product single page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'product_shop_single_page',
        'title' => esc_html__('Product Single Page', 'travelor'),
        'parent' => 'shop_settings',
        'icon' => 'fas fa-shopping-basket',
        'fields' => array(
            array(
                'id' => 'product_shop_single_page_bg_color',
                'type' => 'color',
                'title' => esc_html__('Page Background Color', 'travelor'),
                'default' => ''
            ),
            array(
                'id' => 'product_shop_single_page_spacing_top',
                'title' => esc_html__('Page Spacing Top', 'travelor'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page content area.', 'travelor'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
            array(
                'id' => 'product_shop_single_page_spacing_bottom',
                'title' => esc_html__('Page Spacing Bottom', 'travelor'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page content area.', 'travelor'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 100,
            ),
        ),
    ));

    /*-------------------------------------------------------
          ** Pages & templates Options
   --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'pages_and_template',
        'title' => esc_html__('Pages Settings', 'travelor'),
        'icon' => 'fa fa-files-o'
    ));
    /*  404 page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => '404_page',
        'title' => esc_html__('404 Page', 'travelor'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-exclamation-triangle',
        'fields' => array(
            array(
                'id' => 'error_bg_switch',
                'title' => esc_html__('404 Image Enable', 'travelor'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide breadcrumb', 'travelor'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'error_bg',
                'title' => esc_html__('404 Image', 'travelor'),
                'type' => 'media',
                'desc' => wp_kses(__('you can set <mark>background</mark> for breadcrumb', 'travelor'), $allowed_html),
                'dependency' => array('error_bg_switch', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('404 Page Options', 'travelor') . '</h3>',
            ),
            array(
                'id' => '404_bg_color',
                'type' => 'color',
                'title' => esc_html__('Page Background Color', 'travelor'),
                'default' => ''
            ),
            array(
                'id' => '404_title',
                'title' => esc_html__('Title', 'travelor'),
                'type' => 'text',
                'info' => wp_kses(__('you can change <mark>title</mark> of 404 page', 'travelor'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('Sorry! The Page Not Found', 'travelor'))
            ),
            array(
                'id' => '404_paragraph',
                'title' => esc_html__('Paragraph', 'travelor'),
                'type' => 'textarea',
                'info' => wp_kses(__('you can change <mark>paragraph</mark> of 404 page', 'travelor'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('Oops! The page you are looking for does not exit. it might been moved or deleted.', 'travelor'))
            ),
            array(
                'id' => '404_button_text',
                'title' => esc_html__('Button Text', 'travelor'),
                'type' => 'text',
                'info' => wp_kses(__('you can change <mark>button text</mark> of 404 page', 'travelor'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('back to home', 'travelor'))
            ),
            array(
                'id' => '404_spacing_top',
                'title' => esc_html__('Page Spacing Top', 'travelor'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page content area.', 'travelor'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
            array(
                'id' => '404_spacing_bottom',
                'title' => esc_html__('Page Spacing Bottom', 'travelor'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page content area.', 'travelor'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
        )
    ));

    /*  blog page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_page',
        'title' => esc_html__('Blog Page', 'travelor'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => Travelor_Group_Fields::page_layout_options(esc_html__('Blog', 'travelor'), 'blog')
    ));
    /*  blog single page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_single_page',
        'title' => esc_html__('Blog Single Page', 'travelor'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => Travelor_Group_Fields::page_layout_options(esc_html__('Blog Single', 'travelor'), 'blog_single')
    ));
    /*  archive page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'archive_page',
        'title' => esc_html__('Archive Page', 'travelor'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-archive',
        'fields' => Travelor_Group_Fields::page_layout_options(esc_html__('Archive', 'travelor'), 'archive')
    ));
    /*  search page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'search_page',
        'title' => esc_html__('Search Page', 'travelor'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-search',
        'fields' => Travelor_Group_Fields::page_layout_options(esc_html__('Search', 'travelor'), 'search')
    ));

    /*-------------------------------------------------------
           ** Backup  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'backup',
        'title' => esc_html__('Import / Export', 'travelor'),
        'icon' => 'eicon-export-kit',
        'fields' => array(
            array(
                'type' => 'notice',
                'style' => 'warning',
                'content' => esc_html__('You can save your current options. Download a Backup and Import.', 'travelor'),
            ),
            array(
                'type' => 'backup',
                'title' => esc_html__('Backup & Import', 'travelor')
            )
        )
    ));
}
