<?php
/**
 * Theme functions & definitations
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package travelor
 */

/**
 * Define Theme Folder Path & URL Constant
 * @package travelor
 * @since 1.0.0
 */

define('TRAVELOR_THEME_ROOT', get_template_directory());
define('TRAVELOR_THEME_ROOT_URL', get_template_directory_uri());
define('TRAVELOR_INC', TRAVELOR_THEME_ROOT . '/inc');
define('TRAVELOR_THEME_SETTINGS', TRAVELOR_INC . '/theme-settings');
define('TRAVELOR_THEME_SETTINGS_IMAGES', TRAVELOR_THEME_ROOT_URL . '/inc/theme-settings/images');
define('TRAVELOR_TGMA', TRAVELOR_INC . '/plugins/tgma');
define('TRAVELOR_DYNAMIC_STYLESHEETS', TRAVELOR_INC . '/theme-stylesheets');
define('TRAVELOR_CSS', TRAVELOR_THEME_ROOT_URL . '/assets/css');
define('TRAVELOR_JS', TRAVELOR_THEME_ROOT_URL . '/assets/js');
define('TRAVELOR_ASSETS', TRAVELOR_THEME_ROOT_URL . '/assets');
define('TRAVELOR_DEV', true);


/**
 * Theme Initial File
 * @package travelor
 * @since 1.0.0
 */
if (file_exists(TRAVELOR_INC . '/theme-init.php')) {
    require_once TRAVELOR_INC . '/theme-init.php';
}


/**
 * Codester Framework Functions
 * @package travelor
 * @since 1.0.0
 */
if (file_exists(TRAVELOR_INC . '/theme-cs-function.php')) {
    require_once TRAVELOR_INC . '/theme-cs-function.php';
}


/**
 * Theme Helpers Functions
 * @package travelor
 * @since 1.0.0
 */
if (file_exists(TRAVELOR_INC . '/theme-helper-functions.php')) {

    require_once TRAVELOR_INC . '/theme-helper-functions.php';
    if (!function_exists('travelor')) {
        function travelor()
        {
            return class_exists('Travelor_Helper_Functions') ? new Travelor_Helper_Functions() : false;
        }
    }
}

/**
 * Nav menu fallback function
 * @since 1.0.0
 */
if (is_user_logged_in()) {
    function travelor_theme_fallback_menu()
    {
        get_template_part('template-parts/default', 'menu');
    }
}